/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.protocols.ldap;

import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDKeyStore;
import com.sap.idm.vds.config.MVDKeyStoreList;
import com.sap.idm.vds.config.MVDLDAPDeployment;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import com.sap.idm.vds.protocols.ldap.MxLdapSession;
import com.sap.idm.vds.util.Base64;
import com.sun.net.ssl.KeyManagerFactory;
import com.sun.net.ssl.SSLContext;
import com.sun.net.ssl.TrustManager;
import com.sun.net.ssl.TrustManagerFactory;
import com.sun.net.ssl.X509TrustManager;
import com.sun.net.ssl.internal.ssl.Provider;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLServerSocketFactory;

public class MxLdapListener
extends Thread {
    private static int LdapThreadID = 0;
    private ServerSocket mServerSocket;
    private boolean mRunning = true;
    private int mPortNumber = 389;
    private MVDLDAPDeployment mLdapDeployment = null;

    public MxLdapListener(MVDLDAPDeployment aLdapDeployment) {
        this.mPortNumber = aLdapDeployment.getPortNumber();
        this.mLdapDeployment = aLdapDeployment;
    }

    private ServerSocket getServerSocket() throws Exception {
        if (this.mLdapDeployment.getSecureServer()) {
            Security.addProvider((java.security.Provider)new Provider());
            KeyStore keystore = KeyStore.getInstance("JKS");
            char[] clearPassword = null;
            String keystoreid = this.mLdapDeployment.getKeystoreID();
            MVDKeyStore akeystoredef = MVDKeyStoreList.getKeyStoreByID(Integer.parseInt(keystoreid));
            clearPassword = akeystoredef.getCertStorePassword().startsWith("{CRYPT}") ? MVDMic_Util.dcString((String)akeystoredef.getCertStorePassword()).toCharArray() : this.Unscramble(akeystoredef.getCertStorePassword());
            keystore.load(new FileInputStream(akeystoredef.getCertStorePath()), clearPassword);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance((String)"SunX509");
            char[] clearCertificatePassword = null;
            clearCertificatePassword = akeystoredef.getCertStorePassword().startsWith("{CRYPT}") ? MVDMic_Util.dcString((String)akeystoredef.getCertStorePassword()).toCharArray() : this.Unscramble(akeystoredef.getCertStorePassword());
            kmf.init(keystore, clearCertificatePassword);
            TrustManager[] tms = null;
            String truststoreid = this.mLdapDeployment.getTrustStoreID();
            MVDKeyStore atruststoredef = MVDKeyStoreList.getKeyStoreByID(Integer.parseInt(truststoreid));
            if (this.mLdapDeployment.getClientAuthentication() && atruststoredef != null) {
                String tstorePath = atruststoredef.getCertStorePath();
                String tstorePwd = MVDMic_Util.dcString((String)atruststoredef.getCertStorePassword());
                if (tstorePath != null && tstorePath.length() > 0 && tstorePwd != null && tstorePwd.length() > 0) {
                    try {
                        TrustManagerFactory tmf = TrustManagerFactory.getInstance((String)"SunX509", (String)"SunJSSE");
                        KeyStore trustStore = KeyStore.getInstance("JKS");
                        trustStore.load(new FileInputStream(tstorePath), tstorePwd.toCharArray());
                        Enumeration<String> en = keystore.aliases();
                        while (en.hasMoreElements()) {
                            String alias = en.nextElement();
                            if (!keystore.isKeyEntry(alias)) continue;
                            Certificate[] cert = keystore.getCertificateChain(alias);
                            for (int i = 0; i < cert.length; ++i) {
                                Certificate certificate = cert[i];
                                String trustalias = "AUTO_TRUST_" + alias;
                                while (trustStore.containsAlias(trustalias)) {
                                    trustalias = trustalias + "_";
                                }
                                trustStore.setCertificateEntry(trustalias, certificate);
                            }
                        }
                        tmf.init(trustStore);
                        tms = tmf.getTrustManagers();
                    }
                    catch (Exception e) {
                        tms = null;
                        MVDLogger.Log("Error initializing truststore", 7, e);
                    }
                }
            } else {
                tms = null;
            }
            SSLContext sslc = SSLContext.getInstance((String)"SSLv3");
            sslc.init(kmf.getKeyManagers(), tms, null);
            SSLServerSocketFactory ssf = sslc.getServerSocketFactory();
            SSLServerSocket serverSocket = null;
            if (MVDProxy.NetworkInterface() == null || MVDProxy.NetworkInterface().length() == 0 || MVDProxy.NetworkInterface().equalsIgnoreCase("all")) {
                serverSocket = (SSLServerSocket)ssf.createServerSocket(this.mPortNumber);
            } else {
                InetAddress a = InetAddress.getByName(MVDProxy.NetworkInterface());
                serverSocket = (SSLServerSocket)ssf.createServerSocket(this.mPortNumber, 1024, a);
            }
            serverSocket.setNeedClientAuth(this.mLdapDeployment.getClientAuthentication());
            if (this.mLdapDeployment.getClientAuthentication() && MVDLogger.IsLogging(4)) {
                try {
                    for (int i = 0; i < tms.length; ++i) {
                        try {
                            X509TrustManager tm = (X509TrustManager)tms[i];
                            X509Certificate[] cert = tm.getAcceptedIssuers();
                            for (int j = 0; j < cert.length; ++j) {
                                MVDLogger.Log("Trusting: " + cert[j].getSubjectDN() + "  serial number: " + cert[j].getSerialNumber().toString(16), 4);
                            }
                            continue;
                        }
                        catch (Exception e) {
                            MVDLogger.Log("Failed checking trust for " + tms[i] + " : " + e, 6);
                        }
                    }
                }
                catch (Throwable t) {
                    // empty catch block
                }
            }
            return serverSocket;
        }
        if (MVDProxy.NetworkInterface() == null || MVDProxy.NetworkInterface().length() == 0 || MVDProxy.NetworkInterface().equalsIgnoreCase("all")) {
            return new ServerSocket(this.mPortNumber, 1024);
        }
        InetAddress a = InetAddress.getByName(MVDProxy.NetworkInterface());
        return new ServerSocket(this.mPortNumber, 1024, a);
    }

    private char[] Unscramble(String inStr) {
        String str;
        int fillFibChar = 64;
        int fillModChar = 35;
        int changeModeLimit = 4;
        long mode = 1L;
        String resStr = "";
        try {
            int currPadLength;
            StringBuffer s = new StringBuffer(new String(Base64.decode(inStr)));
            str = s.reverse().toString();
            int accLength = currPadLength = str.charAt(0) % (changeModeLimit - 1) + 1;
            int x = str.indexOf(fillFibChar);
            if (x > -1) {
                str = str.substring(0, x);
            }
            if ((x = str.indexOf(fillModChar)) > -1) {
                str = str.substring(0, x);
            }
            while (accLength < str.length()) {
                resStr = resStr + str.substring(accLength, accLength + 1);
                if (mode == 1L) {
                    if (++currPadLength == changeModeLimit) {
                        mode = 0L;
                    }
                } else if (--currPadLength == 1) {
                    mode = 1L;
                }
                accLength = accLength + currPadLength + 1;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        str = null;
        char[] result = resStr.toCharArray();
        resStr = null;
        System.gc();
        return result;
    }

    public void execute() throws Exception {
        ++LdapThreadID;
        MVDLogger.Log("Initiating server socket", 0);
        try {
            this.mServerSocket = this.getServerSocket();
        }
        catch (Exception e) {
            throw new Exception("IDS deployment '" + this.mLdapDeployment.getName() + "' (port " + this.mPortNumber + ") : " + e.getMessage(), e);
        }
        boolean doLog = MVDLogger.IsLogging(0);
        ThreadGroup sessions = new ThreadGroup("LDAP Sessions:" + this.mLdapDeployment.getName() + "_" + this.mLdapDeployment.getPortNumber());
        System.out.println("Server started on port " + this.mPortNumber);
        MVDLogger.Log("Server started on port " + this.mPortNumber, 4);
        MVDLogger.LogCat("IDS started listening on port " + this.mPortNumber);
        while (this.mRunning) {
            block10: {
                try {
                    new MxLdapSession(this.mServerSocket.accept(), "" + LdapThreadID, sessions, Globals.getPriorityQueue()).start();
                }
                catch (Exception e) {
                    if (this.mRunning) {
                        MVDLogger.Log("Connection refused:" + e.getMessage(), 2);
                    }
                }
                catch (Error e) {
                    if (!this.mRunning) break block10;
                    MVDLogger.Log("Error:" + e.toString(), 2);
                }
            }
            if (doLog) {
                MVDLogger.Log("Ready for new session ... ", 0);
            }
            ++LdapThreadID;
        }
        Thread[] activeSessions = new Thread[sessions.activeCount()];
        int x = sessions.enumerate(activeSessions);
        for (int i = 0; i < x; ++i) {
            Thread t = activeSessions[i];
            if (t instanceof MxLdapSession) {
                MxLdapSession s = (MxLdapSession)t;
                if (s == null) continue;
                s.close();
                continue;
            }
            MVDLogger.Log("Class is: " + t.getClass(), 1);
        }
    }

    public void shutdown() {
        this.mRunning = false;
        if (this.mServerSocket != null) {
            try {
                System.out.println("Stopped listening on port: " + this.mServerSocket.getLocalPort());
                MVDLogger.Log("Stopped listening on port: " + this.mServerSocket.getLocalPort(), 3);
                MVDLogger.LogCat("IDS stopped listening on port: " + this.mServerSocket.getLocalPort());
                this.mServerSocket.close();
                this.mServerSocket = null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public synchronized void run() {
        super.run();
        try {
            this.execute();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            MVDLogger.Log(e.getMessage(), 7, e);
        }
        catch (Error e) {
            System.out.println("Error: " + e.toString());
            MVDLogger.Log("Error:" + e.toString(), 7, e);
        }
    }
}

