/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.operations;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.MVDError;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.message.MxOperation;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.operations.MVDSearchOperation;

public class SearchOperation
implements MxOperation {
    MVDSearchOperation mvdSearchOperation = null;

    public SearchOperation(MxRequest mxrequest, Engine aEng) {
        this.mvdSearchOperation = new MVDSearchOperation(mxrequest, aEng);
    }

    public MxResponse mxperform() {
        try {
            this.mvdSearchOperation.PrepareMVDSearch();
            this.mvdSearchOperation.EvaluateAndPrepareMVDNodes();
            this.mvdSearchOperation.CarryOutMVDNodeSearches();
            this.mvdSearchOperation.PostProcessResults();
            this.mvdSearchOperation.FetchResultCode();
            MxResponse fullfilledSearch = this.mvdSearchOperation.fetchAllSearchResults();
            return fullfilledSearch;
        }
        catch (MVDException e) {
            String errTmp;
            int opTmp;
            int opRes = e.errNumber();
            String opMess = e.errMessage();
            if (opRes == 0) {
                opTmp = MVDError.GetMapping(opRes);
                errTmp = MVDError.GetAdditionalInfo(opRes);
                MVDLogger.Log("Exception - but no error", 2);
            } else if (opRes < -1000) {
                opTmp = MVDError.GetMapping(opRes);
                errTmp = MVDError.GetAdditionalInfo(opRes);
                if (opRes != -1200) {
                    MVDLogger.Log("Exception: " + errTmp, 4);
                } else {
                    MVDLogger.Log("Exception - but no error", 2);
                }
            } else {
                if (opMess != null && opMess.length() > 0) {
                    MVDLogger.Log("Exception: " + opMess, 6, e);
                }
                opTmp = opRes;
                errTmp = e.errMessage();
            }
            MVDLogger.Log("Returning: opResult:" + opTmp + ",info: (" + errTmp + ")", 2);
            this.mvdSearchOperation.getEngineData().MvdDebit().SetResultCode(opTmp);
            this.mvdSearchOperation.getEngineData().MvdDebit().SetResultMessage(errTmp.toString());
            MVDSearchResults LdapOperationResult = new MVDSearchResults();
            if (opTmp == 99999) {
                LdapOperationResult.setTransBytes(opTmp, this.mvdSearchOperation.masterResults.getTransBytes());
            } else {
                LdapOperationResult.setError(opTmp, errTmp);
            }
            return LdapOperationResult;
        }
        catch (Exception e) {
            MVDSearchResults lm = new MVDSearchResults();
            lm.setError(2, "");
            return lm;
        }
    }
}

