/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.operations;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDAttributeFixInterface;
import com.sap.idm.vds.MVDEngineData;
import com.sap.idm.vds.MVDError;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDGlobals;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.cache.MVDCachePool;
import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDRule;
import com.sap.idm.vds.config.MVDUserGroup;
import com.sap.idm.vds.config.MVDUserGroupList;
import com.sap.idm.vds.ldapv3.AttributeValueAssertion;
import com.sap.idm.vds.ldapv3.Filter;
import com.sap.idm.vds.message.MxCompare;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.message.MxSearch;
import com.sap.idm.vds.operations.MVDNodeSearchOperation;
import com.sap.idm.vds.util.MVDOpUtilities;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Vector;

public class MVDSearchOperation {
    private int mVirtualSearchCounter = 0;
    protected MxSearch mOriginalRequest;
    protected MVDHashMap mEngineGs;
    protected MVDEngineData mEngineData;
    protected Engine mEngine;
    protected Vector mNodesInScope;
    private String mAccumulateMessage;
    private int mAccumulateCode;
    protected MVDRule mRule;
    private boolean mDSEoperation;
    private Vector mUsedForCacheOp = null;
    MVDSearchResults masterResults = null;
    private MVDNodeSearchOperation currentNode;
    Enumeration enumDS;
    private String logPrefix;
    private int mNumberOfEntries;
    private String compactLine;

    protected int getVirtualSearchCounter() {
        return this.mVirtualSearchCounter;
    }

    protected void setVirtualSearchCounter(int i) {
        this.mVirtualSearchCounter = i;
    }

    protected void incVirtualSearchCounter() {
        ++this.mVirtualSearchCounter;
    }

    public Vector NodesInScope() {
        return this.mNodesInScope;
    }

    public int NumberOfEntries() {
        return this.mNumberOfEntries;
    }

    public String AccumulateMessage() {
        return this.mAccumulateMessage;
    }

    public int AccumulateCode() {
        return this.mAccumulateCode;
    }

    public MVDEngineData getEngineData() {
        return this.mEngineData;
    }

    public MVDHashMap EngineGs() {
        return this.mEngineGs;
    }

    public Engine getEngine() {
        return this.mEngine;
    }

    public MxSearch OriginalRequest() {
        return this.mOriginalRequest;
    }

    public MVDSearchOperation(MxRequest lReq, Engine aEng) {
        this.mEngineData = aEng.getEngineData();
        this.mEngineGs = aEng.getEngineGs();
        this.mEngine = aEng;
        this.mOriginalRequest = (MxSearch)lReq;
        this.mDSEoperation = false;
        this.mNodesInScope = new Vector();
    }

    public MVDSearchOperation(MxCompare lReq, Engine aEng, boolean bCompare) {
        this.mEngineData = aEng.getEngineData();
        this.mEngineGs = aEng.getEngineGs();
        MxSearch temp = new MxSearch();
        temp.setStartingPoint(lReq.getStartingPoint());
        Filter xx = new Filter();
        xx.choiceId = 3;
        xx.equalityMatch = new AttributeValueAssertion();
        xx.equalityMatch.assertionValue = MVDUtil.ToUTF8(lReq.getCompValue());
        xx.equalityMatch.attributeDesc = MVDUtil.ToUTF8(lReq.getCompAttr());
        temp.setOperationScope(0);
        temp.setTypesOnly(false);
        temp.setRequestedStructFilter(xx);
        temp.setRequestedAttributes(new Vector());
        temp.setSizeLimit(1);
        temp.setTimeLimit(30);
        this.mOriginalRequest = temp;
        this.mDSEoperation = false;
        this.mNodesInScope = new Vector();
    }

    public boolean TestForCompare() {
        if (this.mNodesInScope.size() == 0) {
            return false;
        }
        MVDNodeSearchOperation VDS = (MVDNodeSearchOperation)this.mNodesInScope.elementAt(0);
        boolean b = false;
        if (VDS != null) {
            MVDSearchResults mRes = VDS.PostNodeProcessResults();
            b = mRes != null && mRes.isOK() && mRes.size() != 0;
        }
        MVDLogger.Log("Result of compare: " + b, 2);
        return b;
    }

    private void DoSub(MVDAcl onThisNode, MVDNodeSearchOperation parent) {
        Enumeration e = onThisNode.getChildren().elements();
        while (e.hasMoreElements()) {
            MVDNodeSearchOperation a = new MVDNodeSearchOperation(this);
            MVDAcl barnet = (MVDAcl)e.nextElement();
            if (barnet.getProhibitSub_Inherited()) {
                if (!MVDLogger.IsLogging(2)) continue;
                MVDLogger.Log("Inherited sub level search not allowed on node: " + barnet.getQName(), 2);
                continue;
            }
            a.SetNodeSearchProperties(barnet, parent);
            this.mNodesInScope.addElement(a);
            this.DoSub(barnet, a);
        }
    }

    private void ConvertReqAttributesByUserGroup() {
        this.logPrefix = "UG(" + this.mEngineData.MvdSessionsUserGroup().Name() + "): Conversion: ";
        if (this.mEngineData.MvdSessionsUserGroup().EnableConvClient()) {
            if (this.mOriginalRequest.getRequestedAttributes().size() > 0) {
                this.mOriginalRequest.setRequestedAttributes(MVDOpUtilities.ConvertAttributes(this.mOriginalRequest.getRequestedAttributes(), this.mEngineData.MvdSessionsUserGroup().MapInAttr()));
                MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.mOriginalRequest.getRequestedAttributes().toString(), 2);
            } else {
                MVDLogger.Log(this.logPrefix + "No conversion possible (all attributes required)", 2);
            }
            this.mOriginalRequest.getRequestedStructFilter().fixFilter(null, null, this.mEngineData.MvdSessionsUserGroup().MapInAttr());
            this.mOriginalRequest.updateFilters();
            if (MVDLogger.IsLogging(2)) {
                MVDLogger.Log(this.logPrefix + "Requested filter: " + this.mOriginalRequest.getRequestedURLFilter(), 2);
            }
        } else {
            MVDLogger.Log(this.logPrefix + "No user group mapping required.", 2);
        }
    }

    private void BasicProhibitionTests(MVDAcl startingPointNode) throws MVDException {
        if (startingPointNode == null) {
            throw new MVDException(-1071);
        }
        this.mRule = startingPointNode.FindProperRule(this.mEngineData.MvdDebit().UserName(), this.mOriginalRequest.getStartingPoint(), this.mEngineData.MvdSessionsUserGroup(), this.mEngineData.ExternalSessionGs());
        if (this.mRule == null) {
            MVDUserGroup tempUG;
            MVDUserGroup ug = this.mEngineData.MvdSessionsUserGroup();
            if (!ug.equals(tempUG = MVDUserGroupList.getUGByID(ug.ID()))) {
                this.mEngineData.RefreshUserGroup();
                this.mRule = startingPointNode.FindProperRule(this.mEngineData.MvdDebit().UserName(), this.mOriginalRequest.getStartingPoint(), this.mEngineData.MvdSessionsUserGroup(), this.mEngineData.ExternalSessionGs());
            }
            if (this.mRule == null) {
                MVDLogger.Log("Proper rule couldn't be found", 2);
                throw new MVDException(-1200);
            }
        }
        if (MVDOpUtilities.IsOperationProhibited(this.mRule, "SEARCH")) {
            MVDLogger.Log("The operation is not allowed for this user", 2);
            throw new MVDException(-1200);
        }
    }

    private void BasicOperationTypeTests(MVDAcl startingPointNode) throws MVDException {
        switch (this.mOriginalRequest.getOperationScope()) {
            case 0: {
                break;
            }
            case 1: {
                if (!startingPointNode.getExpOneLevel()) break;
                if (MVDLogger.IsLogging(3)) {
                    MVDLogger.Log("One-level search not allowed on node: " + this.mOriginalRequest.getStartingPoint(), 3);
                }
                throw new MVDException(-1073);
            }
            case 2: {
                if (!startingPointNode.getProhibitSub_Exact()) break;
                if (MVDLogger.IsLogging(3)) {
                    MVDLogger.Log("Sub search not allowed on node: " + this.mOriginalRequest.getStartingPoint(), 3);
                }
                throw new MVDException(-1074);
            }
        }
    }

    public void PrepareMVDSearch() throws MVDException {
        String tempS;
        MVDLogger.Log("*** Starting search evaluation and preparation phase *** ", 2);
        String tempStartingPoint = "";
        try {
            tempStartingPoint = MVDUtil.NiceDN(this.mOriginalRequest.getStartingPoint());
        }
        catch (MVDException ee) {
            MVDLogger.Log("Invalid starting point:" + this.mOriginalRequest.getStartingPoint(), 2);
            throw new MVDException(-1087);
        }
        this.mOriginalRequest.setStartingPoint(tempStartingPoint);
        this.mEngineData.MvdDebit().SetStartingPoint(this.mOriginalRequest.getStartingPoint());
        this.mEngineData.MvdDebit().SetRequestedAttributes(this.mOriginalRequest.getRequestedAttributes().toString());
        this.mEngineData.MvdDebit().SetOperationType("SEARCH");
        this.mEngineData.MvdDebit().SetOperationSubType(Globals.SearchTypeOperations[this.mOriginalRequest.getOperationScope()]);
        if (MVDProxy.EnforceDNRelation()) {
            this.mEngineData.MvdDebit().SetStartingPoint(this.mOriginalRequest.getStartingPoint());
            MVDAcl bindNameNode = MVDAcl.getChild(MVDOpUtilities.reverseDN(this.mEngineData.MvdDebit().UserName()), this.mEngineData.MvdSessionsUserGroup().ID());
            if (bindNameNode != null || !MVDUtil.isBellowMe(this.mEngineData.MvdDebit().UserName(), this.mOriginalRequest.getStartingPoint())) {
                if (MVDLogger.IsLogging(3)) {
                    MVDLogger.Log("Bind DN: '" + this.mEngineData.MvdDebit().UserName() + "' and starting point for " + "operation: '" + this.mOriginalRequest.getStartingPoint() + "' are not related properly", 3);
                }
                throw new MVDException(-1080);
            }
        }
        if (MVDLogger.IsLogging(4)) {
            tempS = this.mOriginalRequest.getStartingPoint().length() == 0 ? "Search request: <empty>, " + Globals.SearchTypeOperations[this.mOriginalRequest.getOperationScope()] : "Search request: " + this.mOriginalRequest.getStartingPoint() + ", " + Globals.SearchTypeOperations[this.mOriginalRequest.getOperationScope()];
            if (MVDLogger.IsLogging(3)) {
                MVDLogger.Log(tempS, 3);
            } else {
                this.compactLine = tempS;
            }
            tempS = this.mOriginalRequest.getRequestedAttributes().size() > 0 ? "Requested attributes: " + this.mOriginalRequest.getRequestedAttributes().toString() : "Requested attributes: All";
            if (MVDLogger.IsLogging(3)) {
                MVDLogger.Log(tempS, 3);
            } else {
                this.compactLine = this.compactLine + " : " + tempS;
            }
        }
        tempS = this.mOriginalRequest.getRequestedURLFilter();
        this.mEngineData.MvdDebit().SetFilter(tempS);
        if (MVDLogger.IsLogging(4)) {
            tempS = "Requested filter: " + tempS;
            if (MVDLogger.IsLogging(3)) {
                MVDLogger.Log(tempS, 3);
            } else {
                this.compactLine = this.compactLine + " : " + tempS;
                MVDLogger.Log(this.compactLine, 4);
                this.compactLine = "";
            }
        }
        this.mDSEoperation = false;
        if (this.mOriginalRequest.getStartingPoint().length() == 0 && this.mOriginalRequest.getOperationScope() == 0) {
            this.mEngineData.MvdDebit().SetOperationSubType("(rootdse)");
            MVDNodeSearchOperation candidate = new MVDNodeSearchOperation(this);
            candidate.SetNodeType(11);
            this.mNodesInScope.addElement(candidate);
            return;
        }
        if (this.mOriginalRequest.getStartingPoint().equalsIgnoreCase("o=mvdstat") && this.mOriginalRequest.getOperationScope() == 0) {
            this.mEngineData.MvdDebit().SetOperationSubType("(statistic_fetch)");
            MVDNodeSearchOperation candidate = new MVDNodeSearchOperation(this);
            candidate.SetNodeType(44);
            this.mNodesInScope.addElement(candidate);
            return;
        }
        MVDAcl startingPointNode = null;
        if (this.mOriginalRequest.getStartingPoint().length() == 0 && this.mOriginalRequest.getOperationScope() > 0) {
            startingPointNode = MVDAcl.getChild("", this.mEngineData.MvdSessionsUserGroup().ID());
        } else {
            startingPointNode = MVDAcl.getChild(MVDOpUtilities.reverseDN(this.mOriginalRequest.getStartingPoint()), this.mEngineData.MvdSessionsUserGroup().ID());
            this.BasicProhibitionTests(startingPointNode);
        }
        this.ConvertReqAttributesByUserGroup();
        this.BasicOperationTypeTests(startingPointNode);
        switch (this.mOriginalRequest.getOperationScope()) {
            case 0: {
                MVDNodeSearchOperation candiate = new MVDNodeSearchOperation(this);
                candiate.SetNodeSearchProperties(startingPointNode, null);
                this.mNodesInScope.addElement(candiate);
                break;
            }
            case 1: {
                if (!startingPointNode.hasChildren()) {
                    if (!startingPointNode.IsVirtualNode()) {
                        throw new MVDException(0);
                    }
                    MVDNodeSearchOperation candiate = new MVDNodeSearchOperation(this);
                    candiate.SetNodeSearchProperties(startingPointNode, null);
                    this.mNodesInScope.addElement(candiate);
                    break;
                }
                if (startingPointNode.getNodeName().equals("*")) {
                    MVDNodeSearchOperation candiate = new MVDNodeSearchOperation(this);
                    candiate.SetNodeSearchProperties(startingPointNode, null);
                    this.mNodesInScope.addElement(candiate);
                    break;
                }
                Enumeration e = startingPointNode.getChildren().elements();
                while (e.hasMoreElements()) {
                    MVDNodeSearchOperation candiate = new MVDNodeSearchOperation(this);
                    MVDAcl barnet = (MVDAcl)e.nextElement();
                    candiate.SetNodeSearchProperties(barnet, null);
                    this.mNodesInScope.addElement(candiate);
                }
                break;
            }
            case 2: {
                if (!startingPointNode.hasChildren()) {
                    if (!startingPointNode.IsVirtualNode()) {
                        throw new MVDException(0);
                    }
                    MVDNodeSearchOperation candiate = new MVDNodeSearchOperation(this);
                    candiate.SetNodeSearchProperties(startingPointNode, null);
                    this.mNodesInScope.addElement(candiate);
                    break;
                }
                if (startingPointNode.getNodeName().equals("*")) {
                    MVDNodeSearchOperation candiate = new MVDNodeSearchOperation(this);
                    candiate.SetNodeSearchProperties(startingPointNode, null);
                    this.mNodesInScope.addElement(candiate);
                    break;
                }
                this.DoSub(startingPointNode, null);
                break;
            }
        }
    }

    public void EvaluateAndPrepareMVDNodes() {
        MVDNodeSearchOperation VDS;
        int x;
        MVDLogger.Log("*** Starting node evaluation and preparation phase ***", 2);
        Collections.sort(this.mNodesInScope, new ACLPriorityComparator());
        int ls = this.mNodesInScope.size();
        for (x = 0; x < ls; ++x) {
            VDS = (MVDNodeSearchOperation)this.mNodesInScope.elementAt(x);
            try {
                VDS.EvaluateAndPrepareNode(x);
                continue;
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
                continue;
            }
            catch (Throwable e) {
                VDS.SetErrorNumber(MVDError.GetMapping(-1200));
                VDS.SetErrorMessage("");
                MVDLogger.Log("Evaluation error - " + e.getMessage(), 7, e);
            }
        }
        x = 0;
        while (x < this.mNodesInScope.size()) {
            VDS = (MVDNodeSearchOperation)this.mNodesInScope.elementAt(x);
            try {
                if (VDS.ErrorNumber() != -1) {
                    this.mNodesInScope.removeElementAt(x);
                    continue;
                }
                ++x;
            }
            catch (Throwable e) {
                VDS.SetErrorNumber(MVDError.GetMapping(-1200));
                VDS.SetErrorMessage("");
                MVDLogger.Log("Evaluation error cleaning - " + e.getMessage(), 7, e);
            }
        }
    }

    public void CarryOutMVDNodeSearches() {
        MVDNodeSearchOperation VDS;
        MVDLogger.Log("*** Starting node search execution phase ***", 2);
        int restOfRequestedEntries = this.mOriginalRequest.getSizeLimit();
        int ls = this.mNodesInScope.size();
        this.mUsedForCacheOp = this.mOriginalRequest.getRequestedAttributes();
        boolean dontChkCache = false;
        if (MVDCachePool.instance().isCacheEnabled()) {
            int localDataSourceID = -1;
            if (this.mOriginalRequest.getOperationScope() == 0) {
                MVDDataSource aDS = ((MVDNodeSearchOperation)this.mNodesInScope.elementAt(0)).DataSource();
                if (aDS != null) {
                    localDataSourceID = aDS.IID();
                    String s = (String)aDS.ParamFields().get("DS_CHECKCACHE");
                    dontChkCache = s != null && s.equalsIgnoreCase("false");
                } else {
                    localDataSourceID = -999;
                    dontChkCache = false;
                }
            } else if (MVDCachePool.instance().getUseGlobals() || this.mOriginalRequest.getOperationScope() > 0) {
                localDataSourceID = -999;
                dontChkCache = false;
            }
            MVDSearchResults msr = null;
            if (!dontChkCache) {
                String keypart = "";
                String cachemode = MVDGlobals.getGlobalParameter("GLOBAL_CACHE_MODE", null);
                if (this.mOriginalRequest.getOperationScope() != 0 && cachemode != null && cachemode.equalsIgnoreCase("AUTH")) {
                    keypart = this.mEngineData.MvdDebit().UserGroup().equalsIgnoreCase("INTERNAL_INTERNAL_TREE") ? this.mEngineData.getOnBehalfOf().Name() + "|" + this.mEngineData.getAuthGlobals().getSortedValues() + "|" : this.mEngineData.MvdDebit().UserGroup() + "|" + this.mEngineData.getAuthGlobals().getSortedValues() + "|";
                }
                keypart = keypart + this.mOriginalRequest.getStartingPoint();
                msr = MVDCachePool.getCacheEntryIfCacheAllowed(keypart, localDataSourceID, this.mOriginalRequest.getOperationScope(), this.mOriginalRequest.getRequestedURLFilter(), this.mOriginalRequest.getRequestedAttributes(), null);
            }
            if (msr != null) {
                MVDNodeSearchOperation VDS2 = (MVDNodeSearchOperation)this.mNodesInScope.elementAt(0);
                VDS2.SetGeneralResults(msr);
                VDS2.SetNodeType(111);
                for (int x = 1; x < ls; ++x) {
                    VDS2 = (MVDNodeSearchOperation)this.mNodesInScope.elementAt(x);
                    VDS2.SetNodeType(222);
                }
                return;
            }
            if (this.mOriginalRequest.getOperationScope() == 0 && MVDCachePool.instance().allowChangeAttributes(localDataSourceID)) {
                for (int x = 0; x < ls; ++x) {
                    VDS = (MVDNodeSearchOperation)this.mNodesInScope.elementAt(x);
                    VDS.LocalRequest().setRequestedAttributes(new Vector(Globals.getExtendedSetForCaching()));
                }
                MVDLogger.Debug("Due to caching, the requested attribute set is EXTENDED to:" + Globals.getExtendedSetForCaching().toString(), 2);
                this.mUsedForCacheOp = Globals.getExtendedSetForCaching();
            } else if ((this.mOriginalRequest.getOperationScope() == 1 || this.mOriginalRequest.getOperationScope() == 2) && MVDCachePool.instance().allowChangeAttributesSublevel(localDataSourceID)) {
                for (int x = 0; x < ls; ++x) {
                    VDS = (MVDNodeSearchOperation)this.mNodesInScope.elementAt(x);
                    VDS.LocalRequest().setRequestedAttributes(new Vector(Globals.getExtendedSetForCaching()));
                }
                MVDLogger.Debug("Due to caching, the requested attribute set is EXTENDED to:" + Globals.getExtendedSetForCaching().toString(), 2);
                this.mUsedForCacheOp = Globals.getExtendedSetForCaching();
            }
        }
        for (int x = 0; x < ls; ++x) {
            VDS = (MVDNodeSearchOperation)this.mNodesInScope.elementAt(x);
            try {
                if (restOfRequestedEntries > 0 && restOfRequestedEntries < VDS.LocalRequest().getSizeLimit()) {
                    VDS.LocalRequest().setSizeLimit(restOfRequestedEntries);
                }
                int nRets = VDS.JustDoIt();
                while (nRets == -99) {
                    if (VDS.LoadBalancingGroup() != null) {
                        VDS.LoadBalancingGroup().operationFailed();
                    } else if (VDS.FailoverGroup() != null) {
                        VDS.FailoverGroup().operationFailed();
                        VDS.SetDataSource(null);
                    } else {
                        nRets = 0;
                        continue;
                    }
                    this.prepareSingleNodeSearch(VDS, x);
                    nRets = VDS.JustDoIt();
                }
                if (nRets == -999 && (nRets = VDS.JustDoIt()) == -999) {
                    nRets = 0;
                }
                if (this.mEngineData.MvdSessionsUserGroup().OptSizeLimit() != 1 || this.mOriginalRequest.getSizeLimit() <= 0 || (restOfRequestedEntries -= nRets) > 0 || VDS.LocalRequest().getSizeLimit() == 0) continue;
                MVDLogger.Log("VDS's size limit reached, leaving", 2);
                return;
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
                continue;
            }
            catch (Throwable e) {
                MVDLogger.Log("! Unexpected error - " + e.getMessage(), 7, e);
            }
        }
    }

    public void prepareSingleNodeSearch(MVDNodeSearchOperation aNode, int aIndex) {
        try {
            if (aNode.DataSource() != null || aNode.NodeType() != 33) {
                aNode.EvaluateAndPrepareNode(aIndex);
            }
            if (aNode.isGroupWithMasterSingleDS() != -1) {
                aNode.EvaluateAndPrepareNode(aIndex);
            }
        }
        catch (VirtualMachineError vte) {
            Globals.blownAwayByThrowable(vte);
        }
        catch (Throwable e) {
            aNode.SetErrorNumber(MVDError.GetMapping(-1200));
            aNode.SetErrorMessage("");
            MVDLogger.Log("Evaluation error - " + e.getMessage(), 7, e);
        }
    }

    public void FetchResultCode() throws MVDException {
        MVDLogger.Log("*** Fetch result code ***", 2);
        int ls = this.mNodesInScope.size();
        if (ls == 0) {
            MVDLogger.Log("No candidate nodes in scope", 2);
            throw new MVDException(0, "");
        }
        this.mAccumulateMessage = "";
        this.mAccumulateCode = -1;
        for (int x = 0; x < ls; ++x) {
            MVDNodeSearchOperation VDS = (MVDNodeSearchOperation)this.mNodesInScope.elementAt(x);
            int errNumber = VDS.ErrorNumber();
            String errMessage = VDS.ErrorMessage();
            if (errMessage.length() > 0) {
                if (this.mAccumulateMessage.length() > 0) {
                    this.mAccumulateMessage = this.mAccumulateMessage + ",";
                }
                this.mAccumulateMessage = this.mAccumulateMessage + errMessage;
            }
            if (this.mAccumulateCode == 0) continue;
            if (errNumber == 0) {
                this.mAccumulateCode = 0;
                continue;
            }
            if (this.mAccumulateCode == 4 || this.mAccumulateCode == 3 || this.mAccumulateCode == 11 || this.mAccumulateCode == 9) continue;
            this.mAccumulateCode = errNumber == 4 || errNumber == 3 || errNumber == 11 || errNumber == 9 ? errNumber : errNumber;
        }
        if (this.mAccumulateCode != 0 && this.mAccumulateCode != 4 && this.mAccumulateCode != 3 && this.mAccumulateCode != 11 && this.mAccumulateCode != 9) {
            throw new MVDException(this.mAccumulateCode, this.mAccumulateMessage);
        }
    }

    public void PostProcessResults() {
        MVDLogger.Log("*** Starting post processing phase ***", 2);
        MVDSearchResults mRes = null;
        int ls = this.mNodesInScope.size();
        this.masterResults = new MVDSearchResults();
        for (int x = 0; x < ls; ++x) {
            MVDNodeSearchOperation VDS = (MVDNodeSearchOperation)this.mNodesInScope.elementAt(x);
            if (VDS.NodeType() == 222) continue;
            try {
                mRes = VDS.PostNodeProcessResults();
                if (mRes == null) {
                    this.mNumberOfEntries = 1;
                    continue;
                }
                if (mRes.getOperRes().getCode() == 99999) {
                    this.mNumberOfEntries += mRes.size();
                    this.masterResults.addAll(mRes);
                    this.masterResults.setTransBytes(mRes.getOperRes().getCode(), mRes.getTransBytes());
                    return;
                }
                if (!mRes.isOK() || mRes.size() == 0) {
                    if (!mRes.isPartial()) continue;
                    this.masterResults.setPartialResult();
                    continue;
                }
                this.logPrefix = "UG(" + this.mEngineData.MvdSessionsUserGroup().Name() + "): Conversion: ";
                if (this.mEngineData.MvdSessionsUserGroup().EnableConvServer()) {
                    String str;
                    MVDOpUtilities.ConvertRESEntriesAttributes(mRes, this.mEngineData.MvdSessionsUserGroup().MapOutAttr());
                    if (MVDLogger.IsLogging(2)) {
                        Vector tempVector = mRes.getEntry(0).getAttributes();
                        MVDLogger.Log(this.logPrefix + "Returned attributes (for 1-st entry): " + tempVector.toString(), 2);
                    }
                    if ((str = MVDProxy.AttrClass()) != null && !str.equalsIgnoreCase("None")) {
                        MVDAttributeFixInterface afix = this.mEngineData.getInitiatedAttrFixObject(str, this.mEngineGs);
                        MVDOpUtilities.FixRESEntriesAttributeValues(mRes, this.mEngineData.MvdSessionsUserGroup().MapOutScript(), afix, this.mEngineData.MvdSessionsUserGroup().EditAttrIsRequired(), this.mEngineData.MvdSessionsUserGroup().EditAttrMethod());
                    }
                } else {
                    MVDLogger.Log(this.logPrefix + "None ", 2);
                }
                this.mNumberOfEntries += mRes.size();
                this.masterResults.addAll(mRes);
                if (!mRes.isPartial()) continue;
                this.masterResults.setPartialResult();
                continue;
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
                continue;
            }
            catch (Throwable e) {
                MVDLogger.Log("! Unexpected error - " + e.getMessage(), 7, e);
            }
        }
    }

    public MxResponse fetchAllSearchResults() throws Exception {
        MVDSearchResults messageStruct = new MVDSearchResults();
        Vector totalToBeSent = new Vector();
        MVDLogger.Log("*** Starting sending node search results ***", 2);
        int localDataSourceID = -1;
        int noRet = 0;
        int ls = this.mNodesInScope.size();
        boolean doWrite = false;
        MVDNodeSearchOperation VDS = (MVDNodeSearchOperation)this.mNodesInScope.elementAt(0);
        if (VDS.NodeType() != 111) {
            doWrite = true;
            if (this.mOriginalRequest.getOperationScope() == 0) {
                if (VDS.DataSource() != null) {
                    localDataSourceID = VDS.DataSource().IID();
                    String s2 = (String)VDS.DataSource().ParamFields().get("DS_WRITECACHE");
                    doWrite = s2 == null || !s2.equalsIgnoreCase("false");
                } else {
                    localDataSourceID = -999;
                }
            } else if (MVDCachePool.instance().getUseGlobals() || this.mOriginalRequest.getOperationScope() > 0) {
                localDataSourceID = -999;
            }
        } else {
            doWrite = false;
        }
        String cachemode = MVDGlobals.getGlobalParameter("GLOBAL_CACHE_MODE", null);
        String cacheUsergroup = null;
        if (this.mOriginalRequest.getOperationScope() != 0 && cachemode != null && cachemode.equalsIgnoreCase("AUTH")) {
            cacheUsergroup = this.mEngineData.MvdDebit().UserGroup().equalsIgnoreCase("INTERNAL_INTERNAL_TREE") ? this.mEngineData.getOnBehalfOf().Name() + "|" + this.mEngineData.getAuthGlobals().getSortedValues() + "|" : this.mEngineData.MvdDebit().UserGroup() + "|" + this.mEngineData.getAuthGlobals().getSortedValues() + "|";
        }
        if (doWrite && MVDCachePool.instance().isCacheEnabled()) {
            this.masterResults.setOK(this.mAccumulateCode, this.mAccumulateMessage);
            if (!this.masterResults.evaluateOK()) {
                this.masterResults.setError();
            }
            MVDSearchResults cloneMaster = (MVDSearchResults)this.masterResults.clone();
            if (cacheUsergroup == null || cacheUsergroup.length() == 0) {
                MVDUserGroup ug = this.mEngineData.MvdSessionsUserGroup();
                MVDUserGroup tempUG = MVDUserGroupList.getUGByID(ug.ID());
                cacheUsergroup = tempUG.Name();
            }
            if (MVDCachePool.cacheEntryIfCacheAllowed(cloneMaster, this.mOriginalRequest.getOperationScope(), this.mUsedForCacheOp, cacheUsergroup + this.mOriginalRequest.getStartingPoint(), this.mOriginalRequest.getRequestedURLFilter().toLowerCase(), localDataSourceID)) {
                // empty if block
            }
        }
        if (VDS.NodeType() != 111) {
            int iWhatIsRequested = MVDUtil.areAllAttributesRequested(this.mOriginalRequest.getRequestedAttributes());
            if (iWhatIsRequested == 0) {
                MVDLogger.Debug("Removing operational attributes from master data set", 2);
                MVDOpUtilities.CleanRESEntriesAttributesByVector(this.masterResults, Globals.getOperationalAttributes(), false);
            } else if (iWhatIsRequested == 1) {
                MVDOpUtilities.CleanRESEntriesAttributesByVector(this.masterResults, this.mOriginalRequest.getRequestedAttributes(), true);
            } else {
                Vector distinctAttributes = new Vector(this.mOriginalRequest.getRequestedAttributes());
                distinctAttributes.remove("*");
                MVDSearchResults allCachedValues = (MVDSearchResults)this.masterResults.clone();
                MVDLogger.Debug("Removing operational attributes from data set", 2);
                MVDOpUtilities.CleanRESEntriesAttributesByVector(this.masterResults, Globals.getOperationalAttributes(), false);
                MVDOpUtilities.CleanRESEntriesAttributesByVector(allCachedValues, distinctAttributes, true);
                this.masterResults.join(allCachedValues);
            }
        }
        this.mEngineData.MvdDebit().SetCached(VDS.NodeType() == 111);
        for (int x = 0; x < ls; ++x) {
            VDS = (MVDNodeSearchOperation)this.mNodesInScope.elementAt(x);
            try {
                int opRes = VDS.ErrorNumber();
                if (opRes != 0 && opRes != 4 && opRes != 11 && opRes != 9 && opRes != 3) continue;
                noRet = noRet + VDS.GeneralResults().size() + VDS.GeneralResults().getCallbackEntries();
                messageStruct.addAll(VDS.GeneralResults());
                continue;
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
                continue;
            }
            catch (Throwable e) {
                this.mEngineData.MvdDebit().SetReturnedEntries(noRet);
                MVDLogger.Log("! Unexpected error - " + e.getMessage(), 7, e);
            }
        }
        this.mEngineData.MvdDebit().SetReturnedEntries(noRet);
        MVDLogger.Log("Number of entries: " + noRet + " - Operation result: " + this.mAccumulateCode, 5);
        int opRes = this.AccumulateCode();
        int aCode = opRes < -1000 ? MVDError.GetMapping(opRes) : opRes;
        String am = this.AccumulateMessage();
        messageStruct.setError(aCode, am);
        return messageStruct;
    }

    private class ACLPriorityComparator
    implements Comparator {
        private ACLPriorityComparator() {
        }

        public int compare(Object aOne, Object aTwo) {
            int prioOne = 50;
            int prioTwo = 50;
            try {
                prioOne = ((MVDNodeSearchOperation)aOne).Acl().getPriority();
                prioTwo = ((MVDNodeSearchOperation)aTwo).Acl().getPriority();
            }
            catch (Exception e) {
                // empty catch block
            }
            if (prioOne <= prioTwo) {
                return -1;
            }
            if (prioOne < prioTwo) {
                return 0;
            }
            return 1;
        }
    }
}

