/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.operations;

import com.sap.idm.vds.AbstractOperation;
import com.sap.idm.vds.AbstractRootDSE;
import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDAttributeFixInterface;
import com.sap.idm.vds.MVDDebitInfo;
import com.sap.idm.vds.MVDEngineData;
import com.sap.idm.vds.MVDError;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDInternalContext;
import com.sap.idm.vds.MVDInternalSearchResults;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.MVDServerSelectInterface;
import com.sap.idm.vds.MVDStatistics;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.PartialResultCallbackHandler;
import com.sap.idm.vds.Server;
import com.sap.idm.vds.config.FailoverGroupContainer;
import com.sap.idm.vds.config.LoadBalancingGroupContainer;
import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceSequentialGroup;
import com.sap.idm.vds.config.MVDDynamicAddGroup;
import com.sap.idm.vds.config.MVDJoinGroup;
import com.sap.idm.vds.config.MVDProvisioningGroup;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDRule;
import com.sap.idm.vds.config.MVDSource;
import com.sap.idm.vds.filter.MVDFilterUtil;
import com.sap.idm.vds.implicitattr.ImplicitAttributes;
import com.sap.idm.vds.ldapv3.PartialAttributeList;
import com.sap.idm.vds.message.MxEntry;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.message.MxResultCodes;
import com.sap.idm.vds.message.MxSearch;
import com.sap.idm.vds.operations.MVDCommonAMDOperation;
import com.sap.idm.vds.operations.MVDNodeSearchList;
import com.sap.idm.vds.operations.MVDSearchOperation;
import com.sap.idm.vds.util.MVDOpUtilities;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Vector;

public class MVDNodeSearchOperation {
    private MVDSearchOperation mSearchParent;
    private MVDCommonAMDOperation mAMDParent;
    private MxSearch mLocalRequest = null;
    private MVDRule mRule;
    private MVDAcl mAcl;
    private MVDDataSourceSequentialGroup mDataSourceSequentialGroup;
    private MVDDynamicAddGroup mDynamicAddGroup;
    private MVDJoinGroup mJoinGroup;
    private MVDDataSource mDataSource;
    private MVDProvisioningGroup mProvisioningGroup;
    private LoadBalancingGroupContainer mLoadBalancingGroup;
    private FailoverGroupContainer mFailoverGroup;
    private int mNodeType;
    private String logPrefix;
    private MVDSearchResults mGeneralResults;
    private int mErrorNumber;
    private String mErrorMessage;
    Vector mVectorOfSearchResults = new Vector();
    boolean mPartOfJoin = false;
    boolean mFilterCritical = false;
    Vector mDSAdditionalAttributes = new Vector();
    private String mNodeRequestedDBFilter = "";

    public MVDNodeSearchOperation(MVDSearchOperation mvdSearchOp) {
        this.mSearchParent = mvdSearchOp;
        this.mErrorNumber = -1;
        this.mErrorMessage = "";
        this.mGeneralResults = new MVDSearchResults();
        this.mAcl = null;
        this.mRule = null;
        this.mDataSource = null;
        this.mDataSourceSequentialGroup = null;
        this.mLoadBalancingGroup = null;
        this.mProvisioningGroup = null;
        this.mDynamicAddGroup = null;
        this.mJoinGroup = null;
        this.mFailoverGroup = null;
        this.mNodeType = 22;
        this.mRule = mvdSearchOp.mRule;
        this.mLocalRequest = new MxSearch(mvdSearchOp.OriginalRequest());
    }

    public MVDSearchResults GeneralResults() {
        return this.mGeneralResults;
    }

    public void SetGeneralResults(MVDSearchResults msr) {
        this.mGeneralResults = msr;
    }

    public int ErrorNumber() {
        return this.mErrorNumber;
    }

    public String ErrorMessage() {
        return this.mErrorMessage;
    }

    public MVDRule Rule() {
        return this.mRule;
    }

    public MVDAcl Acl() {
        return this.mAcl;
    }

    public MVDDataSource DataSource() {
        return this.mDataSource;
    }

    public MVDJoinGroup JoinGroup() {
        return this.mJoinGroup;
    }

    public MVDDynamicAddGroup DynamicAddGroup() {
        return this.mDynamicAddGroup;
    }

    public MVDProvisioningGroup ProvisioningGroup() {
        return this.mProvisioningGroup;
    }

    public LoadBalancingGroupContainer LoadBalancingGroup() {
        return this.mLoadBalancingGroup;
    }

    public MVDDataSourceSequentialGroup DataSourceSequentialGroup() {
        return this.mDataSourceSequentialGroup;
    }

    public FailoverGroupContainer FailoverGroup() {
        return this.mFailoverGroup;
    }

    public int NodeType() {
        return this.mNodeType;
    }

    public MxSearch LocalRequest() {
        return this.mLocalRequest;
    }

    public MVDSearchOperation SearchParent() {
        return this.mSearchParent;
    }

    public void SetNodeType(int t) {
        this.mNodeType = t;
    }

    public void SetLoadBalancingGroup(LoadBalancingGroupContainer aLoadBalancingGroup) {
        this.mLoadBalancingGroup = aLoadBalancingGroup;
    }

    public void setProvisioningGroup(MVDProvisioningGroup aProvisioningGroup) {
        this.mProvisioningGroup = aProvisioningGroup;
    }

    public void setDynamicAddGroup(MVDDynamicAddGroup aProvGroup) {
        this.mDynamicAddGroup = aProvGroup;
    }

    public void SetJoinGroup(MVDJoinGroup aJoingroup) {
        this.mJoinGroup = aJoingroup;
    }

    public void SetDataSourceSequentialGroup(MVDDataSourceSequentialGroup t) {
        this.mDataSourceSequentialGroup = t;
    }

    public void SetFailoverGroup(FailoverGroupContainer aFailoverGroup) {
        this.mFailoverGroup = aFailoverGroup;
    }

    public void SetDataSource(MVDDataSource t) {
        this.mDataSource = t;
    }

    public void SetPartOfJoin(boolean b) {
        this.mPartOfJoin = b;
    }

    public void SetFilterCritical(boolean b) {
        this.mFilterCritical = b;
    }

    public void SetErrorNumber(int i) {
        this.mErrorNumber = i;
    }

    public void SetErrorMessage(String s) {
        this.mErrorMessage = s;
    }

    public void SetDSAdditionalAttributes(Vector v) {
        this.mDSAdditionalAttributes = v;
    }

    private int isSourceSingleDS(MVDSource mst) throws Exception {
        int mappingType = -1;
        if (mst == null) {
            return -1;
        }
        mappingType = mst.getMappingType();
        if (mappingType == 0) {
            int dsID = mst.getMappingID();
            if (dsID == -1) {
                throw new Exception("Misconfigured master source");
            }
            return dsID;
        }
        return -1;
    }

    public int isGroupWithMasterSingleDS() throws Exception {
        if (this.mJoinGroup != null) {
            MVDSource mst = this.mJoinGroup.getMaster();
            return this.isSourceSingleDS(mst);
        }
        if (this.mDynamicAddGroup != null) {
            MVDSource mst = this.mDynamicAddGroup.getMaster();
            return this.isSourceSingleDS(mst);
        }
        return -1;
    }

    public void SetNodeSearchProperties(MVDAcl aclNode, MVDNodeSearchOperation ns) {
        String useStartingPoint;
        this.mAcl = aclNode;
        this.mNodeType = !this.mAcl.IsVirtualNode() ? 22 : 33;
        this.mDataSource = this.mAcl.getDataSource();
        this.mDataSourceSequentialGroup = this.mAcl.getDataSourceSequentialGroup();
        this.mJoinGroup = this.mAcl.getJoinGroup();
        this.mDynamicAddGroup = this.mAcl.getDynamicAddGroup();
        this.mProvisioningGroup = this.mAcl.getProvisioningGroup();
        this.mLoadBalancingGroup = this.mAcl.getLoadBalancingGroup();
        this.mFailoverGroup = this.mAcl.getFailoverGroup();
        int useOperationScope = this.mSearchParent.OriginalRequest().getOperationScope();
        if (ns == null) {
            useStartingPoint = this.mSearchParent.OriginalRequest().getStartingPoint();
        } else {
            this.mRule = ns.Rule();
            useStartingPoint = ns.LocalRequest().getStartingPoint();
        }
        MVDRule mTempRule = this.mAcl.FindProperRule(this.mSearchParent.getEngineData().MvdDebit().UserName(), useStartingPoint, this.mSearchParent.getEngineData().MvdSessionsUserGroup(), this.mSearchParent.getEngineData().ExternalSessionGs());
        if (mTempRule != null) {
            this.mRule = mTempRule;
        }
        this.logPrefix = "(Node:" + this.mAcl.getQName() + "): ";
        switch (useOperationScope) {
            case 0: {
                this.mLocalRequest.setStartingPoint(useStartingPoint);
                this.mLocalRequest.setOperationScope(useOperationScope);
                break;
            }
            case 1: 
            case 2: {
                if (this.mNodeType == 22) {
                    if (useStartingPoint.length() > 0) {
                        this.mLocalRequest.setStartingPoint(this.mAcl.getNodeName() + "," + useStartingPoint);
                    } else {
                        this.mLocalRequest.setStartingPoint(this.mAcl.getNodeName());
                    }
                    this.mLocalRequest.setOperationScope(0);
                    break;
                }
                this.mLocalRequest.setStartingPoint(useStartingPoint);
                this.mLocalRequest.setOperationScope(useOperationScope);
            }
        }
    }

    public void EvaluateAndPrepareNode(int myIndex) throws Exception {
        if (this.mNodeType == 11) {
            return;
        }
        if (this.mNodeType == 44) {
            return;
        }
        this.logPrefix = "(Node:" + this.mAcl.getQName() + "): ";
        if (this.mRule == null) {
            MVDLogger.Log(this.logPrefix + "Proper rule coudn't be found", 2);
            this.mErrorNumber = MVDError.GetMapping(-1200);
            this.mErrorMessage = "";
            return;
        }
        if (MVDOpUtilities.IsOperationProhibited(this.mRule, "SEARCH")) {
            MVDLogger.Log("The operation is not alowed for this user", 2);
            this.mErrorNumber = MVDError.GetMapping(-1200);
            this.mErrorMessage = "";
            return;
        }
        if (!this.IsProperObjectClass()) {
            this.mErrorNumber = MVDError.GetMapping(-1200);
            String tmpName = this.mNodeType == 33 ? (this.mDataSourceSequentialGroup != null ? this.mDataSourceSequentialGroup.NiceName() : (this.mDynamicAddGroup != null ? this.mDynamicAddGroup.getName() : (this.mJoinGroup != null ? this.mJoinGroup.getName() : (this.mProvisioningGroup != null ? this.mProvisioningGroup.getName() : (this.mLoadBalancingGroup != null ? this.mLoadBalancingGroup.getName() : (this.mFailoverGroup != null ? this.mFailoverGroup.getName() : this.mDataSource.NiceName())))))) : "STATIC";
            this.mErrorMessage = "(" + tmpName + ":" + this.mErrorNumber + ":" + MVDError.GetAdditionalInfo(-1200) + ")";
            return;
        }
        if (this.mNodeType == 22) {
            this.EvaluateAndPrepareStaticNode();
        } else {
            boolean bProceed = this.mJoinGroup != null ? this.mJoinGroup.isEnabled() : (this.mDynamicAddGroup != null ? this.mDynamicAddGroup.isEnabled() : (this.mDataSourceSequentialGroup != null ? this.mDataSourceSequentialGroup.IsAllowed() : (this.mProvisioningGroup != null ? this.mProvisioningGroup.IsAllowed() : (this.mLoadBalancingGroup != null ? this.mLoadBalancingGroup.isEnabled() : (this.mFailoverGroup != null ? this.mFailoverGroup.isEnabled() : this.mDataSource.IsAllowed())))));
            if (!bProceed) {
                this.mErrorNumber = MVDError.GetMapping(-1200);
                this.mErrorMessage = "(" + this.mDataSource.NiceName() + ":" + this.mErrorNumber + ":" + MVDError.GetAdditionalInfo(-1200) + ")";
                return;
            }
            this.EvaluateAndPrepareNonStaticNode();
        }
    }

    private String doMultipleReplace(String sValue, MVDDebitInfo tmpD) {
        boolean bChanged;
        do {
            bChanged = false;
            String sValueLower = sValue.toLowerCase();
            if (sValueLower.indexOf("%avail%") >= 0) {
                sValue = MVDUtil.replace(sValue, "%avail%", this.mDataSource.ConfiguredAvailableFieldsKeys());
                bChanged = true;
                continue;
            }
            if (sValueLower.indexOf("%indexed%") >= 0) {
                sValue = MVDUtil.replace(sValue, "%indexe%", this.mDataSource.ConfiguredIndexedFieldsKeys());
                bChanged = true;
                continue;
            }
            if (sValueLower.indexOf("%szl%") >= 0) {
                sValue = MVDUtil.replace(sValue, "%szl%", new Integer(this.mLocalRequest.getSizeLimit()).toString());
                bChanged = true;
                continue;
            }
            if (sValueLower.indexOf("%tml%") >= 0) {
                sValue = MVDUtil.replace(sValue, "%tml%", new Integer(this.mLocalRequest.getTimeLimit()).toString());
                bChanged = true;
                continue;
            }
            if (sValueLower.indexOf("%user%") >= 0) {
                sValue = MVDUtil.replace(sValue, "%user%", tmpD.UserName());
                bChanged = true;
                continue;
            }
            if (sValueLower.indexOf("%pwd%") < 0) continue;
            sValue = MVDUtil.replace(sValue, "%pwd%", tmpD.UserPwd());
            bChanged = true;
        } while (bChanged);
        return sValue;
    }

    public void ExpandHashMap(HashMap h) {
        if (h.toString().indexOf("%") == -1) {
            return;
        }
        MVDDebitInfo tmpD = this.mSearchParent.getEngineData().MvdDebit();
        Iterator it = h.keySet().iterator();
        while (it.hasNext()) {
            String sss = (String)it.next();
            String sValue = h.get(sss).toString();
            sValue = this.doMultipleReplace(sValue, tmpD);
            h.put(sss, sValue);
        }
    }

    private MVDSearchResults executeInternalSearch(String operationStr, int aTree, String aNestedDN) {
        return this.executeInternalSearch(operationStr, aTree, aNestedDN, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private MVDSearchResults executeInternalSearch(String operationStr, int aTree, String aNestedDN, int aSizeLimit) {
        MVDSearchResults mVDSearchResults;
        block7: {
            MVDInternalContext aCont = null;
            MxSearch newRequest = (MxSearch)this.mLocalRequest.clone();
            try {
                aCont = new MVDInternalContext();
                aCont.bind(this.mSearchParent.getEngineData(), aTree);
                String c = this.mAcl.getQName();
                c = MVDOpUtilities.reverseDN(c);
                String virt = "";
                int x = c.indexOf(",");
                virt = x < 0 ? c : c.substring(x + 1);
                String fixedDn = MVDUtilities.fixStartingPoint(newRequest.getStartingPoint(), aNestedDN, virt);
                newRequest.setStartingPoint(fixedDn);
                if (aSizeLimit != -1) {
                    newRequest.setSizeLimit(aSizeLimit);
                }
                MxResponse aResp = aCont.answerRequest(newRequest);
                aCont.close();
                aCont = null;
                aResp.fixStartingPoint(virt, aNestedDN);
                if (!aResp.isOK()) {
                    MVDLogger.Log(operationStr + " operation: master search failed: ", 2);
                }
                mVDSearchResults = (MVDSearchResults)aResp;
                Object var14_16 = null;
                if (aCont == null) break block7;
            }
            catch (Exception e) {
                MVDSearchResults mVDSearchResults2;
                block8: {
                    try {
                        if (aCont != null) {
                            aCont.close();
                            aCont = null;
                        }
                        MVDLogger.Log(operationStr + " operation: master search failed: ", 2);
                        MVDSearchResults errres = new MVDSearchResults();
                        errres.setError(2, operationStr + " operation: master search failed: " + e.getMessage());
                        mVDSearchResults2 = errres;
                        Object var14_17 = null;
                        if (aCont == null) break block8;
                    }
                    catch (Throwable throwable) {
                        block9: {
                            Object var14_18 = null;
                            if (aCont == null) break block9;
                            aCont.close();
                            aCont = null;
                        }
                        throw throwable;
                    }
                    aCont.close();
                    aCont = null;
                }
                return mVDSearchResults2;
            }
            aCont.close();
            aCont = null;
        }
        return mVDSearchResults;
    }

    public int JustDoIt() {
        if (MVDLogger.IsLogging(2)) {
            this.logPrefix = this.mNodeType == 11 ? "(RootDSE): " : (this.mNodeType == 44 ? "(Statistic fetch): " : "(Node:" + this.mAcl.getQName() + "): ");
            MVDLogger.Log(this.logPrefix + "Starting point:" + this.mLocalRequest.getStartingPoint(), 2);
            MVDLogger.Log(this.logPrefix + "Scope:" + this.mLocalRequest.getOperationScope(), 2);
        }
        if (this.mNodeType == 22) {
            MVDDebitInfo debinfo = this.mSearchParent.mEngineData.MvdDebit();
            this.mGeneralResults = new MVDInternalSearchResults(this.mLocalRequest.getRequestedAttributes(), this.mAcl.getDescription(), this.mAcl.getObjectClass(), this.mLocalRequest.getStartingPoint(), debinfo.UserName(), debinfo.UserPwd());
            return 1;
        }
        if (this.mNodeType == 11) {
            if (MVDProxy.TransparentAuth()) {
                int opRes = 0;
                HashMap bHash = MVDUtilities.DoDirectServerUsingBER(this.mSearchParent.getEngineData(), MVDProxy.AuthServer(), MVDProxy.AuthPort(), this.mSearchParent.getEngineData().LastASNString());
                byte[] bRes = (byte[])bHash.get("RAW_RESPONSE");
                String bs = MVDUtil.FromUTF8(bRes);
                if (!bs.equalsIgnoreCase("Not connected")) {
                    this.mGeneralResults.setTransBytes(99999, bRes);
                    this.mGeneralResults.setSessionDestiny((String)bHash.get("SESSION_CONTINUES"));
                    return 0;
                }
                opRes = -1057;
                MVDLogger.Log("Explicit authentication failed, returned: 'Not connected'", 2);
                this.mGeneralResults.setError(-1057, "");
                return 0;
            }
            String strnew = MVDProxy.RootDSEClass();
            AbstractRootDSE aroot = this.mSearchParent.getEngineData().getInitiatedRootDSEObject(strnew, this.mSearchParent.EngineGs());
            if (aroot == null) {
                this.mGeneralResults.setError(-1044, "");
                return 0;
            }
            try {
                MVDHashMap param = new MVDHashMap();
                MVDDebitInfo tmpD = this.mSearchParent.getEngineData().MvdDebit();
                String username = tmpD.UserName();
                String userpwd = tmpD.UserPwd();
                String clientip = tmpD.ClientIPAddress();
                String ug = tmpD.UserGroup();
                param.put("LDAP_USERNAME", username != null ? username : "");
                param.put("LDAP_USERPWD", userpwd != null ? userpwd : "");
                param.put("LDAP_CLIENTIP", clientip != null ? clientip : "");
                param.put("LDAP_USERGROUP", ug != null ? ug : "");
                Vector<String> v = this.mLocalRequest.getRequestedAttributes();
                if (v == null) {
                    v = new Vector<String>();
                    v.add("*");
                } else if (v.size() == 0) {
                    v.add("*");
                }
                param.put("LDAP_ATTRIBUTES", v);
                this.mGeneralResults = aroot.rootDSE(param);
            }
            catch (Throwable ee) {
                MVDLogger.Log("Error executing RootDSE operation:" + ee.getMessage(), 6);
            }
            return this.mGeneralResults.size();
        }
        if (this.mNodeType == 44) {
            try {
                this.mGeneralResults = MVDStatistics.getInstance().fetchStatistics();
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
                return 121;
            }
            catch (Throwable ee) {
                MVDLogger.Log("Error executing Statistic fetch operation:" + ee.getMessage(), 6);
            }
            return this.mGeneralResults.size();
        }
        if (this.mJoinGroup != null) {
            MVDSearchResults ares;
            int aTree = this.mJoinGroup.getMaster().getTree();
            String aNestedDN = this.mJoinGroup.getMaster().getNestedDN();
            String aMandParams = this.mJoinGroup.getMasterMandatoryFields();
            if (aMandParams != null && aMandParams.length() > 0) {
                Vector aMandVector = MVDUtil.splitString(aMandParams, ",");
                if (MVDUtil.areAllAttributesRequested(this.mLocalRequest.getRequestedAttributes()) != 0) {
                    this.mLocalRequest.getRequestedAttributes().addAll(aMandVector);
                }
            }
            this.mGeneralResults = ares = this.executeInternalSearch("Join", aTree, aNestedDN);
            if (!this.mGeneralResults.isOK()) {
                return this.mGeneralResults.size();
            }
            try {
                this.addObjectClass();
                if (this.mGeneralResults.size() > 0 && this.mJoinGroup.doJoinOnOperation(this.mSearchParent.mOriginalRequest.getOperationScope())) {
                    this.mGeneralResults = ImplicitAttributes.doJoinGroupFixing(this.mJoinGroup, this.mGeneralResults, this.mSearchParent.getEngine(), this.mLocalRequest.getRequestedAttributes(), this.mLocalRequest.getRequestedURLFilter());
                }
                return this.mGeneralResults.size();
            }
            catch (Exception e) {
                MVDLogger.Log("Join failed: " + e.getMessage(), 2);
                this.mGeneralResults = new MVDSearchResults();
                this.mGeneralResults.setError(2, "Join failed " + e.getMessage());
                return 0;
            }
        }
        if (this.mDynamicAddGroup != null) {
            MVDSearchResults ares;
            int aTree = this.mDynamicAddGroup.getMaster().getTree();
            String aNestedDN = this.mDynamicAddGroup.getMaster().getNestedDN();
            this.mGeneralResults = ares = this.executeInternalSearch("Dynamic add", aTree, aNestedDN);
            this.addObjectClass();
            return this.mGeneralResults.size();
        }
        if (this.mProvisioningGroup != null) {
            MVDSearchResults ares;
            int aTree = this.mProvisioningGroup.getMaster().getTree();
            String aNestedDN = this.mProvisioningGroup.getMaster().getNestedDN();
            this.mGeneralResults = ares = this.executeInternalSearch("Provisioning", aTree, aNestedDN);
            this.addObjectClass();
            return this.mGeneralResults.size();
        }
        if (this.mLoadBalancingGroup != null) {
            try {
                MVDSearchResults ares;
                MVDSource src = this.mLoadBalancingGroup.getSource(0);
                int aTree = src.getTree();
                String aNestedDN = src.getNestedDN();
                this.mGeneralResults = ares = this.executeInternalSearch("LoadBalancing", aTree, aNestedDN);
                int code = this.mGeneralResults.getCode();
                if (MxResultCodes.isUnavailable(code)) {
                    return -99;
                }
                this.addObjectClass();
                return this.mGeneralResults.size();
            }
            catch (NoSuchElementException e) {
                this.mGeneralResults.setError(52, e.getMessage());
                return 0;
            }
        }
        if (this.mFailoverGroup != null) {
            try {
                MVDSearchResults ares;
                MVDSource src = this.mFailoverGroup.getSource();
                int aTree = src.getTree();
                String aNestedDN = src.getNestedDN();
                this.mGeneralResults = ares = this.executeInternalSearch("Failover", aTree, aNestedDN);
                int code = this.mGeneralResults.getCode();
                if (MxResultCodes.isUnavailable(code)) {
                    return -99;
                }
                this.addObjectClass();
                return this.mGeneralResults.size();
            }
            catch (NoSuchElementException e) {
                this.mGeneralResults.setError(52, "");
                return 0;
            }
        }
        if (this.mDataSourceSequentialGroup != null) {
            int nres = 0;
            int needEntries = this.mLocalRequest.getSizeLimit();
            MVDSource[] targetSource = null;
            if (this.mDataSourceSequentialGroup.isEnableServerSelectClass()) {
                try {
                    MVDServerSelectInterface multi = this.mSearchParent.getEngineData().getInitiatedMultiSearchObject(this.mDataSourceSequentialGroup.getServerSelectClass(), this.mSearchParent.EngineGs());
                    MVDDataSourceSequentialGroup aSeqG = this.mDataSourceSequentialGroup;
                    Vector ds = aSeqG.IncludedDS();
                    Server[] ids = new Server[ds.size()];
                    int i = 0;
                    HashMap<Integer, MVDSource> mapping = new HashMap<Integer, MVDSource>();
                    Iterator iter = ds.iterator();
                    while (iter.hasNext()) {
                        MVDSource source = (MVDSource)iter.next();
                        int id = Integer.parseInt(source.getSrcID());
                        ids[i++] = new Server(id, source.getDisplayName(), source.getUserData());
                        mapping.put(new Integer(id), source);
                    }
                    MVDHashMap params = new MVDHashMap();
                    params.put("LDAP_STARTINGPOINT", this.mLocalRequest.getStartingPoint());
                    params.put("LDAP_OPSUBTYPE", new Integer(this.mLocalRequest.getOperationScope()));
                    String f = this.mLocalRequest.getRequestedURLFilter();
                    f = MVDUtil.replace(f, "\\", "\\\\");
                    params.put("LDAP_URLFILTER", f);
                    Server[] searchsource = multi.search(ids, params);
                    if (searchsource != null && searchsource.length > 0) {
                        Vector<MVDSource> temp = new Vector<MVDSource>();
                        for (int j = 0; j < searchsource.length; ++j) {
                            MVDSource s = (MVDSource)mapping.get(new Integer(searchsource[j].getId()));
                            if (s == null) continue;
                            temp.add(s);
                        }
                        if (temp.size() > 0) {
                            targetSource = new MVDSource[temp.size()];
                            targetSource = temp.toArray(targetSource);
                        } else {
                            targetSource = null;
                            MVDLogger.Log("Multisearch group: Selected server(s) not in the list of available servers", 2);
                        }
                    } else {
                        targetSource = null;
                        MVDLogger.Log("Multisearch group: No server selected", 2);
                    }
                }
                catch (Exception e) {
                    MVDLogger.Log("Multisearch group: Exception selecting server", 7, e);
                    targetSource = null;
                }
            }
            if (targetSource == null) {
                targetSource = new MVDSource[this.mDataSourceSequentialGroup.IncludedDS().size()];
                targetSource = this.mDataSourceSequentialGroup.IncludedDS().toArray(targetSource);
            }
            this.mGeneralResults.setOK();
            for (int ix = 0; ix < targetSource.length; ++ix) {
                MVDSource src = targetSource[ix];
                int aTree = src.getTree();
                String aNestedDN = src.getNestedDN();
                MVDSearchResults msr = this.executeInternalSearch("DataSourceSequentialGroup", aTree, aNestedDN, needEntries);
                if (src.isCritical() && (msr == null || !msr.isOK())) {
                    this.mGeneralResults.setError(msr.getCode(), "Critical data source failed: " + msr.getMessage());
                    return 0;
                }
                if (msr == null) continue;
                this.mVectorOfSearchResults.add(msr);
                this.mGeneralResults.addAll(msr);
                if (msr.size() <= 0) continue;
                if (this.mLocalRequest.getSizeLimit() != 0) {
                    needEntries -= msr.size();
                }
                nres += msr.size();
                if (this.mLocalRequest.getOperationScope() == 0) {
                    if (msr.size() == 1) {
                        this.addObjectClass();
                        return 1;
                    }
                    MVDLogger.Log("Multisearch group processing: BASE search returned > 1 entries. Will not be returned", 2);
                    return 0;
                }
                if (this.mLocalRequest.getSizeLimit() != 0) {
                    if (needEntries <= 0) {
                        int tmp = this.removeDuplicates();
                        nres -= tmp;
                        needEntries += tmp;
                    }
                    if (needEntries <= 0) {
                        return nres;
                    }
                }
                if (this.mDataSourceSequentialGroup.isSearchOneServerOnly()) break;
            }
            this.addObjectClass();
            return nres -= this.removeDuplicates();
        }
        MVDSearchResults tmp = this.RunOnSingleDS("");
        if (tmp == null) {
            return -999;
        }
        return this.mGeneralResults.size();
    }

    private int removeDuplicates() {
        int i = 0;
        if (this.mGeneralResults.size() > 0) {
            HashSet<String> set = new HashSet<String>(this.mGeneralResults.size() * 2);
            Iterator iter = this.mGeneralResults.iterator();
            while (iter.hasNext()) {
                MxEntry entry = (MxEntry)iter.next();
                String dn = entry.getDn();
                if (set.add(dn.toLowerCase())) continue;
                iter.remove();
                ++i;
            }
        }
        return i;
    }

    private void addObjectClass() {
        String x = this.mAcl.getObjectClass();
        if (x != null && x.length() > 0) {
            for (int i = 0; i < this.mGeneralResults.size(); ++i) {
                MVDSearchResultEntry entry = (MVDSearchResultEntry)this.mGeneralResults.elementAt(i);
                if (entry.getAttrValues("objectclass") != null) continue;
                entry.setAttrValue("objectclass", true, x, "|");
            }
        }
    }

    public MVDSearchResults RunOnSingleDS(String connectionString) {
        this.mSearchParent.incVirtualSearchCounter();
        MVDSearchResults msr = new MVDSearchResults();
        MVDDataSource dsAlready = (MVDDataSource)this.mSearchParent.getEngineData().getInitializedOperations().get(this.mDataSource.getUniqueName());
        String initScr = this.mDataSource.PreOpScript();
        if (!(dsAlready != null || initScr != null && initScr.equalsIgnoreCase("none"))) {
            AbstractOperation o = this.mSearchParent.getEngineData().getInitiatedAbstractOperation(initScr, this.mSearchParent.EngineGs());
            if (o == null) {
                msr.setError(-1044, "");
                return msr;
            }
            MVDHashMap param = new MVDHashMap();
            param.putAll(MVDProxy.MVDGlobals());
            HashMap mypf = (HashMap)this.mAcl.getParamFields().get("" + this.mDataSource.IID());
            if (mypf == null) {
                mypf = (HashMap)this.mAcl.getParamFields().get("-1");
            }
            param.putAll(mypf);
            param.putAll(this.mDataSource.ParamFields());
            param.put("NODE__QNAME", MVDOpUtilities.reverseDN(this.mAcl.getQName()));
            if (this.mDataSource.EnableMultipleServers()) {
                param = this.mDataSource.getTopMultiServerGroup().getMultiServerParams(this.mDataSource.DSType(), param);
            }
            this.ExpandHashMap(param);
            param.put("NODE__OBJECTCLASS", this.mAcl.getObjectClass());
            if (this.mSearchParent.OriginalRequest().getRequestedAttributes().size() == 0 || this.mSearchParent.OriginalRequest().getRequestedAttributes().contains("objectclass") || this.mSearchParent.OriginalRequest().getRequestedAttributes().contains("*")) {
                param.put("LDAP__ADDOBJCLASS", "1");
            }
            param.put("LDAP__ORIGINALSTARTINGPOINT", this.mSearchParent.OriginalRequest().getStartingPoint());
            param.put("LDAP__ORIGINALSEARCHTYPE", new Integer(this.mSearchParent.OriginalRequest().getOperationScope()));
            MVDDebitInfo tmpD = this.mSearchParent.getEngineData().MvdDebit();
            param.put("LDAP_USERNAME", tmpD.UserName());
            param.put("LDAP_USERPWD", tmpD.UserPwd());
            param.put("LDAP_CLIENTIP", tmpD.ClientIPAddress());
            param.put("LDAP_VERSION", new Integer(tmpD.Version()));
            param.put("LDAP_SZLIMIT", new Integer(this.mLocalRequest.getSizeLimit()));
            param.put("LDAP_TMLIMIT", new Integer(this.mLocalRequest.getTimeLimit()));
            try {
                MVDOperationResult res = o.initialize(param);
                if (!res.isOK()) {
                    MVDLogger.Log("Initialize failed !!", 6);
                    msr.setError(-1044, "");
                    return msr;
                }
            }
            catch (VirtualMachineError vte) {
                Globals.blownAwayByThrowable(vte);
                return null;
            }
            catch (Throwable ee) {
                MVDLogger.Log("Error on Initialize:" + ee.getMessage(), 7, ee);
                msr.setError(-1044, "");
                return msr;
            }
            this.mSearchParent.getEngineData().getInitializedOperations().put(this.mDataSource.getUniqueName(), this.mDataSource);
        }
        MVDHashMap param = new MVDHashMap();
        param.put("INTERN__CARDINAL", "" + (this.mSearchParent.getVirtualSearchCounter() - 1));
        param.putAll(MVDProxy.MVDGlobals());
        HashMap mypf = (HashMap)this.mAcl.getParamFields().get("" + this.mDataSource.IID());
        if (mypf == null) {
            mypf = (HashMap)this.mAcl.getParamFields().get("-1");
        }
        param.putAll(mypf);
        param.putAll(this.mDataSource.ParamFields());
        param.put("DS_UNIQUENAME", this.mDataSource.getUniqueName());
        param.put("DS_DSID", new Integer(this.mDataSource.IID()));
        if (this.mDataSource.EnableMultipleServers()) {
            param = this.mDataSource.getTopMultiServerGroup().getMultiServerParams(this.mDataSource.DSType(), param);
        }
        this.ExpandHashMap(param);
        param.put("LDAP_STARTINGPOINT", this.mLocalRequest.getStartingPoint());
        param.put("LDAP_OPSUBTYPE", new Integer(this.mLocalRequest.getOperationScope()));
        MVDDebitInfo tmpD = this.mSearchParent.getEngineData().MvdDebit();
        param.put("LDAP_USERNAME", tmpD.UserName());
        param.put("LDAP_USERPWD", tmpD.UserPwd());
        param.put("LDAP_CLIENTIP", tmpD.ClientIPAddress());
        param.put("LDAP_SZLIMIT", new Integer(this.mLocalRequest.getSizeLimit()));
        param.put("LDAP_TMLIMIT", new Integer(this.mLocalRequest.getTimeLimit()));
        param.put("LDAP_ATTRS", this.mLocalRequest.getRequestedAttributes());
        if (this.mNodeRequestedDBFilter.length() == 0) {
            this.mNodeRequestedDBFilter = this.mLocalRequest.getRequestedStructFilter().toDBFilter(this.mAcl.getDataSource());
        } else if (!this.mNodeRequestedDBFilter.equals("IGNORED_FILTER")) {
            this.mNodeRequestedDBFilter = this.mLocalRequest.getRequestedStructFilter().toDBFilter(this.mAcl.getDataSource());
        }
        param.putCaseSensitive("LDAP_DBFILTER", this.mNodeRequestedDBFilter);
        String f = this.mLocalRequest.getRequestedURLFilter();
        f = MVDUtil.replace(f, "\\", "\\\\");
        param.put("LDAP_URLFILTER", f);
        param.put("LDAP_FILTER", MVDFilterUtil.convertFilter(this.mLocalRequest.getRequestedStructFilter()));
        if (this.mDataSource.IsIdentityStore()) {
            String idsFilter = this.mLocalRequest.getRequestedStructFilter().toIdSFilter();
            if (idsFilter.equalsIgnoreCase("(IGNOREDFILTER)")) {
                idsFilter = "IGNORED_FILTER";
            }
            param.putCaseSensitive("LDAP_IDSFILTER", idsFilter);
        }
        param.put("NODE__QNAME", MVDOpUtilities.reverseDN(this.mAcl.getQName()));
        param.put("NODE__OBJECTCLASS", this.mAcl.getObjectClass());
        MVDEngineData useGlobalsHere = null;
        MVDHashMap useEngineGsHere = null;
        if (this.mSearchParent != null) {
            if (this.mSearchParent.OriginalRequest().getRequestedAttributes().size() == 0 || this.mSearchParent.OriginalRequest().getRequestedAttributes().contains("objectclass") || this.mSearchParent.OriginalRequest().getRequestedAttributes().contains("*")) {
                param.put("LDAP__ADDOBJCLASS", "1");
            }
            param.put("LDAP__ORIGINALSTARTINGPOINT", this.mSearchParent.OriginalRequest().getStartingPoint());
            param.put("LDAP__ORIGINALSEARCHTYPE", new Integer(this.mSearchParent.OriginalRequest().getOperationScope()));
            useGlobalsHere = this.mSearchParent.getEngineData();
            useEngineGsHere = this.mSearchParent.EngineGs();
        } else if (this.mAMDParent != null) {
            useGlobalsHere = this.mAMDParent.getEngineData();
            useEngineGsHere = this.mAMDParent.EngineGs();
        }
        String className = this.mDataSource.SearchScript();
        AbstractOperation o = useGlobalsHere.getInitiatedAbstractOperation(className, useEngineGsHere);
        if (o == null) {
            msr.setError(-1044, "");
            return msr;
        }
        PartialResultCallbackHandler callback = (PartialResultCallbackHandler)this.mSearchParent.EngineGs().get("#MX_CALLBACK_HANDLER#");
        MVDNodeSearchList.register(this, callback);
        try {
            msr = o.search(param);
        }
        catch (Throwable ee) {
            MVDLogger.Log("Error on '" + className + "' Search: " + ee, 7, ee);
        }
        MVDNodeSearchList.deRegister(this, callback);
        if (this.mDataSource.EnableMultipleServers()) {
            boolean bDataSourceIsUnavailable = MxResultCodes.isUnavailable(msr.getCode());
            if (this.mDataSource.getTopMultiServerGroup().setNextDS(this.mDataSource, bDataSourceIsUnavailable) < 0L) {
                this.mGeneralResults = msr;
                return null;
            }
        }
        if (msr != null) {
            if (connectionString.length() == 0) {
                this.mGeneralResults = msr;
            } else if (msr.isOK() && msr.size() == 1) {
                this.mGeneralResults.addElement(msr.elementAt(0));
                this.mGeneralResults.setOK();
            } else {
                this.mGeneralResults.addElement(new MVDSearchResultEntry());
                this.mGeneralResults.setOK();
            }
        }
        return this.mGeneralResults;
    }

    private void FetchSequentialResultCode() throws MVDException {
        MVDLogger.Log("*** Fetch sequential result code ***", 2);
        if (!this.mGeneralResults.isOK()) {
            throw new MVDException(this.mGeneralResults.getCode(), this.mGeneralResults.getMessage());
        }
        int ls = this.mVectorOfSearchResults.size();
        if (ls == 0) {
            MVDLogger.Log("No sequential group candidates", 2);
            throw new MVDException(0, "");
        }
        String AccumulateMessage = "";
        int AccumulateCode = -1;
        for (int x = 0; x < ls; ++x) {
            MVDSearchResults VDS = (MVDSearchResults)this.mVectorOfSearchResults.elementAt(x);
            int errNumber = VDS.getCode();
            String errMessage = VDS.getMessage();
            if (errMessage.length() > 0) {
                if (AccumulateMessage.length() > 0) {
                    AccumulateMessage = AccumulateMessage + ",";
                }
                AccumulateMessage = AccumulateMessage + errMessage;
            }
            if (AccumulateCode == 0) continue;
            if (errNumber == 0) {
                AccumulateCode = 0;
                continue;
            }
            if (AccumulateCode == 4 || AccumulateCode == 3 || AccumulateCode == 11 || AccumulateCode == 9) continue;
            AccumulateCode = errNumber == 4 || errNumber == 3 || errNumber == 11 || errNumber == 9 ? errNumber : errNumber;
        }
        throw new MVDException(AccumulateCode, AccumulateMessage);
    }

    public MVDSearchResults PostNodeProcessResults() {
        if (this.mLoadBalancingGroup != null || this.mProvisioningGroup != null) {
            this.SetNodeErrorCode();
            if (!this.mGeneralResults.isOK()) {
                return this.mGeneralResults;
            }
            if (this.mGeneralResults.size() > 0) {
                this.mErrorNumber = 0;
                this.CleanResAttributesByRule();
            } else {
                this.mErrorNumber = MVDError.GetMapping(-1200);
            }
            return this.mGeneralResults;
        }
        if (this.mJoinGroup != null || this.mDynamicAddGroup != null || this.mFailoverGroup != null) {
            this.SetNodeErrorCode();
            if (!this.mGeneralResults.isOK()) {
                return this.mGeneralResults;
            }
            if (this.mGeneralResults.size() > 0) {
                this.mErrorNumber = 0;
                this.CleanResAttributesByRule();
            } else {
                this.mErrorNumber = MVDError.GetMapping(-1200);
            }
            return this.mGeneralResults;
        }
        if (this.mDataSourceSequentialGroup != null) {
            try {
                this.FetchSequentialResultCode();
            }
            catch (MVDException e) {
                this.mErrorMessage = e.errMessage();
                this.mErrorNumber = e.errNumber();
            }
            if (this.mGeneralResults.size() > 0) {
                this.CleanResAttributesByRule();
            }
            return this.mGeneralResults;
        }
        return this.PostNodeProcessSingleDSResult();
    }

    public MVDSearchResults PostNodeProcessSingleCallbackResult(MVDSearchResults aResult) {
        if (aResult.isOK()) {
            if (this.mNodeType == 33) {
                if (aResult.size() == 0) {
                    return aResult;
                }
                this.CleanResAttributesByDataSource(aResult);
                MVDOpUtilities.ConstructRESEntriesAttributes(aResult, this.mDataSource.EffectiveResponseAttrConstruct(), this.mDataSource.EffectiveResponseAttrConstructIfExists());
                String str = MVDProxy.AttrClass();
                MVDAttributeFixInterface afix = null;
                if (str != null && !str.equalsIgnoreCase("None")) {
                    afix = this.mSearchParent.getEngineData().getInitiatedAttrFixObject(str, this.mSearchParent.EngineGs());
                    MVDOpUtilities.FixRESEntriesAttributeValues(aResult, this.mDataSource.EffectiveResponseAttrConstructScripts(), afix, false, null);
                }
                MVDOpUtilities.DeleteRESEntriesAttributes(aResult, this.mDataSource.EffectiveResponseAttrDelete(), false);
                MVDOpUtilities.ConvertRESEntriesAttributes(aResult, this.mDataSource.EffectiveResponseAttrMapping());
                if (str != null && !str.equalsIgnoreCase("None")) {
                    MVDOpUtilities.FixRESEntriesAttributeValues(aResult, this.mDataSource.EffectiveResponseAttrMappingScripts(), afix, this.mDataSource.EditAttrIsRequired(), this.mDataSource.EditAttrMethod());
                }
            }
            this.CleanResAttributesByRule(aResult);
        }
        return aResult;
    }

    public MVDSearchResults PostNodeProcessSingleDSResult() {
        this.SetNodeErrorCode();
        if (this.mNodeType == 11) {
            if (this.mGeneralResults.getOperRes().getCode() == 99999) {
                return this.mGeneralResults;
            }
            this.mErrorNumber = 0;
            if (!this.mGeneralResults.isOK() && MVDLogger.IsLogging(2)) {
                this.logPrefix = "(RootDSE):";
                MVDLogger.Log(this.logPrefix + "Failed", 2);
            }
            return null;
        }
        if (this.mNodeType == 44) {
            this.mErrorNumber = 0;
            if (!this.mGeneralResults.isOK() && MVDLogger.IsLogging(2)) {
                this.logPrefix = "(Statistic fetch):";
                MVDLogger.Log(this.logPrefix + "Failed", 2);
            }
            return null;
        }
        if (this.mGeneralResults.isOK()) {
            if (this.mNodeType == 33) {
                Vector tempVector;
                if (this.mGeneralResults.size() == 0) {
                    if (MVDLogger.IsLogging(3)) {
                        this.logPrefix = "(Node:" + this.mAcl.getQName() + "): ";
                        MVDLogger.Log(this.logPrefix + "Number of entries returned from this node: 0, no post processing: ", 2);
                    }
                    return this.mGeneralResults;
                }
                if (MVDLogger.IsLogging(3)) {
                    tempVector = this.mGeneralResults.getEntry(0).getAttributes();
                    this.logPrefix = "(Node:" + this.mAcl.getQName() + "): ";
                    MVDLogger.Log(this.logPrefix + "Returned attributes (for 1-st entry): " + tempVector.toString(), 2);
                }
                this.CleanResAttributesByDataSource();
                MVDOpUtilities.ConstructRESEntriesAttributes(this.mGeneralResults, this.mDataSource.EffectiveResponseAttrConstruct(), this.mDataSource.EffectiveResponseAttrConstructIfExists());
                if (MVDLogger.IsLogging(2)) {
                    tempVector = this.mGeneralResults.getEntry(0).getAttributes();
                    this.logPrefix = "(Node:" + this.mAcl.getQName() + ", DS:" + this.mDataSource.NiceName() + "): Conversion: ";
                    MVDLogger.Log(this.logPrefix + "Returned attributes after construct (for 1-st. entry): " + tempVector.toString(), 2);
                }
                String str = MVDProxy.AttrClass();
                MVDAttributeFixInterface afix = null;
                if (str != null && !str.equalsIgnoreCase("None")) {
                    afix = this.mSearchParent.getEngineData().getInitiatedAttrFixObject(str, this.mSearchParent.EngineGs());
                    MVDOpUtilities.FixRESEntriesAttributeValues(this.mGeneralResults, this.mDataSource.EffectiveResponseAttrConstructScripts(), afix, false, null);
                }
                MVDOpUtilities.DeleteRESEntriesAttributes(this.mGeneralResults, this.mDataSource.EffectiveResponseAttrDelete(), false);
                MVDOpUtilities.ConvertRESEntriesAttributes(this.mGeneralResults, this.mDataSource.EffectiveResponseAttrMapping());
                if (MVDLogger.IsLogging(2)) {
                    tempVector = this.mGeneralResults.getEntry(0).getAttributes();
                    this.logPrefix = "(Node:" + this.mAcl.getQName() + ", DS:" + this.mDataSource.NiceName() + "): Conversion: ";
                    MVDLogger.Log(this.logPrefix + "Returned attributes (for 1-st. entry): " + tempVector.toString(), 2);
                }
                if (str != null && !str.equalsIgnoreCase("None")) {
                    MVDOpUtilities.FixRESEntriesAttributeValues(this.mGeneralResults, this.mDataSource.EffectiveResponseAttrMappingScripts(), afix, this.mDataSource.EditAttrIsRequired(), this.mDataSource.EditAttrMethod());
                }
            } else if (MVDLogger.IsLogging(2)) {
                this.logPrefix = "(Node:" + this.mAcl.getQName() + ",STATIC): ";
                MVDLogger.Log(this.logPrefix + "No DS post processing", 2);
            }
            this.CleanResAttributesByRule();
            if (MVDLogger.IsLogging(3)) {
                this.logPrefix = "(Node:" + this.mAcl.getQName() + "): ";
                MVDLogger.Log(this.logPrefix + "Number of entries returned from this node: " + (this.mGeneralResults.size() + this.mGeneralResults.getCallbackEntries()), 2);
            }
        } else if (MVDLogger.IsLogging(2)) {
            this.logPrefix = "(Node:" + this.mAcl.getQName() + "): ";
            MVDLogger.Log(this.logPrefix + "Failed", 2);
        }
        return this.mGeneralResults;
    }

    private void EvaluateAndPrepareStaticNode() {
        HashMap<String, String> tempAvail = new HashMap<String, String>(this.mAcl.getDescription());
        tempAvail.put("objectclass", "objectclass");
        this.mLocalRequest.getRequestedStructFilter().fixFilter(tempAvail, null, null);
        this.mLocalRequest.updateFilters();
        if (MVDLogger.IsLogging(2)) {
            this.logPrefix = "(Node:" + this.mAcl.getQName() + ", STATIC): Cleaning and conversion: ";
            MVDLogger.Log(this.logPrefix + "Requested filter: " + this.mLocalRequest.getRequestedURLFilter(), 2);
        }
        if (this.mLocalRequest.getRequestedURLFilter().equalsIgnoreCase("(INVALIDFILTER)")) {
            MVDLogger.Log(this.logPrefix + "->Invalid filter, leaving ...", 3);
            this.mErrorNumber = MVDError.GetMapping(-1200);
            this.mErrorMessage = "";
            return;
        }
        if (this.mLocalRequest.getRequestedAttributes().size() > 0) {
            MVDOpUtilities.CleanREQAttributesByHash(this.mLocalRequest.getRequestedAttributes(), this.mAcl.getDescription(), true);
        } else {
            this.mLocalRequest.setRequestedAttributes(new Vector(this.mAcl.getDescription().keySet()));
        }
        if (MVDLogger.IsLogging(2)) {
            this.logPrefix = "(Node:" + this.mAcl.getQName() + ", STATIC): Cleaning: ";
            MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.mLocalRequest.getRequestedAttributes().toString(), 2);
        }
    }

    private void NOTUSED_ANY_MORE_groupMasterEvaluation(MVDSource mst, String groupName) throws Exception {
        if (mst == null) {
            MVDLogger.Log("Master source is not set " + groupName, 6);
            throw new MVDException(-1022);
        }
        this.EvaluateAndPrepareNonStaticSingleDSNode_RuleOnly();
    }

    public void EvaluateAndPrepareNonStaticNode() throws Exception {
        if (this.mJoinGroup != null) {
            MVDSource mst = this.mJoinGroup.getMaster();
            if (mst == null) {
                MVDLogger.Log("Master source is not set " + this.mJoinGroup.getName(), 7);
                throw new MVDException(-1022);
            }
            this.EvaluateAndPrepareNonStaticSingleDSNode_RuleOnly();
        } else if (this.mDynamicAddGroup != null) {
            MVDSource mst = this.mDynamicAddGroup.getMaster();
            if (mst == null) {
                MVDLogger.Log("Master source is not set " + this.mDynamicAddGroup.getName(), 7);
                throw new MVDException(-1022);
            }
            this.EvaluateAndPrepareNonStaticSingleDSNode_RuleOnly();
        } else if (this.mFailoverGroup != null) {
            MVDSource mst = this.mFailoverGroup.getSource();
            if (mst == null) {
                MVDLogger.Log("Master source is not set " + this.mFailoverGroup.getName(), 7);
                throw new MVDException(-1022);
            }
            this.EvaluateAndPrepareNonStaticSingleDSNode_RuleOnly();
        } else if (this.mLoadBalancingGroup != null) {
            this.EvaluateAndPrepareNonStaticSingleDSNode_RuleOnly();
        } else if (this.mProvisioningGroup != null) {
            this.EvaluateAndPrepareNonStaticSingleDSNode_RuleOnly();
        } else if (this.mDataSourceSequentialGroup != null) {
            this.EvaluateAndPrepareNonStaticSingleDSNode_RuleOnly();
        } else {
            this.EvaluateAndPrepareNonStaticSingleDSNode();
        }
    }

    public void EvaluateAndPrepareNonStaticSingleDSNode() {
        if (this.mDataSource.SearchScript().equalsIgnoreCase("None")) {
            this.mErrorNumber = MVDError.GetMapping(-1044);
            this.mErrorMessage = "(" + this.mAcl.getQName() + ":" + this.mErrorNumber + ":" + MVDError.GetAdditionalInfo(-1044) + ")";
            return;
        }
        this.SetSizeAndTimeLimitByRule();
        this.CleanReqAttributesByRule();
        if (!this.FixFilterByDataSource()) {
            return;
        }
        this.ConvertReqAttributesByDataSource();
        this.CleanReqAttributesByDataSource();
        if (this.mPartOfJoin && this.mDSAdditionalAttributes.size() > 0) {
            this.CleanReqAttributesByDSAdditionalAttributes(this.mDSAdditionalAttributes);
        }
        if (this.mPartOfJoin && this.mLocalRequest.getRequestedAttributes().toString().equals("[ALLATTRIBUTESCLEANED]")) {
            this.mErrorNumber = MVDError.GetMapping(-1023);
            this.mErrorMessage = "(" + this.mAcl.getQName() + ":" + this.mErrorNumber + ":" + "All attributes cleaned on slave data source)";
            MVDLogger.Log("All attributes cleaned (on the slave) - will not participate GROUP operations", 2);
            return;
        }
    }

    public void EvaluateAndPrepareNonStaticSingleDSNode_RuleOnly() {
        this.SetSizeAndTimeLimitByRule();
        this.CleanReqAttributesByRule();
        if (this.mPartOfJoin && this.mDSAdditionalAttributes.size() > 0) {
            this.CleanReqAttributesByDSAdditionalAttributes(this.mDSAdditionalAttributes);
        }
        if (this.mPartOfJoin && this.mLocalRequest.getRequestedAttributes().toString().equals("[ALLATTRIBUTESCLEANED]")) {
            this.mErrorNumber = MVDError.GetMapping(-1023);
            this.mErrorMessage = "(" + this.mAcl.getQName() + ":" + this.mErrorNumber + ":" + "All attributes cleaned on slave data source)";
            MVDLogger.Log("All attributes cleaned (on the slave) - will not participate GROUP operations", 2);
            return;
        }
    }

    private void CleanReqAttributesByDSAdditionalAttributes(Vector dsaddattr) {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", DSGroup Key Fields Cleaning";
        if (this.mLocalRequest.getRequestedAttributes().size() > 0 && !this.mLocalRequest.getRequestedAttributes().toString().equals("[ALLATTRIBUTESCLEANED]")) {
            if (dsaddattr.size() > 0) {
                MVDOpUtilities.CleanREQAttributesByVector(this.mLocalRequest.getRequestedAttributes(), dsaddattr, false);
                if (this.mLocalRequest.getRequestedAttributes().size() == 0) {
                    this.mLocalRequest.getRequestedAttributes().add("ALLATTRIBUTESCLEANED");
                    MVDLogger.Log(this.logPrefix + "->Cleaned all attributes, add 'warn script': " + this.mLocalRequest.getRequestedAttributes().toString(), 2);
                }
                MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.mLocalRequest.getRequestedAttributes().toString(), 2);
            } else {
                MVDLogger.Log("Not possible (no data source group key attributes or ALLATTRIBUTESCLEANED already)", 2);
            }
        } else {
            MVDLogger.Log(this.logPrefix + "Not possible (all attributes required)", 2);
        }
    }

    private void SetSizeAndTimeLimitByRule() {
        if (this.mRule.OverrideLimits()) {
            int y = this.mRule.TimeLimit();
            if (y <= 0) {
                this.mLocalRequest.setTimeLimit(this.mSearchParent.OriginalRequest().getTimeLimit());
            } else if (this.mSearchParent.OriginalRequest().getTimeLimit() <= 0) {
                this.mLocalRequest.setTimeLimit(y);
            } else if (this.mSearchParent.OriginalRequest().getTimeLimit() < y) {
                this.mLocalRequest.setTimeLimit(this.mSearchParent.OriginalRequest().getTimeLimit());
            } else {
                this.mLocalRequest.setTimeLimit(y);
            }
            y = this.mRule.SizeLimit();
            if (y <= 0) {
                this.mLocalRequest.setSizeLimit(this.mSearchParent.OriginalRequest().getSizeLimit());
            } else if (this.mSearchParent.OriginalRequest().getSizeLimit() <= 0) {
                this.mLocalRequest.setSizeLimit(y);
            } else if (this.mSearchParent.OriginalRequest().getSizeLimit() < y) {
                this.mLocalRequest.setSizeLimit(this.mSearchParent.OriginalRequest().getSizeLimit());
            } else {
                this.mLocalRequest.setSizeLimit(y);
            }
        }
    }

    private void CleanReqAttributesByRule() {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", RULE:" + this.mRule.Name() + "): Cleaning: ";
        if (MVDUtil.areAllAttributesRequested(this.mLocalRequest.getRequestedAttributes()) != 0) {
            boolean bKeep = this.mRule.DoReturnAttr();
            String strAddWord = bKeep ? "" : " not";
            String ss = this.mRule.SearchAttributes().toString();
            if (!ss.equalsIgnoreCase("[all]")) {
                if (this.mRule.SearchAttributes().size() > 0) {
                    MVDLogger.Log(this.logPrefix + "Operation" + strAddWord + " allowed on following attributes: " + ss, 2);
                    MVDOpUtilities.CleanREQAttributesByVector(this.mLocalRequest.getRequestedAttributes(), this.mRule.SearchAttributes(), bKeep);
                    if (this.mLocalRequest.getRequestedAttributes().size() == 0) {
                        this.mLocalRequest.getRequestedAttributes().add("ALLATTRIBUTESCLEANED");
                        MVDLogger.Log(this.logPrefix + "->Rule cleaned all attributes, add 'warn script': " + this.mLocalRequest.getRequestedAttributes().toString(), 2);
                    }
                    MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.mLocalRequest.getRequestedAttributes().toString(), 2);
                } else {
                    MVDLogger.Log("Error in config: No search attributes in rule " + this.mRule, 6);
                }
            } else {
                MVDLogger.Log(this.logPrefix + "Operation allowed on ALL attributes (no cleaning)", 2);
            }
        } else {
            boolean bKeep = this.mRule.DoReturnAttr();
            if (!bKeep) {
                MVDLogger.Log(this.logPrefix + "ALL attributes requested - will be cleaned on the way back", 2);
                return;
            }
            String ss = this.mRule.SearchAttributes().toString().trim();
            if (ss.equalsIgnoreCase("[all]")) {
                MVDLogger.Log(this.logPrefix + "Operation allowed on ALL attributes (no cleaning)", 2);
                return;
            }
            if (this.mRule.SearchAttributes().size() > 0) {
                MVDLogger.Log(this.logPrefix + "Operation allowed on following attributes: " + ss, 2);
                this.mLocalRequest.getRequestedAttributes().addAll(this.mRule.SearchAttributes());
                this.mLocalRequest.getRequestedAttributes().remove("*");
                MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.mLocalRequest.getRequestedAttributes().toString(), 2);
            } else {
                MVDLogger.Log("Error in config: No search attributes in rule " + this.mRule, 6);
            }
        }
    }

    private boolean FixFilterByDataSource() {
        this.mLocalRequest.getRequestedStructFilter().fixFilter(this.mDataSource.EffectiveAvailableFieldsForFilter(), this.mDataSource.EffectiveIgnoredAttr(), this.mDataSource.EffectiveRequestAttrMapping());
        this.mLocalRequest.updateFilters();
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", DS:" + this.mDataSource.NiceName() + "): Cleaning and conversion: ";
        MVDLogger.Log(this.logPrefix + "Requested filter: " + this.mLocalRequest.getRequestedURLFilter(), 2);
        if (this.mLocalRequest.getRequestedURLFilter().equalsIgnoreCase("(IGNOREDFILTER)")) {
            this.mLocalRequest.setRequestedURLFilter("objectclass=*");
            this.mNodeRequestedDBFilter = "IGNORED_FILTER";
            MVDLogger.Log(this.logPrefix + "->Replaced by pass-through filter: " + this.mLocalRequest.getRequestedURLFilter().toString(), 2);
        } else if (this.mLocalRequest.getRequestedURLFilter().equalsIgnoreCase("(INVALIDFILTER)")) {
            boolean bContinue = false;
            if (this.mLocalRequest.getStartingPoint().toLowerCase().indexOf("o=internal") >= 0) {
                bContinue = false;
            }
            if (bContinue) {
                this.mLocalRequest.setRequestedURLFilter("objectclass=*");
                this.mNodeRequestedDBFilter = "IGNORED_FILTER";
            } else {
                MVDLogger.Log(this.logPrefix + "->Invalid filter, leaving ...", 3);
                this.mErrorNumber = MVDError.GetMapping(-1200);
                this.mErrorMessage = "(" + this.mDataSource.NiceName() + ":" + this.mErrorNumber + ":" + MVDError.GetAdditionalInfo(-1200) + ")";
                return false;
            }
        }
        return true;
    }

    private void CleanReqAttributesByDataSource() {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", DS:" + this.mDataSource.NiceName() + "): Cleaning: ";
        if (this.mDataSource.EffectiveAvailableFieldsForAttributes() == null) {
            if (MVDLogger.IsLogging(2)) {
                MVDLogger.Log(this.logPrefix + "All fields are available - no data source cleaning of attributes.", 2);
            }
        } else if (this.mLocalRequest.getRequestedAttributes().size() > 0) {
            MVDOpUtilities.CleanREQAttributesByHash(this.mLocalRequest.getRequestedAttributes(), this.mDataSource.EffectiveAvailableFieldsForAttributes(), true);
            if (MVDLogger.IsLogging(2)) {
                MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.mLocalRequest.getRequestedAttributes().toString(), 2);
            }
            if (this.mLocalRequest.getRequestedAttributes().size() == 0) {
                this.mLocalRequest.getRequestedAttributes().add("ALLATTRIBUTESCLEANED");
                if (MVDLogger.IsLogging(2)) {
                    MVDLogger.Log(this.logPrefix + "->Replaced by 'warn script' attribute: " + this.mLocalRequest.getRequestedAttributes().toString(), 2);
                }
            } else {
                HashMap caseMap = this.mDataSource.CaseSensitivityMap();
                if (caseMap != null) {
                    this.mLocalRequest.setRequestedAttributes(MVDOpUtilities.ConvertAttributes(this.mLocalRequest.getRequestedAttributes(), caseMap));
                    if (MVDLogger.IsLogging(2)) {
                        MVDLogger.Log(this.logPrefix + "Case sensitive, changing: " + this.mLocalRequest.getRequestedAttributes().toString(), 2);
                    }
                }
            }
        } else {
            MVDLogger.Log(this.logPrefix + "Not possible (all attributes required)", 2);
        }
    }

    private void ConvertReqAttributesByDataSource() {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", DS:" + this.mDataSource.NiceName() + "): Conversion: ";
        if (this.mLocalRequest.getRequestedAttributes().size() > 0) {
            this.mLocalRequest.setRequestedAttributes(MVDOpUtilities.ConvertAttributes(this.mLocalRequest.getRequestedAttributes(), this.mDataSource.EffectiveRequestAttrMapping()));
            if (MVDLogger.IsLogging(2)) {
                MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.mLocalRequest.getRequestedAttributes().toString(), 2);
            }
        } else {
            MVDLogger.Log(this.logPrefix + "Nothing to convert!", 2);
        }
    }

    private void CleanResAttributesByDataSource() {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", DS:" + this.mDataSource.NiceName() + "): Cleaning: ";
        if (this.mDataSource.EffectiveAvailableFieldsForAttributes() == null) {
            if (MVDLogger.IsLogging(2)) {
                MVDLogger.Log(this.logPrefix + "All fields are available - no data source cleaning of attributes.", 2);
            }
        } else {
            Set ss1 = this.mDataSource.EffectiveAvailableFieldsForAttributes().keySet();
            Vector vv = new Vector(ss1);
            vv.add("objectclass");
            MVDOpUtilities.CleanRESEntriesAttributesByVector(this.mGeneralResults, vv, true);
            if (MVDLogger.IsLogging(2)) {
                Vector tempVector = this.mGeneralResults.getEntry(0).getAttributes();
                MVDLogger.Log(this.logPrefix + "Returned attributes (for 1-st entry): " + tempVector.toString(), 2);
            }
        }
    }

    private void CleanResAttributesByDataSource(MVDSearchResults aResults) {
        if (this.mDataSource.EffectiveAvailableFieldsForAttributes() != null) {
            Set ss1 = this.mDataSource.EffectiveAvailableFieldsForAttributes().keySet();
            Vector vv = new Vector(ss1);
            vv.add("objectclass");
            MVDOpUtilities.CleanRESEntriesAttributesByVector(aResults, vv, true);
        }
    }

    private void CleanResAttributesByRule() {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", RULE:" + this.mRule.Name() + "): Cleaning: ";
        boolean bKeep = this.mRule.DoReturnAttr();
        String strAddWord = bKeep ? "" : " not";
        String ss = this.mRule.SearchAttributes().toString();
        if (this.mRule.SearchAttributes().size() > 0 && !ss.equalsIgnoreCase("[all]")) {
            MVDLogger.Log(this.logPrefix + "Operation " + strAddWord + " allowed on following attributes: " + ss, 2);
            MVDOpUtilities.CleanRESEntriesAttributesByVector(this.mGeneralResults, this.mRule.SearchAttributes(), bKeep);
            if (MVDLogger.IsLogging(2)) {
                Vector tempVector = this.mGeneralResults.getEntry(0).getAttributes();
                MVDLogger.Log(this.logPrefix + "Returned attributes (for 1-st entry): " + tempVector.toString(), 2);
            }
        } else {
            MVDLogger.Log(this.logPrefix + "Operation allowed on ALL attributes", 2);
        }
    }

    private void CleanResAttributesByRule(MVDSearchResults aResults) {
        boolean bKeep = this.mRule.DoReturnAttr();
        String ss = this.mRule.SearchAttributes().toString();
        if (this.mRule.SearchAttributes().size() > 0 && !ss.equalsIgnoreCase("[all]")) {
            MVDOpUtilities.CleanRESEntriesAttributesByVector(aResults, this.mRule.SearchAttributes(), bKeep);
        }
    }

    private void SetNodeErrorCode() {
        String tmpName = this.mNodeType == 33 ? (this.mDataSourceSequentialGroup != null ? this.mDataSourceSequentialGroup.NiceName() : (this.mDynamicAddGroup != null ? this.mDynamicAddGroup.getName() : (this.mJoinGroup != null ? this.mJoinGroup.getName() : (this.mProvisioningGroup != null ? this.mProvisioningGroup.getName() : (this.mLoadBalancingGroup != null ? this.mLoadBalancingGroup.getName() : (this.mFailoverGroup != null ? this.mFailoverGroup.getName() : this.mDataSource.NiceName())))))) : (this.mNodeType == 11 ? "RootDSE" : (this.mNodeType == 44 ? "Statistic" : "STATIC"));
        if (!this.mGeneralResults.isOK()) {
            int opRes = this.mGeneralResults.getCode();
            if (opRes == 99999) {
                this.mErrorNumber = opRes;
                this.mErrorMessage = this.mGeneralResults.getMessage();
            } else if (opRes > -1000) {
                this.mErrorNumber = opRes;
                this.mErrorMessage = this.mGeneralResults.getMessage().length() > 0 ? "(" + tmpName + ":" + this.mErrorNumber + ":" + this.mGeneralResults.getMessage() + ")" : "";
            } else {
                this.mErrorNumber = MVDError.GetMapping(opRes);
                this.mErrorMessage = MVDError.GetAdditionalInfo(opRes).length() > 0 ? "(" + tmpName + ":" + this.mErrorNumber + ":" + MVDError.GetAdditionalInfo(opRes) + ")" : "";
            }
        } else {
            int opRes = this.mGeneralResults.getCode();
            if (opRes > -1000) {
                this.mErrorNumber = opRes;
                this.mErrorMessage = this.mGeneralResults.getMessage().length() > 0 ? "(" + tmpName + ":" + this.mErrorNumber + ":" + this.mGeneralResults.getMessage() + ")" : "";
            } else {
                this.mErrorNumber = 0;
                this.mErrorMessage = "";
            }
        }
    }

    public static PartialAttributeList attributeListFromGeneralEntry(HashMap si, boolean typesOnly) {
        if (si.size() == 0) {
            return new PartialAttributeList(si);
        }
        if (!typesOnly) {
            return new PartialAttributeList(si);
        }
        return new PartialAttributeList(si, true);
    }

    private boolean IsProperObjectClass() {
        String logPrefix = "(Node:" + this.mAcl.getQName() + "): ";
        String nodesObjectClass = this.mAcl.getObjectClass().toUpperCase();
        if (nodesObjectClass.equals("*") || nodesObjectClass.equals("")) {
            return true;
        }
        String urlFilter = this.mSearchParent.OriginalRequest().getRequestedURLFilter().toUpperCase();
        int x = urlFilter.indexOf("OBJECTCLASS=");
        if (x == -1) {
            return true;
        }
        HashMap<String, String> testMe = new HashMap<String, String>();
        testMe.put("objectclass", "|" + nodesObjectClass + "|");
        boolean bbb = this.mSearchParent.OriginalRequest().getRequestedStructFilter().testFilter(testMe, true);
        if (!bbb) {
            MVDLogger.Log(logPrefix + " Is not proper objectcclass ", 1);
        }
        return bbb;
    }
}

