/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.operations;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.MVDAttributeFixInterface;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.operations.MVDCommonAMDOperation;
import com.sap.idm.vds.util.MVDOpUtilities;
import java.util.HashMap;
import java.util.Vector;

public class MVDModifyOperation
extends MVDCommonAMDOperation {
    private MxModify mOriginalModifyRequest;

    public MxModify getOriginalModifyRequest() {
        return this.mOriginalModifyRequest;
    }

    private String RAMVToString(Vector v) {
        String s = "";
        int ls = v.size();
        for (int x = 0; x < ls; ++x) {
            MVDModAttrValues mvdmod = (MVDModAttrValues)v.elementAt(x);
            if (s.length() > 0) {
                s = s + ",";
            }
            s = s + mvdmod.getAttrName() + ":" + mvdmod.getModType();
        }
        return "[" + s + "]";
    }

    public MVDModifyOperation(MxRequest mxmod, Engine aEng) {
        super(mxmod, aEng);
        this.mOriginalModifyRequest = (MxModify)mxmod;
    }

    private void CleanReqAttributesByDataSource() throws MVDException {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", DS:" + this.mDataSource.NiceName() + "): ";
        if (this.mDataSource.EffectiveAvailableFieldsForAttributes() == null) {
            if (MVDLogger.IsLogging(2)) {
                MVDLogger.Log(this.logPrefix + "Cleaning: All fields are available - no data source cleaning of attributes.", 2);
            }
        } else {
            int StartSize = this.mOriginalModifyRequest.getAttrAndModValues().size();
            if (StartSize > 0) {
                MVDOpUtilities.CleanMODAttributesByHash(this.mOriginalModifyRequest.getAttrAndModValues(), this.mDataSource.EffectiveAvailableAndIgnoredAttr());
                if (this.mOriginalModifyRequest.getAttrAndModValues().size() == 0) {
                    MVDLogger.Log(this.logPrefix + "->Data source cleaned all attributes, operation not legal' ", 2);
                    throw new MVDException(-1086);
                }
                if (this.mOriginalModifyRequest.getAttrAndModValues().size() != StartSize && !MVDProxy.allowPartialUpdate()) {
                    MVDLogger.Log(this.logPrefix + "->Partial modify is not allowed: ", 2);
                    throw new MVDException(-1086);
                }
                if (this.mDataSource.EffectiveIgnoredAttr() != null && this.mDataSource.EffectiveIgnoredAttr().size() > 0) {
                    MVDOpUtilities.CleanMODAttributesByHash(this.mOriginalModifyRequest.getAttrAndModValues(), this.mDataSource.EffectiveAvailableFieldsForAttributes());
                    if (MVDLogger.IsLogging(2)) {
                        MVDLogger.Log(this.logPrefix + "Cleaning: Requested attributes: " + this.RAMVToString(this.mOriginalModifyRequest.getAttrAndModValues()), 2);
                    }
                }
                if (this.mOriginalModifyRequest.getAttrAndModValues().size() == 0) {
                    MVDLogger.Log(this.logPrefix + "->Data source cleaned all attributes, operation not legal' ", 2);
                    throw new MVDException(-1086);
                }
                HashMap caseMap = this.mDataSource.CaseSensitivityMap();
                if (caseMap != null) {
                    MVDOpUtilities.ConvertMODAttributes(this.mOriginalModifyRequest.getAttrAndModValues(), caseMap);
                    if (MVDLogger.IsLogging(2)) {
                        MVDLogger.Log(this.logPrefix + "Conversion: Case sensitive, changing: " + this.RAMVToString(this.mOriginalModifyRequest.getAttrAndModValues()), 2);
                    }
                }
            } else {
                MVDLogger.Log(this.logPrefix + "Cleaning/Conversion: Not possible (all attributes required)", 2);
            }
        }
    }

    private void CleanReqAttributesByRule() throws MVDException {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", RULE:" + this.mRule.Name() + "): Cleaning: ";
        if (this.mOriginalModifyRequest.getAttrAndModValues().size() > 0) {
            String ss = this.mRule.ModifyAttributes().toString();
            if (!ss.equalsIgnoreCase("[all]")) {
                if (this.mRule.ModifyAttributes().size() > 0) {
                    MVDLogger.Log(this.logPrefix + "Operation not allowed on following attributes: " + ss, 2);
                    MVDOpUtilities.CleanMODAttributesByVector(this.mOriginalModifyRequest.getAttrAndModValues(), this.mRule.ModifyAttributes());
                    if (this.mOriginalModifyRequest.getAttrAndModValues().size() == 0) {
                        MVDLogger.Log(this.logPrefix + "->Rule cleaned all attributes, operation not legal': ", 2);
                        throw new MVDException(-1086);
                    }
                    MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.RAMVToString(this.mOriginalModifyRequest.getAttrAndModValues()), 2);
                } else {
                    MVDLogger.Log("Error in config: No allowed attributes to modify " + this.mRule, 6);
                }
            } else {
                MVDLogger.Log(this.logPrefix + "Operation allowed on ALL attributes (no cleaning)", 2);
            }
        } else {
            MVDLogger.Log(this.logPrefix + "Not possible (all attributes required)", 2);
        }
    }

    private void ConvertReqAttributesByUserGroup() {
        this.logPrefix = "UG(" + this.mEngineData.MvdSessionsUserGroup().Name() + "): Conversion: ";
        if (MVDLogger.IsLogging(3)) {
            if (this.mOriginalModifyRequest.getAttrAndModValues().size() > 0) {
                MVDLogger.Log("Requested attributes: " + this.RAMVToString(this.mOriginalModifyRequest.getAttrAndModValues()), 2);
            } else {
                MVDLogger.Log("Requested attributes: All", 2);
            }
        }
        if (this.mEngineData.MvdSessionsUserGroup().EnableConvClient()) {
            if (this.mOriginalModifyRequest.getAttrAndModValues().size() > 0) {
                MVDOpUtilities.ConvertMODAttributes(this.mOriginalModifyRequest.getAttrAndModValues(), this.mEngineData.MvdSessionsUserGroup().MapInAttr());
                MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.RAMVToString(this.mOriginalModifyRequest.getAttrAndModValues()), 2);
            } else {
                MVDLogger.Log(this.logPrefix + "No conversion possible (all attributes required)", 2);
            }
        } else {
            MVDLogger.Log(this.logPrefix + "No user group mapping required.", 2);
        }
    }

    public void ReqAttributePreparationBasic() throws MVDException {
        this.mNodeType = 33;
        this.logPrefix = "(Node:" + this.mAcl.getQName() + "): ";
        this.ConvertReqAttributesByUserGroup();
        this.CleanReqAttributesByRule();
    }

    public void ReqAttributePreparationDSSependant() throws MVDException {
        this.ConvertReqAttributesByDataSource();
        this.CleanReqAttributesByDataSource();
    }

    private void ConvertReqAttributesByDataSource() throws MVDException {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", DS:" + this.mDataSource.NiceName() + "): Conversion: ";
        if (this.mOriginalModifyRequest.getAttrAndModValues().size() > 0) {
            MVDOpUtilities.ConvertMODAttributes(this.mOriginalModifyRequest.getAttrAndModValues(), this.mDataSource.EffectiveRequestAttrMapping());
            if (MVDLogger.IsLogging(2)) {
                MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.RAMVToString(this.mOriginalModifyRequest.getAttrAndModValues()), 2);
            }
        } else {
            MVDLogger.Log(this.logPrefix + "Nothing to convert!", 2);
            return;
        }
        String str = MVDProxy.AttrClass();
        if (str != null && !str.equalsIgnoreCase("None")) {
            MVDAttributeFixInterface afix = this.mEngineData.getInitiatedAttrFixObject(str, this.mEngineGs);
            MVDOpUtilities.FixMODAttributeValues(this.mOriginalModifyRequest.getAttrAndModValues(), this.mDataSource.EffectiveRequestAttrScripts(), afix);
        }
        this.checkSyntax();
    }

    public void CarryOutMVDModify() throws MVDException {
        int iRes = super.CarryOutMVDNodeOperation(this.mOriginalModifyRequest.getAttrAndModValues());
        if (iRes != -999 || (iRes = super.CarryOutMVDNodeOperation(this.mOriginalModifyRequest.getAttrAndModValues())) == -999) {
            // empty if block
        }
        super.FetchResultCode();
    }

    public void checkSyntax() throws MVDException {
        String syntaxchecksetmethod;
        Vector syntaxrules = this.mDataSource.getConfiguredSyntaxCheck();
        if (syntaxrules != null && syntaxrules.size() > 0) {
            String str = MVDProxy.AttrClass();
            if (str != null && !str.equalsIgnoreCase("None")) {
                MVDAttributeFixInterface afix = this.mEngineData.getInitiatedAttrFixObject(str, this.mEngineGs);
                MVDOpUtilities.checkMODAttributeSyntax(this.mOriginalModifyRequest.getDn(), this.mOriginalModifyRequest.getAttrAndModValues(), this.mDataSource.getConfiguredSyntaxCheck(), afix);
            } else {
                MVDLogger.Log("Syntax checking defined, but no attribute class configured.", 7);
            }
        }
        if ((syntaxchecksetmethod = this.mDataSource.getSyntaxCheckModSetMethod()) != null && syntaxchecksetmethod.length() > 0) {
            String str = MVDProxy.AttrClass();
            if (str != null && !str.equalsIgnoreCase("None")) {
                MVDAttributeFixInterface afix = this.mEngineData.getInitiatedAttrFixObject(str, this.mEngineGs);
                MVDOpUtilities.checkModAttributeSyntaxWholeSet(this.mOriginalModifyRequest.getDn(), this.mOriginalModifyRequest.getAttrAndModValues(), this.mDataSource.getConfiguredSyntaxCheck(), afix, syntaxchecksetmethod);
            } else {
                MVDLogger.Log("Syntax checking entire attribute set defined, but no attribute class configured.", 7);
            }
        }
    }
}

