/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.operations;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.ldapv3.Filter;
import com.sap.idm.vds.message.MxCompare;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.operations.MVDCommonAMDOperation;
import java.util.HashMap;

public class MVDCompareOperation
extends MVDCommonAMDOperation {
    private MxCompare mOriginalCompareRequest;

    public MxCompare getOriginalMxCompareRequest() {
        return this.mOriginalCompareRequest;
    }

    public MVDCompareOperation(MxRequest mxcompare, Engine aEng) {
        super(mxcompare, aEng);
        this.mOriginalCompareRequest = (MxCompare)mxcompare;
    }

    public void ReqAttributePreparationBasic() throws MVDException {
        this.mNodeType = 33;
        this.logPrefix = "(Node:" + this.mAcl.getQName() + "): ";
        this.ConvertReqAttributesByUserGroup();
    }

    public void ReqAttributePreparationDSSependant() throws MVDException {
        this.ConvertReqAttributesByDataSource();
    }

    private void ConvertReqAttributesByUserGroup() {
        this.logPrefix = "UG(" + this.mEngineData.MvdSessionsUserGroup().Name() + "): Conversion: ";
        if (this.mEngineData.MvdSessionsUserGroup().EnableConvClient()) {
            String cattr = this.mOriginalCompareRequest.getCompAttr();
            if (this.mEngineData.MvdSessionsUserGroup().MapInAttr() == null) {
                MVDLogger.Log(this.logPrefix + "No attribute mapping specified", 2);
                return;
            }
            if (this.mEngineData.MvdSessionsUserGroup().MapInAttr().containsKey(cattr)) {
                this.mOriginalCompareRequest.setCompAttr((String)this.mEngineData.MvdSessionsUserGroup().MapInAttr().get(cattr));
                MVDLogger.Log(this.logPrefix + "Compare attribute converted to: " + this.mOriginalCompareRequest.getCompAttr(), 2);
            } else {
                MVDLogger.Log(this.logPrefix + "not neccessary", 2);
            }
        } else {
            MVDLogger.Log(this.logPrefix + "No user group mapping required.", 2);
        }
    }

    private void ConvertReqAttributesByDataSource() {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", DS:" + this.mDataSource.NiceName() + "): Conversion: ";
        String cattr = this.mOriginalCompareRequest.getCompAttr();
        if (this.mDataSource.EffectiveRequestAttrMapping() == null) {
            MVDLogger.Log(this.logPrefix + "No attribute mapping specified", 2);
            return;
        }
        if (this.mDataSource.EffectiveRequestAttrMapping().containsKey(cattr)) {
            this.mOriginalCompareRequest.setCompAttr((String)this.mDataSource.EffectiveRequestAttrMapping().get(cattr));
            MVDLogger.Log(this.logPrefix + "Compare attribute converted to: " + this.mOriginalCompareRequest.getCompAttr(), 2);
        } else {
            MVDLogger.Log(this.logPrefix + "not neccessary", 2);
        }
    }

    public void CarryOutMVDCompare() throws MVDException {
        HashMap<String, String> compareparams = new HashMap<String, String>();
        compareparams.put("LDAP_COMPATTR", this.mOriginalCompareRequest.getCompAttr());
        compareparams.put("LDAP_COMPVALUE", this.mOriginalCompareRequest.getCompValue());
        String urlfilter = this.mOriginalCompareRequest.getCompAttr() + "=" + this.mOriginalCompareRequest.getCompValue();
        Filter filter = new Filter(urlfilter);
        String dbfilter = filter.toDBFilter(this.mAcl.getDataSource());
        compareparams.put("LDAP_FILTER", urlfilter);
        compareparams.put("LDAP_DBFILTER", dbfilter);
        int iRes = super.CarryOutMVDNodeOperation(compareparams);
        if (iRes != -999 || (iRes = super.CarryOutMVDNodeOperation(compareparams)) == -999) {
            // empty if block
        }
        super.FetchResultCode();
    }
}

