/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.operations;

import com.sap.idm.vds.AbstractAuthentication;
import com.sap.idm.vds.Engine;
import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDEngineData;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDUserGroup;
import com.sap.idm.vds.config.MVDUserGroupList;
import com.sap.idm.vds.config.MVDUserList;
import com.sap.idm.vds.message.MxBind;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.operations.MVDHelpResult;
import com.sap.idm.vds.protocols.ldap.MxLdapConnection;
import java.util.HashMap;
import java.util.Vector;

public class MVDBindOperation {
    private Engine mEng;
    private MVDHashMap mEngineGs;
    private MVDEngineData mEngineData;
    private MxLdapConnection mConn;
    private MxBind mOriginalBindRequest;
    private String compactLine = "";
    boolean bImplicit = false;

    public MVDBindOperation(Engine aEng, String aIPAddress) {
        this.mEngineData = aEng.getEngineData();
        this.mEngineGs = aEng.getEngineGs();
        this.mOriginalBindRequest = new MxBind();
        this.mOriginalBindRequest.setVersion(3);
        this.mOriginalBindRequest.setUserName("");
        this.mOriginalBindRequest.setPassword("");
        this.mOriginalBindRequest.setAuthType(0);
        this.mOriginalBindRequest.setClientIP(aIPAddress != null ? aIPAddress : "");
        if (MVDLogger.IsLogging(4)) {
            String tempS = "Implicit Bind request from client IP: " + this.mOriginalBindRequest.getClientIP();
            if (MVDLogger.IsLogging(3)) {
                MVDLogger.Log(tempS, 3);
            } else {
                this.compactLine = tempS;
            }
        }
        this.bImplicit = true;
    }

    public MVDBindOperation(MxRequest lReq, Engine aEng) {
        this.mEngineData = aEng.getEngineData();
        this.mEngineGs = aEng.getEngineGs();
        this.bImplicit = false;
        this.mOriginalBindRequest = lReq != null ? (MxBind)lReq : new MxBind();
        this.mEngineData.MvdDebit().SetUserName(this.mOriginalBindRequest.getUserName());
        this.mEngineData.MvdDebit().SetUserPwd(this.mOriginalBindRequest.getPassword());
        this.mEngineData.MvdDebit().SetClientIPAddress(this.mOriginalBindRequest.getClientIP());
        if (MVDLogger.IsLogging(4)) {
            String tempS = "Bind request: '" + this.mOriginalBindRequest.getUserName() + "', '" + "*****" + "' " + "v" + this.mOriginalBindRequest.getVersion() + ", " + this.mOriginalBindRequest.getClientIP();
            if (MVDLogger.IsLogging(3)) {
                MVDLogger.Log(tempS, 3);
            } else {
                this.compactLine = tempS;
            }
        }
    }

    public MxResponse MxBindAttempt() throws MVDException {
        MVDHelpResult hlpRes = new MVDHelpResult();
        boolean bUserGroupIsAlreadySet = false;
        int opRes = 0;
        MxResponse lm = new MxResponse();
        MVDUserGroup internalAuthUserGroup = MVDUserList.DetermineUserGroup(this.mOriginalBindRequest.getUserName(), this.mOriginalBindRequest.getPassword(), this.mOriginalBindRequest.getClientIP());
        if (internalAuthUserGroup == null) {
            MVDLogger.Log("Couldn't find proper user group for these credentials: '" + this.mOriginalBindRequest.getUserName() + "', '" + "*****" + "'", 3);
            if (!MVDProxy.ExplAuth() && !MVDProxy.TransparentAuth()) {
                this.mEngineData.SetIAmBinded(false);
                opRes = -1053;
                lm.setOK(opRes, "");
                return lm;
            }
            MVDLogger.Log("Try expl. authentication", 2);
            bUserGroupIsAlreadySet = false;
            opRes = -1013;
            this.mEngineData.SetIAmBinded(false);
        } else {
            bUserGroupIsAlreadySet = true;
            this.mEngineData.MvdDebit().SetUserName(this.mOriginalBindRequest.getUserName());
            this.mEngineData.MvdDebit().SetUserPwd(this.mOriginalBindRequest.getPassword());
            this.mEngineData.MvdDebit().SetUserGroup(internalAuthUserGroup.Name());
            this.mEngineData.MvdDebit().SetVersion(this.mOriginalBindRequest.getVersion());
            this.mEngineData.MvdDebit().SetClientIPAddress(this.mOriginalBindRequest.getClientIP());
            this.mEngineData.SetMvdSessionsUserGroup(internalAuthUserGroup);
            opRes = 0;
            this.mEngineData.SetIAmBinded(true);
            MVDLogger.Log("Found user group: '" + internalAuthUserGroup.Name() + "'", 2);
        }
        if (MVDProxy.TransparentAuth() && !this.bImplicit) {
            HashMap bHash = MVDUtilities.DoDirectServerUsingBER(this.mEngineData, MVDProxy.AuthServer(), MVDProxy.AuthPort(), this.mEngineData.LastASNString());
            byte[] bRes = (byte[])bHash.get("RAW_RESPONSE");
            String bs = MVDUtil.FromUTF8(bRes);
            if (!bs.equalsIgnoreCase("Not connected")) {
                opRes = -1055;
                hlpRes.SetErrMessage(bs);
                if (!MVDProxy.ExplAuth()) {
                    this.mEngineData.SetIAmBinded(true);
                    lm.setTransBytes(99999, bRes);
                    lm.setSessionDestiny((String)bHash.get("SESSION_CONTINUES"));
                    return lm;
                }
            } else {
                opRes = -1052;
                MVDLogger.Log("Explicit authentication failed, returned: 'Not connected'", 2);
                this.mEngineData.SetIAmBinded(false);
                lm.setOK(opRes, "");
                return lm;
            }
        }
        if (MVDProxy.ExplAuth() && (internalAuthUserGroup == null || internalAuthUserGroup.isExecuteBindMethod())) {
            opRes = this.DealWithExplicitAuthentication(bUserGroupIsAlreadySet, hlpRes);
            if (opRes != 0) {
                this.mEngineData.SetIAmBinded(false);
                lm.setOK(opRes, "[" + hlpRes.ErrCode() + "]" + hlpRes.ErrMessage());
                return lm;
            }
            this.mEngineData.SetIAmBinded(true);
        }
        if (MVDLogger.IsLogging(4)) {
            if (MVDLogger.IsLogging(3)) {
                MVDLogger.Log("Using user group: '" + this.mEngineData.MvdSessionsUserGroup().Name() + "'", 3);
            } else {
                this.compactLine = this.compactLine + " - '" + this.mEngineData.MvdSessionsUserGroup().Name() + "'";
                MVDLogger.Log(this.compactLine, 4);
                this.compactLine = "";
            }
        }
        lm.setOK(opRes, "[" + hlpRes.ErrCode() + "]" + hlpRes.ErrMessage());
        return lm;
    }

    private int DealWithExplicitAuthentication(boolean bUserGroupIsAlreadySet, MVDHelpResult mvdhlp) {
        MVDHashMap parameterDict = new MVDHashMap();
        parameterDict.put("LDAP_USERNAME", this.mOriginalBindRequest.getUserName());
        parameterDict.put("LDAP_USERPWD", this.mOriginalBindRequest.getPassword());
        parameterDict.put("LDAP_CLIENTIP", this.mOriginalBindRequest.getClientIP());
        parameterDict.put("SSL_CLIENT_CERTIFICATES", this.mOriginalBindRequest.getClientCertificates());
        if (!bUserGroupIsAlreadySet) {
            parameterDict.put("LDAP_USERGROUP", "");
        } else {
            parameterDict.put("LDAP_USERGROUP", this.mEngineData.MvdDebit().UserGroup());
        }
        parameterDict.putAll(MVDProxy.MVDGlobals());
        HashMap authparams = MVDProxy.getBindMethodParameters();
        if (authparams != null) {
            parameterDict.putAll(authparams);
        }
        String sRes = "OK";
        try {
            String strexternal = MVDProxy.AuthenticationClass();
            AbstractAuthentication ex = this.mEngineData.getInitiatedAuthenticationObject(strexternal, this.mEngineGs);
            if (ex == null) {
                return -1044;
            }
            parameterDict.put("ENGINE_DATA", this.mEngineData);
            parameterDict.put("ENGINE_GLOBALS", this.mEngineGs);
            sRes = ex.bind(parameterDict);
            if (sRes.length() == 0) {
                MVDLogger.Log("Explicit authentication failed, returned: ''", 2);
                return -1051;
            }
            if (sRes.equalsIgnoreCase("OK")) {
                if (!bUserGroupIsAlreadySet) {
                    MVDLogger.Log("Still missing group ...", 3);
                    return -1053;
                }
                this.mEngineData.MvdDebit().SetUserName(this.mOriginalBindRequest.getUserName());
                this.mEngineData.MvdDebit().SetUserPwd(this.mOriginalBindRequest.getPassword());
                this.mEngineData.MvdDebit().SetClientIPAddress(this.mOriginalBindRequest.getClientIP());
                MVDLogger.Log("Explicit authentication OK (keep original group)", 3);
                return 0;
            }
            try {
                if (sRes.substring(0, 5).equalsIgnoreCase("ERROR")) {
                    String tempString;
                    MVDLogger.Log("Explicit authentication failed: " + sRes, 2);
                    mvdhlp.SetErrCode(0);
                    Vector errs = MVDUtil.splitString(sRes, ':');
                    if (errs.size() > 1 && (tempString = (String)errs.get(1)).substring(0, 3).equalsIgnoreCase("ID-")) {
                        mvdhlp.SetErrCode(Integer.parseInt(tempString.substring(3)));
                        if (errs.size() > 2) {
                            mvdhlp.SetErrMessage((String)errs.get(2));
                        }
                    }
                    return -1054;
                }
            }
            catch (IndexOutOfBoundsException ioe) {
                MVDLogger.Log("Not valid return string: (" + sRes + ") : " + ioe.getMessage(), 2);
            }
            try {
                if (sRes.substring(0, 18).equalsIgnoreCase("CHANGE:credentials")) {
                    this.mEngineData.MvdDebit().SetUserName(this.mOriginalBindRequest.getUserName());
                    this.mEngineData.MvdDebit().SetUserPwd(this.mOriginalBindRequest.getPassword());
                    this.mEngineData.MvdDebit().SetClientIPAddress(this.mOriginalBindRequest.getClientIP());
                    sRes = sRes.substring(19);
                    boolean bGroupChanged = false;
                    boolean bResponseReturned = false;
                    Vector chcs = MVDUtil.splitString(sRes, '!');
                    int ls = chcs.size();
                    for (int x = 0; x < ls; ++x) {
                        MVDUserGroup ug;
                        String newVal;
                        String tempString = (String)chcs.elementAt(x);
                        if (tempString.substring(0, 3).equalsIgnoreCase("DN:")) {
                            newVal = tempString.substring(3);
                            this.mEngineData.MvdDebit().SetUserName(newVal);
                            MVDLogger.Log("Expl. auth. changed credentials - dn=" + newVal, 2);
                            continue;
                        }
                        if (tempString.substring(0, 4).equalsIgnoreCase("PWD:")) {
                            newVal = tempString.substring(4);
                            this.mEngineData.MvdDebit().SetUserPwd(newVal);
                            MVDLogger.Log("Expl. auth. changed credentials - pwd=" + newVal, 2);
                            continue;
                        }
                        if (!tempString.substring(0, 4).equalsIgnoreCase("GRP:") || (ug = MVDUserGroupList.getUGByName(newVal = tempString.substring(4))) == null || !ug.IsAllowed()) continue;
                        this.mEngineData.MvdDebit().SetUserGroup(newVal);
                        this.mEngineData.SetMvdSessionsUserGroup(ug);
                        MVDLogger.Log("Expl. auth. changed credentials - grp='" + newVal + "'", 2);
                        bGroupChanged = true;
                    }
                    if (!bUserGroupIsAlreadySet && !bGroupChanged) {
                        return -1053;
                    }
                    return 0;
                }
            }
            catch (IndexOutOfBoundsException ioe) {
                MVDLogger.Log("Not valid return string: (" + sRes + ") : " + ioe.getMessage(), 2);
            }
            return -1054;
        }
        catch (VirtualMachineError vte) {
            Globals.blownAwayByThrowable(vte);
            return 121;
        }
        catch (Throwable e) {
            MVDLogger.Log("Expl authentication failed:" + e.getMessage(), 2);
            return -1056;
        }
    }
}

