/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.operations;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.MVDAttributeFixInterface;
import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.operations.MVDCommonAMDOperation;
import com.sap.idm.vds.util.MVDOpUtilities;
import java.util.HashMap;
import java.util.Vector;

public class MVDAddOperation
extends MVDCommonAMDOperation {
    private MxAdd mOriginalAddRequest;

    public MxAdd getOriginalAddRequest() {
        return this.mOriginalAddRequest;
    }

    public MVDAddOperation(MxRequest mxadd, Engine aEng) {
        super(mxadd, aEng);
        this.mOriginalAddRequest = (MxAdd)mxadd;
    }

    private void CleanReqAttributesByDataSource() throws MVDException {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", DS:" + this.mDataSource.NiceName() + "): Cleaning: ";
        if (this.mDataSource.EffectiveAvailableFieldsForAttributes() == null) {
            if (MVDLogger.IsLogging(2)) {
                MVDLogger.Log(this.logPrefix + "All fields are available - no data source cleaning of attributes.", 2);
            }
        } else {
            int StartSize = this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().size();
            if (StartSize > 0) {
                MVDOpUtilities.CleanRESAttributesByHash(this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues(), this.mDataSource.EffectiveAvailableAndIgnoredAttr(), true);
                if (this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().size() == 0) {
                    MVDLogger.Log(this.logPrefix + "->Data source cleaned all attributes, operation not legal' ", 2);
                    throw new MVDException(-1086);
                }
                if (this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().size() != StartSize && !MVDProxy.allowPartialUpdate()) {
                    MVDLogger.Log(this.logPrefix + "->Partial add is not allowed: ", 2);
                    throw new MVDException(-1086);
                }
                if (this.mDataSource.EffectiveIgnoredAttr() != null && this.mDataSource.EffectiveIgnoredAttr().size() > 0) {
                    MVDOpUtilities.CleanRESAttributesByHash(this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues(), this.mDataSource.EffectiveAvailableFieldsForAttributes(), true);
                    if (MVDLogger.IsLogging(2)) {
                        MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().keySet().toString(), 2);
                    }
                }
                if (this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().size() == 0) {
                    MVDLogger.Log(this.logPrefix + "->Data source cleaned all attributes, operation not legal' ", 2);
                    throw new MVDException(-1086);
                }
                HashMap caseMap = this.mDataSource.CaseSensitivityMap();
                if (caseMap != null) {
                    this.mOriginalAddRequest.getAttrSetAndValues().setAttrAndValues(MVDOpUtilities.ConvertAttributes(this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues(), caseMap));
                    if (MVDLogger.IsLogging(2)) {
                        MVDLogger.Log(this.logPrefix + "Case sensitive, changing: " + this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().keySet(), 2);
                    }
                }
            } else {
                MVDLogger.Log(this.logPrefix + "Not possible (all attributes required)", 2);
            }
        }
    }

    private void CleanReqAttributesByRule() throws MVDException {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", RULE:" + this.mRule.Name() + "): Cleaning: ";
        if (this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().size() > 0) {
            String ss = this.mRule.AddAttributes().toString();
            if (!ss.equalsIgnoreCase("[all]")) {
                if (this.mRule.AddAttributes().size() > 0) {
                    MVDLogger.Log(this.logPrefix + "Operation not allowed on following attributes: " + ss, 2);
                    MVDOpUtilities.CleanRESAttributesByVector(this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues(), this.mRule.AddAttributes(), false);
                    if (this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().size() == 0) {
                        MVDLogger.Log(this.logPrefix + "->Rule cleaned all attributes, operation not legal': ", 2);
                        throw new MVDException(-1086);
                    }
                    MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().keySet().toString(), 2);
                } else {
                    MVDLogger.Log("Error in config: No allowed attributes to add in rule " + this.mRule, 6);
                }
            } else {
                MVDLogger.Log(this.logPrefix + "Operation allowed on ALL attributes (no cleaning)", 2);
            }
        } else {
            MVDLogger.Log(this.logPrefix + "Not possible (all attributes required)", 2);
        }
    }

    private void ConvertReqAttributesByUserGroup() {
        this.logPrefix = "UG(" + this.mEngineData.MvdSessionsUserGroup().Name() + "): Conversion: ";
        if (MVDLogger.IsLogging(3)) {
            if (this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().size() > 0) {
                MVDLogger.Log("Requested attributes: " + this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().keySet().toString(), 2);
            } else {
                MVDLogger.Log("Requested attributes: All", 2);
            }
        }
        if (this.mEngineData.MvdSessionsUserGroup().EnableConvClient()) {
            if (this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().size() > 0) {
                this.mOriginalAddRequest.getAttrSetAndValues().setAttrAndValues(MVDOpUtilities.ConvertAttributes(this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues(), this.mEngineData.MvdSessionsUserGroup().MapInAttr()));
                MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().keySet().toString(), 2);
            } else {
                MVDLogger.Log(this.logPrefix + "No conversion possible (all attributes required)", 2);
            }
        } else {
            MVDLogger.Log(this.logPrefix + "No user group mapping required.", 2);
        }
    }

    public void ReqAttributePreparationBasic() throws MVDException {
        this.mNodeType = 33;
        this.logPrefix = "(Node:" + this.mAcl.getQName() + "): ";
        this.ConvertReqAttributesByUserGroup();
        this.CleanReqAttributesByRule();
    }

    public void ReqAttributePreparationDSSependant() throws MVDException {
        this.ConvertReqAttributesByDataSource();
        this.checkSyntax();
        this.CleanReqAttributesByDataSource();
    }

    private void ConvertReqAttributesByDataSource() {
        this.logPrefix = "(Node:" + this.mAcl.getQName() + ", DS:" + this.mDataSource.NiceName() + "): Conversion: ";
        if (this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().size() > 0) {
            this.mOriginalAddRequest.getAttrSetAndValues().setAttrAndValues(MVDOpUtilities.ConvertAttributes(this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues(), this.mDataSource.EffectiveRequestAttrMapping()));
            if (MVDLogger.IsLogging(2)) {
                MVDLogger.Log(this.logPrefix + "Requested attributes: " + this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues().keySet().toString(), 2);
            }
        } else {
            MVDLogger.Log(this.logPrefix + "Nothing to convert!", 2);
            return;
        }
        String str = MVDProxy.AttrClass();
        if (str != null && !str.equalsIgnoreCase("None")) {
            MVDAttributeFixInterface afix = this.mEngineData.getInitiatedAttrFixObject(str, this.mEngineGs);
            this.mOriginalAddRequest.getAttrSetAndValues().setAttrAndValues(MVDOpUtilities.FixAttributeValues(this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues(), this.mDataSource.EffectiveRequestAttrScripts(), afix));
        }
    }

    public void CarryOutMVDAdd() throws MVDException {
        int iRes = super.CarryOutMVDNodeOperation(this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues());
        if (iRes != -999 || (iRes = super.CarryOutMVDNodeOperation(this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues())) == -999) {
            // empty if block
        }
        super.FetchResultCode();
    }

    public void checkSyntax() throws MVDException {
        String syntaxchecksetmethod;
        Vector syntaxrules = this.mDataSource.getConfiguredSyntaxCheck();
        if (syntaxrules != null && syntaxrules.size() > 0) {
            String str = MVDProxy.AttrClass();
            if (str != null && !str.equalsIgnoreCase("None")) {
                MVDAttributeFixInterface afix = this.mEngineData.getInitiatedAttrFixObject(str, this.mEngineGs);
                MVDOpUtilities.checkAttributeSyntax(this.mOriginalAddRequest.getDn(), this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues(), this.mDataSource.getConfiguredSyntaxCheck(), afix);
            } else {
                MVDLogger.Log("Syntax checking defined, but no attribute class configured.", 7);
            }
        }
        if ((syntaxchecksetmethod = this.mDataSource.getSyntaxCheckAddSetMethod()) != null && syntaxchecksetmethod.length() > 0) {
            String str = MVDProxy.AttrClass();
            if (str != null && !str.equalsIgnoreCase("None")) {
                MVDAttributeFixInterface afix = this.mEngineData.getInitiatedAttrFixObject(str, this.mEngineGs);
                MVDOpUtilities.checkAddAttributeSyntaxWholeSet(this.mOriginalAddRequest.getDn(), this.mOriginalAddRequest.getAttrSetAndValues().getAttrAndValues(), this.mDataSource.getConfiguredSyntaxCheck(), afix, syntaxchecksetmethod);
            } else {
                MVDLogger.Log("Syntax checking entire attribute set defined, but no attribute class configured.", 7);
            }
        }
    }
}

