/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.message;

import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.ldapv3.Filter;
import com.sap.idm.vds.message.MxRequest;
import java.util.Vector;

public class MxSearch
implements MxRequest,
Cloneable {
    public static final int WHOLE_SUBTREE = 2;
    public static final int SINGLE_LEVEL = 1;
    public static final int BASE_OBJECT = 0;
    public static final int NEVER_DEREF_ALIASES = 0;
    public static final int DEREF_IN_SEARCHING = 1;
    public static final int DEREF_FINDING_BASEOBJ = 2;
    public static final int DEREF_ALWAYS = 3;
    private String mStartingPoint = "";
    private Vector mRequestedAttributes = new Vector();
    private String mRequestedFilter = "";
    private Filter mRequestedStructFilter;
    private String mRequestedURLFilter = "";
    private int mOperationScope = 2;
    private int mDerefAliases = 0;
    private boolean mTypesOnly = false;
    private int mSizeLimit = 30;
    private int mTimeLimit = 30;

    public MxSearch() {
        try {
            this.setRequestedFilter("(objectclass=*)");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public MxSearch(MxSearch aSearch) {
        this.mStartingPoint = aSearch.getStartingPoint();
        this.mRequestedAttributes = new Vector(aSearch.getRequestedAttributes());
        this.mRequestedFilter = aSearch.getRequestedFilter();
        if (aSearch.getRequestedStructFilter() != null) {
            this.mRequestedStructFilter = new Filter(aSearch.getRequestedStructFilter());
        }
        this.mRequestedURLFilter = aSearch.getRequestedURLFilter();
        this.mOperationScope = aSearch.getOperationScope();
        this.mDerefAliases = aSearch.getDerefAliases();
        this.mTypesOnly = aSearch.getTypesOnly();
        this.mSizeLimit = aSearch.getSizeLimit();
        this.mTimeLimit = aSearch.getTimeLimit();
    }

    public String getStartingPoint() {
        return this.mStartingPoint;
    }

    public Vector getRequestedAttributes() {
        return this.mRequestedAttributes;
    }

    public String getRequestedFilter() {
        return this.mRequestedFilter;
    }

    public Filter getRequestedStructFilter() {
        return this.mRequestedStructFilter;
    }

    public String getRequestedURLFilter() {
        return this.mRequestedURLFilter;
    }

    public int getOperationScope() {
        return this.mOperationScope;
    }

    public int getDerefAliases() {
        return this.mDerefAliases;
    }

    public boolean getTypesOnly() {
        return this.mTypesOnly;
    }

    public int getSizeLimit() {
        return this.mSizeLimit;
    }

    public int getTimeLimit() {
        return this.mTimeLimit;
    }

    public void setStartingPoint(String aString) {
        this.mStartingPoint = aString;
    }

    public void setRequestedAttributes(Vector aVector) {
        this.mRequestedAttributes = aVector;
    }

    public void setRequestedAttributes(String aString) {
        this.mRequestedAttributes = MVDUtil.splitString(aString, ",");
    }

    public void setRequestedFilter(String aString) throws Exception {
        try {
            this.mRequestedFilter = aString;
            if (aString.length() > 0) {
                this.mRequestedStructFilter = new Filter(aString);
                this.mRequestedURLFilter = this.mRequestedStructFilter.toURL();
            } else {
                this.mRequestedStructFilter = null;
                this.mRequestedURLFilter = "";
            }
        }
        catch (Exception e) {
            this.mRequestedFilter = "Error in filter:" + aString;
            throw new Exception(this.mRequestedFilter);
        }
    }

    public void setRequestedURLFilter(String aString) {
        this.mRequestedURLFilter = aString;
    }

    public void setRequestedStructFilter(Filter aFilter) {
        this.mRequestedStructFilter = aFilter;
        this.mRequestedFilter = "NOT SET";
        if (aFilter != null) {
            this.mRequestedURLFilter = this.mRequestedStructFilter.toURL();
        }
    }

    public void updateFilters() {
        if (this.mRequestedStructFilter != null) {
            this.mRequestedURLFilter = this.mRequestedStructFilter.toURL();
        }
    }

    public void setOperationScope(int aInt) {
        this.mOperationScope = aInt;
    }

    public void setDerefAliases(int aInt) {
        this.mDerefAliases = aInt;
    }

    public void setTypesOnly(boolean aBool) {
        this.mTypesOnly = aBool;
    }

    public void setSizeLimit(int aInt) {
        this.mSizeLimit = aInt;
    }

    public void setTimeLimit(int aInt) {
        this.mTimeLimit = aInt;
    }

    public String toString(int aType) {
        String resStr;
        switch (aType) {
            case 0: {
                resStr = "Not yet implemented";
                break;
            }
            default: {
                resStr = "Invalid type";
            }
        }
        return resStr;
    }

    public int getChoiceID() {
        return 3;
    }

    public void niceDN() throws MVDException {
        if (this.mStartingPoint != null) {
            this.mStartingPoint = MVDUtil.NiceDN(this.mStartingPoint);
        }
    }

    public Object clone() {
        try {
            MxSearch o = (MxSearch)super.clone();
            o.mStartingPoint = this.mStartingPoint;
            o.mRequestedAttributes = new Vector();
            for (int x = 0; x < this.mRequestedAttributes.size(); ++x) {
                Object elem = this.mRequestedAttributes.elementAt(x);
                if (elem instanceof String) {
                    o.mRequestedAttributes.add(elem);
                    continue;
                }
                byte[] src = (byte[])elem;
                byte[] b = new byte[src.length];
                System.arraycopy(src, 0, b, 0, src.length);
                o.mRequestedAttributes.add(src);
            }
            o.mRequestedFilter = "";
            o.mRequestedStructFilter = this.mRequestedStructFilter;
            o.mRequestedURLFilter = this.mRequestedURLFilter;
            o.mOperationScope = this.mOperationScope;
            o.mDerefAliases = this.mDerefAliases;
            o.mTypesOnly = this.mTypesOnly;
            o.mSizeLimit = this.mSizeLimit;
            o.mTimeLimit = this.mTimeLimit;
            return o;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

