/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.message;

import com.sap.idm.vds.Engine;
import com.sap.idm.vds.EnginePool;
import com.sap.idm.vds.MVDDebitInfo;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDUserGroup;
import com.sap.idm.vds.config.MVDUserGroupList;
import com.sap.idm.vds.message.MxBind;
import com.sap.idm.vds.message.MxRequest;
import com.sap.idm.vds.message.MxResponse;

public class MxContext {
    protected Engine mEngine;

    public MxContext() {
        try {
            this.mEngine = EnginePool.checkOut();
        }
        catch (Exception e) {
            this.mEngine = null;
        }
    }

    public void close() {
        if (this.mEngine != null) {
            MVDLogger.Log("Checking in Engine.", 2);
            Engine tmp = this.mEngine;
            this.mEngine = null;
            EnginePool.checkIn(tmp);
        }
    }

    public MxResponse bind(String aUsername, String aPassword, String aClientIP) throws Exception {
        if (this.mEngine == null) {
            throw new Exception("Not connected");
        }
        MxBind bind = new MxBind();
        bind.setAuthType(0);
        bind.setUserName(aUsername);
        bind.setPassword(aPassword);
        bind.setClientIP(aClientIP);
        return this.answerRequest(bind);
    }

    public MxResponse bind(String aUsername, String aPassword, String aClientIP, Object aCertificates) throws Exception {
        if (this.mEngine == null) {
            throw new Exception("Not connected");
        }
        MxBind bind = new MxBind();
        bind.setAuthType(0);
        bind.setUserName(aUsername);
        bind.setPassword(aPassword);
        bind.setClientIP(aClientIP);
        bind.setClientCertificates(aCertificates);
        return this.answerRequest(bind);
    }

    public void userGroupBind(int aUserGroup, String aUsername, String aPassword, String aClientIP) throws Exception {
        if (this.mEngine == null) {
            throw new Exception("Not connected");
        }
        MVDUserGroup ug = MVDUserGroupList.getUGByID(aUserGroup);
        MVDDebitInfo debinfo = this.mEngine.getEngineData().MvdDebit();
        debinfo.SetUserName(aUsername);
        debinfo.SetUserPwd(aPassword);
        debinfo.SetClientIPAddress(aClientIP);
        debinfo.SetUserGroup(ug.Name());
        this.mEngine.getEngineData().SetMvdSessionsUserGroup(ug);
        this.mEngine.getEngineData().SetIAmBinded(true);
    }

    public MxResponse answerRequest(MxRequest aMxrequest) throws Exception {
        if (this.mEngine == null) {
            throw new Exception("Not connected");
        }
        return this.mEngine.answerRequest(aMxrequest, "");
    }

    public MxResponse[] answerRequest(MxRequest[] aMxreqArr) throws Exception {
        if (this.mEngine == null) {
            throw new Exception("Not connected");
        }
        return this.mEngine.answerRequest(aMxreqArr, "");
    }

    public Object objAnswerRequest(Object aObject) throws Exception {
        if (this.mEngine == null) {
            throw new Exception("Not connected");
        }
        return this.mEngine.objAnswerRequest(aObject);
    }
}

