/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;

public class SubstringFilterSeqOfChoice
implements LDAPv3 {
    public static final int INITIAL_CID = 0;
    public static final int ANY_CID = 1;
    public static final int FINAL1_CID = 2;
    int[] tag_list = new int[]{0, 1, 2};
    public int choiceId;
    public byte[] initial = null;
    public byte[] any = null;
    public byte[] final1 = null;

    public SubstringFilterSeqOfChoice() {
    }

    public SubstringFilterSeqOfChoice(SubstringFilterSeqOfChoice arg) {
        this.choiceId = arg.choiceId;
        switch (this.choiceId) {
            case 0: {
                this.initial = new byte[arg.initial.length];
                System.arraycopy(arg.initial, 0, this.initial, 0, arg.initial.length);
                break;
            }
            case 1: {
                this.any = new byte[arg.any.length];
                System.arraycopy(arg.any, 0, this.any, 0, arg.any.length);
                break;
            }
            case 2: {
                this.final1 = new byte[arg.final1.length];
                System.arraycopy(arg.final1, 0, this.final1, 0, arg.final1.length);
            }
        }
    }

    public SubstringFilterSeqOfChoice(String mal) {
        Vector v3 = MVDUtil.splitString(mal, "*");
        String first = (String)v3.elementAt(0);
        if (first.length() > 0) {
            byte[] firstasbyte = MVDUtil.ToUTF8(first);
            this.initial = new byte[firstasbyte.length];
            System.arraycopy(firstasbyte, 0, this.initial, 0, firstasbyte.length);
            this.choiceId = 0;
            return;
        }
        int dm = v3.size();
        String last = (String)v3.elementAt(dm - 1);
        if (last.length() > 0) {
            byte[] lastasbyte = MVDUtil.ToUTF8(last);
            this.final1 = new byte[lastasbyte.length];
            System.arraycopy(lastasbyte, 0, this.final1, 0, lastasbyte.length);
            this.choiceId = 2;
            return;
        }
        dm = v3.size();
        for (int x = 1; x < dm - 1; ++x) {
            String anyone = (String)v3.elementAt(1);
            if (anyone.length() <= 0) continue;
            byte[] anyoneasbyte = MVDUtil.ToUTF8(anyone);
            this.any = new byte[anyoneasbyte.length];
            System.arraycopy(anyoneasbyte, 0, this.any, 0, anyoneasbyte.length);
            this.choiceId = 1;
            return;
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int tag = dec.decodeChoice(this.tag_list);
        if (tag == ASN1Decoder.makeTag(2, 0)) {
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 0));
            this.initial = dec.decodeOctetString();
            this.choiceId = 0;
        }
        if (tag == ASN1Decoder.makeTag(2, 1)) {
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 1));
            this.any = dec.decodeOctetString();
            this.choiceId = 1;
        }
        if (tag == ASN1Decoder.makeTag(2, 2)) {
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 2));
            this.final1 = dec.decodeOctetString();
            this.choiceId = 2;
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeChoice(this.choiceId, this.tag_list);
        switch (this.choiceId) {
            case 0: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 0));
                enc.encodeOctetString(this.initial);
                break;
            }
            case 1: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 1));
                enc.encodeOctetString(this.any);
                break;
            }
            case 2: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 2));
                enc.encodeOctetString(this.final1);
            }
        }
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        os.println("{ -- CHOICE --");
        switch (this.choiceId) {
            case 0: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("initial = ");
                try {
                    new HexOutputStream(os).write(this.initial);
                }
                catch (IOException ex) {
                    os.print("( unprintable OCTET STRING value )");
                }
                break;
            }
            case 1: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("any = ");
                try {
                    new HexOutputStream(os).write(this.any);
                }
                catch (IOException ex) {
                    os.print("( unprintable OCTET STRING value )");
                }
                break;
            }
            case 2: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("final = ");
                try {
                    new HexOutputStream(os).write(this.final1);
                    break;
                }
                catch (IOException ex) {
                    os.print("( unprintable OCTET STRING value )");
                }
            }
        }
        for (int ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print("}");
    }
}

