/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.ldapv3.LDAPv3;
import com.sap.idm.vds.ldapv3.SubstringFilterSeqOf;
import com.sap.idm.vds.ldapv3.SubstringFilterSeqOfChoice;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;

public class SubstringFilter
implements LDAPv3 {
    public byte[] type;
    public SubstringFilterSeqOf substrings = new SubstringFilterSeqOf();

    public SubstringFilter() {
    }

    public SubstringFilter(SubstringFilter arg) {
        this.type = new byte[arg.type.length];
        System.arraycopy(arg.type, 0, this.type, 0, arg.type.length);
        this.substrings = new SubstringFilterSeqOf(arg.substrings);
    }

    public SubstringFilter(String mal) {
        Vector v2 = MVDUtil.splitString(mal, "=");
        byte[] value = MVDUtil.ToUTF8((String)v2.elementAt(0));
        this.type = new byte[value.length];
        System.arraycopy(value, 0, this.type, 0, value.length);
        this.substrings = new SubstringFilterSeqOf((String)v2.elementAt(1));
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        this.type = dec.decodeOctetString();
        this.substrings.decode(dec);
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.type);
        this.substrings.encode(enc);
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("type = ");
        try {
            new HexOutputStream(os).write(this.type);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("substrings = ");
        this.substrings.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public String toURL() {
        String resString = "";
        String sss = MVDUtil.FromUTF8(this.type);
        if (sss.equalsIgnoreCase("INVALIDATTR")) {
            return "(INVALIDFILTER)";
        }
        if (sss.equalsIgnoreCase("IGNOREDATTR")) {
            return "(IGNOREDFILTER)";
        }
        int ls = this.substrings.size();
        resString = ls > 0 ? this.GetResString(ls) : "*";
        resString = MVDUtil.replace(resString, "**", "*");
        resString = "(" + sss + "=" + resString + ")";
        return resString;
    }

    private String GetResString(int ls) {
        String resString = "";
        for (int x = 0; x < ls; ++x) {
            SubstringFilterSeqOfChoice sfqHelp = (SubstringFilterSeqOfChoice)this.substrings.elementAt(x);
            if (sfqHelp.choiceId == 0) {
                if (resString.startsWith("*")) {
                    resString = MVDUtil.FromUTF8(sfqHelp.initial) + resString;
                    continue;
                }
                resString = MVDUtil.FromUTF8(sfqHelp.initial) + "*" + resString;
                continue;
            }
            if (sfqHelp.choiceId == 1) {
                if (resString.endsWith("*")) {
                    resString = resString + MVDUtil.FromUTF8(sfqHelp.any) + "*";
                    continue;
                }
                resString = resString + "*" + MVDUtil.FromUTF8(sfqHelp.any) + "*";
                continue;
            }
            if (sfqHelp.choiceId != 2) continue;
            resString = resString.endsWith("*") ? resString + MVDUtil.FromUTF8(sfqHelp.final1) : resString + "*" + MVDUtil.FromUTF8(sfqHelp.final1);
        }
        return resString;
    }

    public String toDBFilter(MVDDataSource ds) {
        String dbQuote;
        HashMap sensh;
        String resString = "";
        String sss = MVDUtil.FromUTF8(this.type);
        if (sss.equalsIgnoreCase("INVALIDATTR")) {
            return "(INVALIDFILTER)";
        }
        if (sss.equalsIgnoreCase("IGNOREDATTR")) {
            return "(IGNOREDFILTER)";
        }
        int ls = this.substrings.size();
        resString = ls > 0 ? this.GetResString(ls) : "*";
        String tmpVal = "";
        if (ds.IsCaseSensitive() && (sensh = ds.CaseSensitivityMap()) != null && (tmpVal = (String)ds.CaseSensitivityMap().get(sss.toLowerCase())) != null) {
            sss = tmpVal;
        }
        if ((dbQuote = (String)ds.ParamFields().get("DS_DO_DBQUOTE")) != null && dbQuote.equalsIgnoreCase("true")) {
            String lc = (String)ds.ParamFields().get("DS_LEFT_QUOTECHAR");
            String rc = (String)ds.ParamFields().get("DS_RIGHT_QUOTECHAR");
            if (lc != null && rc != null) {
                sss = lc + sss + rc;
            }
        }
        resString = MVDUtil.replace(resString, "**", "*");
        resString = MVDUtil.replace(resString, "'", "''");
        resString = sss + " like '" + resString + "' ";
        return resString;
    }

    public String toIdSFilter() {
        String resString = "";
        String sss = MVDUtil.FromUTF8(this.type);
        if (sss.equalsIgnoreCase("INVALIDATTR")) {
            return "(INVALIDFILTER)";
        }
        if (sss.equalsIgnoreCase("IGNOREDATTR")) {
            return "(IGNOREDFILTER)";
        }
        int ls = this.substrings.size();
        resString = ls > 0 ? this.GetResString(ls) : "*";
        resString = MVDUtil.replace(resString, "**", "*");
        resString = "mskey in (select mskey from mxiv_entries where attrname='" + sss + "' and is_id=1 " + "and searchvalue like '" + resString + "')";
        return resString;
    }

    public void fixFilter(HashMap hmAvailable, HashMap hmIgnored, HashMap hmInMapping) {
        String sss = MVDUtil.FromUTF8(this.type).toLowerCase();
        if (hmInMapping != null && hmInMapping.containsKey(sss)) {
            this.type = MVDUtil.ToUTF8((String)hmInMapping.get(sss));
            sss = MVDUtil.FromUTF8(this.type);
        }
        if (hmIgnored != null && hmIgnored.containsKey(sss)) {
            this.type = MVDUtil.ToUTF8("IGNOREDATTR");
            return;
        }
        if (hmAvailable != null) {
            Object sVal = hmAvailable.get(sss);
            if (sVal == null) {
                this.type = MVDUtil.ToUTF8("INVALIDATTR");
            } else if (sVal instanceof String) {
                this.type = MVDUtil.ToUTF8((String)sVal);
            } else if (sVal instanceof Vector) {
                this.type = MVDUtil.ToUTF8((String)((Vector)sVal).elementAt(0));
            }
            return;
        }
    }

    public boolean testFilter(HashMap hmTestOn, boolean defaultNonExisting) {
        String sss = MVDUtil.FromUTF8(this.type).toLowerCase();
        if (hmTestOn == null || !hmTestOn.containsKey(sss)) {
            return defaultNonExisting;
        }
        String sVal = ((String)hmTestOn.get(sss)).toLowerCase();
        int ls = this.substrings.size();
        String sComp = "";
        for (int x = 0; x < ls; ++x) {
            SubstringFilterSeqOfChoice sfqHelp = (SubstringFilterSeqOfChoice)this.substrings.elementAt(x);
            if (sfqHelp.choiceId == 0) {
                sComp = "|" + MVDUtil.FromUTF8(sfqHelp.initial).toLowerCase();
            } else if (sfqHelp.choiceId == 1) {
                sComp = MVDUtil.FromUTF8(sfqHelp.any).toLowerCase();
            } else if (sfqHelp.choiceId == 2) {
                sComp = MVDUtil.FromUTF8(sfqHelp.final1).toLowerCase() + "|";
            }
            if (sVal.indexOf(sComp) <= -1) continue;
            return true;
        }
        return false;
    }
}

