/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import com.sap.idm.vds.ldapv3.PartialAttributeListSeqSetOf;
import java.io.IOException;
import java.io.PrintStream;

public class PartialAttributeListSeq
implements LDAPv3 {
    public byte[] type;
    public PartialAttributeListSeqSetOf vals = new PartialAttributeListSeqSetOf();

    public PartialAttributeListSeq() {
    }

    public PartialAttributeListSeq(PartialAttributeListSeq arg) {
        this.type = new byte[arg.type.length];
        System.arraycopy(arg.type, 0, this.type, 0, arg.type.length);
        this.vals = new PartialAttributeListSeqSetOf(arg.vals);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        this.type = dec.decodeOctetString();
        this.vals.decode(dec);
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.type);
        this.vals.encode(enc);
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("type = ");
        try {
            new HexOutputStream(os).write(this.type);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("vals = ");
        this.vals.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

