/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.ldapv3.AttributeTypeAndValues;
import com.sap.idm.vds.ldapv3.LDAPv3;
import com.sap.idm.vds.ldapv3.ModifyRequestSeqOfSeqEnum;
import java.io.PrintStream;

public class ModifyRequestSeqOfSeq
implements LDAPv3 {
    public ModifyRequestSeqOfSeqEnum operation = new ModifyRequestSeqOfSeqEnum();
    public AttributeTypeAndValues modification = new AttributeTypeAndValues();

    public ModifyRequestSeqOfSeq() {
    }

    public ModifyRequestSeqOfSeq(ModifyRequestSeqOfSeq arg) {
        this.operation = new ModifyRequestSeqOfSeqEnum(arg.operation);
        this.modification = new AttributeTypeAndValues(arg.modification);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        this.operation.decode(dec);
        this.modification.decode(dec);
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        this.operation.encode(enc);
        this.modification.encode(enc);
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("operation = ");
        this.operation.print(os, indent + 2);
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("modification = ");
        this.modification.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

