/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import com.sap.idm.vds.ldapv3.ModifyRequestSeqOf;
import java.io.IOException;
import java.io.PrintStream;

public class ModifyRequest
implements LDAPv3 {
    public byte[] object;
    public ModifyRequestSeqOf modification = new ModifyRequestSeqOf();

    public ModifyRequest() {
    }

    public ModifyRequest(ModifyRequest arg) {
        this.object = new byte[arg.object.length];
        System.arraycopy(arg.object, 0, this.object, 0, arg.object.length);
        this.modification = new ModifyRequestSeqOf(arg.modification);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag(1, 6));
        int seq_nr = dec.decodeSequence();
        this.object = dec.decodeOctetString();
        this.modification.decode(dec);
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag(1, 6));
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.object);
        this.modification.encode(enc);
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("object = ");
        try {
            new HexOutputStream(os).write(this.object);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("modification = ");
        this.modification.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

