/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.IOException;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Vector;

public class MatchingRuleAssertion
implements LDAPv3 {
    public byte[] matchingRule = null;
    public byte[] type = null;
    public byte[] matchValue;
    public boolean dnAttributes = false;

    public MatchingRuleAssertion() {
    }

    public MatchingRuleAssertion(MatchingRuleAssertion arg) {
        this.matchingRule = new byte[arg.matchingRule.length];
        System.arraycopy(arg.matchingRule, 0, this.matchingRule, 0, arg.matchingRule.length);
        this.type = new byte[arg.type.length];
        System.arraycopy(arg.type, 0, this.type, 0, arg.type.length);
        this.matchValue = new byte[arg.matchValue.length];
        System.arraycopy(arg.matchValue, 0, this.matchValue, 0, arg.matchValue.length);
        this.dnAttributes = arg.dnAttributes;
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        if (!dec.nextIsOptional(ASN1Decoder.makeTag(2, 1))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 1));
            this.matchingRule = dec.decodeOctetString();
        }
        if (!dec.nextIsOptional(ASN1Decoder.makeTag(2, 2))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 2));
            this.type = dec.decodeOctetString();
        }
        dec.nextIsImplicit(ASN1Decoder.makeTag(2, 3));
        this.matchValue = dec.decodeOctetString();
        if (!dec.nextIsDefault(ASN1Decoder.makeTag(2, 4))) {
            dec.nextIsImplicit(ASN1Decoder.makeTag(2, 4));
            this.dnAttributes = dec.decodeBoolean();
        }
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        if (this.matchingRule != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag(2, 1));
            enc.encodeOctetString(this.matchingRule);
        }
        if (this.type != null) {
            enc.nextIsImplicit(ASN1Encoder.makeTag(2, 2));
            enc.encodeOctetString(this.type);
        }
        enc.nextIsImplicit(ASN1Encoder.makeTag(2, 3));
        enc.encodeOctetString(this.matchValue);
        if (enc.encodeDefault() || this.dnAttributes) {
            enc.nextIsImplicit(ASN1Encoder.makeTag(2, 4));
            enc.encodeBoolean(this.dnAttributes);
        }
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        if (this.matchingRule != null) {
            for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
                os.print(' ');
            }
            os.print("matchingRule = ");
            try {
                new HexOutputStream(os).write(this.matchingRule);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println(',');
        if (this.type != null) {
            for (int ii3 = 0; ii3 < indent + 2; ++ii3) {
                os.print(' ');
            }
            os.print("type = ");
            try {
                new HexOutputStream(os).write(this.type);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println(',');
        for (int ii4 = 0; ii4 < indent + 2; ++ii4) {
            os.print(' ');
        }
        os.print("matchValue = ");
        try {
            new HexOutputStream(os).write(this.matchValue);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("dnAttributes = ");
        os.print(this.dnAttributes);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public String toURL() {
        String resString = "";
        boolean b = this.dnAttributes;
        byte[] bts = this.matchingRule;
        String aRule = MVDUtil.FromUTF8(bts);
        if (aRule.equals("1.2.840.113556.1.4.803") || aRule.equals("1.2.840.113556.1.4.804") || aRule.equals("and") || aRule.equals("or")) {
            byte[] bty = this.type;
            byte[] bval = this.matchValue;
            String btyStr = MVDUtil.FromUTF8(bty);
            if (btyStr.equalsIgnoreCase("INVALIDATTR")) {
                return "(INVALIDFILTER)";
            }
            if (btyStr.equalsIgnoreCase("IGNOREDATTR")) {
                return "(IGNOREDFILTER)";
            }
            String bvalStr = "";
            bvalStr = MVDUtilities.IsBinaryAttribute(btyStr) ? MVDUtil.byteToEscapedHex(bval) : MVDUtil.FromUTF8(bval);
            resString = btyStr + ":" + aRule + ":=" + bvalStr;
            return "(" + resString + ")";
        }
        return "NOT IMPLENETED";
    }

    public void fixFilter(HashMap hmAvailable, HashMap hmIgnored, HashMap hmInMapping) {
        String aRule = MVDUtil.FromUTF8(this.matchingRule);
        String sss = MVDUtil.FromUTF8(this.type).toLowerCase();
        if (hmInMapping != null && hmInMapping.containsKey(sss)) {
            this.type = MVDUtil.ToUTF8((String)hmInMapping.get(sss));
            sss = MVDUtil.FromUTF8(this.type);
        }
        if (hmIgnored != null && hmIgnored.containsKey(sss)) {
            String ss = "IGNOREDATTR";
            this.type = MVDUtil.ToUTF8(ss);
            return;
        }
        if (hmAvailable != null) {
            Object sVal = hmAvailable.get(sss);
            if (sVal == null) {
                String ss = "INVALIDATTR";
                this.type = MVDUtil.ToUTF8(ss);
            } else if (sVal instanceof String) {
                this.type = MVDUtil.ToUTF8((String)sVal);
            } else if (sVal instanceof Vector) {
                this.type = MVDUtil.ToUTF8(sss);
            }
            return;
        }
    }
}

