/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.ldapv3.AbandonRequest;
import com.sap.idm.vds.ldapv3.AddRequest;
import com.sap.idm.vds.ldapv3.AddResponse;
import com.sap.idm.vds.ldapv3.BindRequest;
import com.sap.idm.vds.ldapv3.BindResponse;
import com.sap.idm.vds.ldapv3.CompareRequest;
import com.sap.idm.vds.ldapv3.CompareResponse;
import com.sap.idm.vds.ldapv3.DelRequest;
import com.sap.idm.vds.ldapv3.DelResponse;
import com.sap.idm.vds.ldapv3.ExtendedRequest;
import com.sap.idm.vds.ldapv3.ExtendedResponse;
import com.sap.idm.vds.ldapv3.LDAPv3;
import com.sap.idm.vds.ldapv3.ModifyDNRequest;
import com.sap.idm.vds.ldapv3.ModifyDNResponse;
import com.sap.idm.vds.ldapv3.ModifyRequest;
import com.sap.idm.vds.ldapv3.ModifyResponse;
import com.sap.idm.vds.ldapv3.SearchRequest;
import com.sap.idm.vds.ldapv3.SearchResultDone;
import com.sap.idm.vds.ldapv3.SearchResultEntry;
import com.sap.idm.vds.ldapv3.SearchResultReference;
import com.sap.idm.vds.ldapv3.UnbindRequest;
import java.io.PrintStream;

public class LDAPMessageChoice
implements LDAPv3 {
    public static final int BINDREQUEST_CID = 0;
    public static final int BINDRESPONSE_CID = 1;
    public static final int UNBINDREQUEST_CID = 2;
    public static final int SEARCHREQUEST_CID = 3;
    public static final int SEARCHRESENTRY_CID = 4;
    public static final int SEARCHRESDONE_CID = 5;
    public static final int SEARCHRESREF_CID = 19;
    public static final int MODIFYREQUEST_CID = 6;
    public static final int MODIFYRESPONSE_CID = 7;
    public static final int ADDREQUEST_CID = 8;
    public static final int ADDRESPONSE_CID = 9;
    public static final int DELREQUEST_CID = 10;
    public static final int DELRESPONSE_CID = 11;
    public static final int MODDNREQUEST_CID = 12;
    public static final int MODDNRESPONSE_CID = 13;
    public static final int COMPAREREQUEST_CID = 14;
    public static final int COMPARERESPONSE_CID = 15;
    public static final int ABANDONREQUEST_CID = 16;
    public static final int EXTENDEDREQ_CID = 23;
    public static final int EXTENDEDRESP_CID = 24;
    int[] tag_list = new int[]{0, 1, 2, 3, 4, 5, 19, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 23, 24};
    public int choiceId;
    public BindRequest bindRequest = null;
    public BindResponse bindResponse = null;
    public UnbindRequest unbindRequest = null;
    public SearchRequest searchRequest = null;
    public SearchResultEntry searchResEntry = null;
    public SearchResultDone searchResDone = null;
    public SearchResultReference searchResRef = null;
    public ModifyRequest modifyRequest = null;
    public ModifyResponse modifyResponse = null;
    public AddRequest addRequest = null;
    public AddResponse addResponse = null;
    public DelRequest delRequest = null;
    public DelResponse delResponse = null;
    public ModifyDNRequest modDNRequest = null;
    public ModifyDNResponse modDNResponse = null;
    public CompareRequest compareRequest = null;
    public CompareResponse compareResponse = null;
    public AbandonRequest abandonRequest = null;
    public ExtendedRequest extendedReq = null;
    public ExtendedResponse extendedResp = null;

    public LDAPMessageChoice() {
    }

    public LDAPMessageChoice(LDAPMessageChoice arg) {
        this.choiceId = arg.choiceId;
        switch (this.choiceId) {
            case 0: {
                this.bindRequest = new BindRequest(arg.bindRequest);
                break;
            }
            case 1: {
                this.bindResponse = new BindResponse(arg.bindResponse);
                break;
            }
            case 2: {
                this.unbindRequest = new UnbindRequest(arg.unbindRequest);
                break;
            }
            case 3: {
                this.searchRequest = new SearchRequest(arg.searchRequest);
                break;
            }
            case 4: {
                this.searchResEntry = new SearchResultEntry(arg.searchResEntry);
                break;
            }
            case 5: {
                this.searchResDone = new SearchResultDone(arg.searchResDone);
                break;
            }
            case 19: {
                this.searchResRef = new SearchResultReference(arg.searchResRef);
                break;
            }
            case 6: {
                this.modifyRequest = new ModifyRequest(arg.modifyRequest);
                break;
            }
            case 7: {
                this.modifyResponse = new ModifyResponse(arg.modifyResponse);
                break;
            }
            case 8: {
                this.addRequest = new AddRequest(arg.addRequest);
                break;
            }
            case 9: {
                this.addResponse = new AddResponse(arg.addResponse);
                break;
            }
            case 10: {
                this.delRequest = new DelRequest(arg.delRequest);
                break;
            }
            case 11: {
                this.delResponse = new DelResponse(arg.delResponse);
                break;
            }
            case 12: {
                this.modDNRequest = new ModifyDNRequest(arg.modDNRequest);
                break;
            }
            case 13: {
                this.modDNResponse = new ModifyDNResponse(arg.modDNResponse);
                break;
            }
            case 14: {
                this.compareRequest = new CompareRequest(arg.compareRequest);
                break;
            }
            case 15: {
                this.compareResponse = new CompareResponse(arg.compareResponse);
                break;
            }
            case 16: {
                this.abandonRequest = new AbandonRequest(arg.abandonRequest);
                break;
            }
            case 23: {
                this.extendedReq = new ExtendedRequest(arg.extendedReq);
                break;
            }
            case 24: {
                this.extendedResp = new ExtendedResponse(arg.extendedResp);
            }
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int tag = dec.decodeChoice(this.tag_list);
        if (tag == ASN1Decoder.makeTag(1, 0)) {
            this.bindRequest = new BindRequest();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 0));
            this.bindRequest.decode(dec);
            this.choiceId = 0;
        } else if (tag == ASN1Decoder.makeTag(1, 1)) {
            this.bindResponse = new BindResponse();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 1));
            this.bindResponse.decode(dec);
            this.choiceId = 1;
        } else if (tag == ASN1Decoder.makeTag(1, 2)) {
            this.unbindRequest = new UnbindRequest();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 2));
            this.unbindRequest.decode(dec);
            this.choiceId = 2;
        } else if (tag == ASN1Decoder.makeTag(1, 3)) {
            this.searchRequest = new SearchRequest();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 3));
            this.searchRequest.decode(dec);
            this.choiceId = 3;
        } else if (tag == ASN1Decoder.makeTag(1, 4)) {
            this.searchResEntry = new SearchResultEntry();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 4));
            this.searchResEntry.decode(dec);
            this.choiceId = 4;
        } else if (tag == ASN1Decoder.makeTag(1, 5)) {
            this.searchResDone = new SearchResultDone();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 5));
            this.searchResDone.decode(dec);
            this.choiceId = 5;
        } else if (tag == ASN1Decoder.makeTag(1, 19)) {
            this.searchResRef = new SearchResultReference();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 19));
            this.searchResRef.decode(dec);
            this.choiceId = 19;
        } else if (tag == ASN1Decoder.makeTag(1, 6)) {
            this.modifyRequest = new ModifyRequest();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 6));
            this.modifyRequest.decode(dec);
            this.choiceId = 6;
        } else if (tag == ASN1Decoder.makeTag(1, 7)) {
            this.modifyResponse = new ModifyResponse();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 7));
            this.modifyResponse.decode(dec);
            this.choiceId = 7;
        } else if (tag == ASN1Decoder.makeTag(1, 8)) {
            this.addRequest = new AddRequest();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 8));
            this.addRequest.decode(dec);
            this.choiceId = 8;
        } else if (tag == ASN1Decoder.makeTag(1, 9)) {
            this.addResponse = new AddResponse();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 9));
            this.addResponse.decode(dec);
            this.choiceId = 9;
        } else if (tag == ASN1Decoder.makeTag(1, 10)) {
            this.delRequest = new DelRequest();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 4));
            this.delRequest.decode(dec);
            this.choiceId = 10;
        } else if (tag == ASN1Decoder.makeTag(1, 11)) {
            this.delResponse = new DelResponse();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 16));
            this.delResponse.decode(dec);
            this.choiceId = 11;
        } else if (tag == ASN1Decoder.makeTag(1, 12)) {
            this.modDNRequest = new ModifyDNRequest();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 12));
            this.modDNRequest.decode(dec);
            this.choiceId = 12;
        } else if (tag == ASN1Decoder.makeTag(1, 13)) {
            this.modDNResponse = new ModifyDNResponse();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 13));
            this.modDNResponse.decode(dec);
            this.choiceId = 13;
        } else if (tag == ASN1Decoder.makeTag(1, 14)) {
            this.compareRequest = new CompareRequest();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 14));
            this.compareRequest.decode(dec);
            this.choiceId = 14;
        } else if (tag == ASN1Decoder.makeTag(1, 15)) {
            this.compareResponse = new CompareResponse();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 15));
            this.compareResponse.decode(dec);
            this.choiceId = 15;
        } else if (tag == ASN1Decoder.makeTag(1, 16)) {
            this.abandonRequest = new AbandonRequest();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 16));
            this.abandonRequest.decode(dec);
            this.choiceId = 16;
        } else if (tag == ASN1Decoder.makeTag(1, 23)) {
            this.extendedReq = new ExtendedRequest();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 23));
            this.extendedReq.decode(dec);
            this.choiceId = 23;
        } else if (tag == ASN1Decoder.makeTag(1, 24)) {
            this.extendedResp = new ExtendedResponse();
            dec.nextIsImplicit(ASN1Decoder.makeTag(1, 24));
            this.extendedResp.decode(dec);
            this.choiceId = 24;
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeChoice(this.choiceId, this.tag_list);
        switch (this.choiceId) {
            case 0: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 0));
                this.bindRequest.encode(enc);
                break;
            }
            case 1: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 1));
                this.bindResponse.encode(enc);
                break;
            }
            case 2: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 2));
                this.unbindRequest.encode(enc);
                break;
            }
            case 3: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 3));
                this.searchRequest.encode(enc);
                break;
            }
            case 4: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 4));
                this.searchResEntry.encode(enc);
                break;
            }
            case 5: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 5));
                this.searchResDone.encode(enc);
                break;
            }
            case 19: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 19));
                this.searchResRef.encode(enc);
                break;
            }
            case 6: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 6));
                this.modifyRequest.encode(enc);
                break;
            }
            case 7: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 7));
                this.modifyResponse.encode(enc);
                break;
            }
            case 8: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 8));
                this.addRequest.encode(enc);
                break;
            }
            case 9: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 9));
                this.addResponse.encode(enc);
                break;
            }
            case 10: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 10));
                this.delRequest.encode(enc);
                break;
            }
            case 11: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 11));
                this.delResponse.encode(enc);
                break;
            }
            case 12: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 12));
                this.modDNRequest.encode(enc);
                break;
            }
            case 13: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 13));
                this.modDNResponse.encode(enc);
                break;
            }
            case 14: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 14));
                this.compareRequest.encode(enc);
                break;
            }
            case 15: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 15));
                this.compareResponse.encode(enc);
                break;
            }
            case 16: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 16));
                this.abandonRequest.encode(enc);
                break;
            }
            case 23: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 23));
                this.extendedReq.encode(enc);
                break;
            }
            case 24: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(1, 24));
                this.extendedResp.encode(enc);
            }
        }
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- CHOICE --");
        switch (this.choiceId) {
            case 0: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("bindRequest = ");
                this.bindRequest.print(os, indent + 2);
                break;
            }
            case 1: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("bindResponse = ");
                this.bindResponse.print(os, indent + 2);
                break;
            }
            case 2: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("unbindRequest = ");
                this.unbindRequest.print(os, indent + 2);
                break;
            }
            case 3: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("searchRequest = ");
                this.searchRequest.print(os, indent + 2);
                break;
            }
            case 4: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("searchResEntry = ");
                this.searchResEntry.print(os, indent + 2);
                break;
            }
            case 5: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("searchResDone = ");
                this.searchResDone.print(os, indent + 2);
                break;
            }
            case 19: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("searchResRef = ");
                this.searchResRef.print(os, indent + 2);
                break;
            }
            case 6: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("modifyRequest = ");
                this.modifyRequest.print(os, indent + 2);
                break;
            }
            case 7: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("modifyResponse = ");
                this.modifyResponse.print(os, indent + 2);
                break;
            }
            case 8: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("addRequest = ");
                this.addRequest.print(os, indent + 2);
                break;
            }
            case 9: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("addResponse = ");
                this.addResponse.print(os, indent + 2);
                break;
            }
            case 10: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("delRequest = ");
                this.delRequest.print(os, indent + 2);
                break;
            }
            case 11: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("delResponse = ");
                this.delResponse.print(os, indent + 2);
                break;
            }
            case 12: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("modDNRequest = ");
                this.modDNRequest.print(os, indent + 2);
                break;
            }
            case 13: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("modDNResponse = ");
                this.modDNResponse.print(os, indent + 2);
                break;
            }
            case 14: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("compareRequest = ");
                this.compareRequest.print(os, indent + 2);
                break;
            }
            case 15: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("compareResponse = ");
                this.compareResponse.print(os, indent + 2);
                break;
            }
            case 16: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("abandonRequest = ");
                this.abandonRequest.print(os, indent + 2);
                break;
            }
            case 23: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("extendedReq = ");
                this.extendedReq.print(os, indent + 2);
                break;
            }
            case 24: {
                for (ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("extendedResp = ");
                this.extendedResp.print(os, indent + 2);
            }
        }
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print("}");
    }
}

