/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.ldapv3.Filter;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class FilterSetOf
extends Vector
implements LDAPv3 {
    public FilterSetOf() {
    }

    public FilterSetOf(FilterSetOf arg) {
        int ls = arg.size();
        for (int x = 0; x < ls; ++x) {
            Filter tmp = new Filter((Filter)arg.elementAt(x));
            this.add(tmp);
        }
    }

    public FilterSetOf(String mal) {
        int sum = 0;
        int previous = 0;
        for (int x = 0; x < mal.length(); ++x) {
            char c = mal.charAt(x);
            if (c == '(') {
                ++sum;
            }
            if (c != ')' || --sum != 0) continue;
            Filter tmp = new Filter(mal.substring(previous, x + 1));
            this.add(tmp);
            previous = x + 1;
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int set_of_nr = dec.decodeSetOf();
        while (!dec.endOf(set_of_nr)) {
            Filter tmp = new Filter();
            tmp.decode(dec);
            this.add(tmp);
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int set_of_nr = enc.encodeSetOf();
        int ls = this.size();
        for (int x = 0; x < ls; ++x) {
            ((Filter)this.elementAt(x)).encode(enc);
        }
        enc.endOf(set_of_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        boolean nonePrinted = true;
        os.println("{ -- SET OF --");
        Enumeration e = this.elements();
        while (e.hasMoreElements()) {
            if (!nonePrinted) {
                os.println(',');
            }
            nonePrinted = false;
            for (int ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            ((Filter)e.nextElement()).print(os, indent + 2);
            if (e.hasMoreElements()) continue;
            os.println();
        }
        for (int ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }

    public String toURL() {
        String resString = "";
        String tempString = "";
        int cnt = 0;
        int ls = this.size();
        for (int x = 0; x < ls; ++x) {
            Filter fHelp = (Filter)this.elementAt(x);
            tempString = fHelp.toURL();
            if (tempString.equalsIgnoreCase("(INVALIDFILTER)")) {
                return "(INVALIDFILTER)";
            }
            if (tempString.equalsIgnoreCase("(IGNOREDFILTER)")) {
                tempString = "";
            } else {
                ++cnt;
            }
            resString = resString + tempString;
        }
        if (cnt >= 2) {
            resString = "(&" + resString + ")";
        } else if (cnt == 0) {
            resString = "(IGNOREDFILTER)";
        }
        return resString;
    }

    public String toDBFilter(MVDDataSource ds) {
        String resString = "";
        String tempString = "";
        int cnt = 0;
        int ls = this.size();
        for (int x = 0; x < ls; ++x) {
            Filter fHelp = (Filter)this.elementAt(x);
            tempString = fHelp.toDBFilter(ds);
            if (tempString.equalsIgnoreCase("(INVALIDFILTER)")) {
                return "(INVALIDFILTER)";
            }
            if (tempString.equalsIgnoreCase("(IGNOREDFILTER)")) {
                tempString = "";
                continue;
            }
            ++cnt;
            if (resString.length() > 0) {
                resString = resString + " AND ";
            }
            resString = resString + "(" + tempString + ")";
        }
        resString = cnt == 0 ? "(IGNOREDFILTER)" : "(" + resString + ")";
        return resString;
    }

    public String toIdSFilter() {
        String resString = "";
        String tempString = "";
        int cnt = 0;
        int ls = this.size();
        for (int x = 0; x < ls; ++x) {
            Filter fHelp = (Filter)this.elementAt(x);
            tempString = fHelp.toIdSFilter();
            if (tempString.equalsIgnoreCase("(INVALIDFILTER)")) {
                return "(INVALIDFILTER)";
            }
            if (tempString.equalsIgnoreCase("(IGNOREDFILTER)")) {
                tempString = "";
                continue;
            }
            ++cnt;
            if (resString.length() > 0) {
                resString = resString + " AND ";
            }
            resString = resString + "(" + tempString + ")";
        }
        resString = cnt == 0 ? "(IGNOREDFILTER)" : "(" + resString + ")";
        return resString;
    }

    public void fixFilter(HashMap hmAvailable, HashMap hmIgnored, HashMap hmInMapping) {
        int ls = this.size();
        for (int x = 0; x < ls; ++x) {
            Filter fHelp = (Filter)this.elementAt(x);
            fHelp.fixFilter(hmAvailable, hmIgnored, hmInMapping);
        }
    }

    public boolean testFilter(HashMap hmTestOn, boolean defaultNonExisting) {
        int ls = this.size();
        for (int x = 0; x < ls; ++x) {
            Filter fHelp = (Filter)this.elementAt(x);
            boolean bRes = fHelp.testFilter(hmTestOn, defaultNonExisting);
            if (bRes) continue;
            return false;
        }
        return true;
    }
}

