/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.IOException;
import java.io.PrintStream;

public class Control
implements LDAPv3 {
    public byte[] controlType;
    public boolean criticality = false;
    public byte[] controlValue = null;

    public Control() {
    }

    public Control(Control arg) {
        this.controlType = new byte[arg.controlType.length];
        System.arraycopy(arg.controlType, 0, this.controlType, 0, arg.controlType.length);
        this.criticality = arg.criticality;
        this.controlValue = new byte[arg.controlValue.length];
        System.arraycopy(arg.controlValue, 0, this.controlValue, 0, arg.controlValue.length);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int seq_nr = dec.decodeSequence();
        this.controlType = dec.decodeOctetString();
        if (!dec.nextIsDefault(ASN1Decoder.makeTag(0, 1))) {
            this.criticality = dec.decodeBoolean();
        }
        if (!dec.nextIsOptional(ASN1Decoder.makeTag(0, 4))) {
            this.controlValue = dec.decodeOctetString();
        }
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        int seq_nr = enc.encodeSequence();
        enc.encodeOctetString(this.controlType);
        if (enc.encodeDefault() || this.criticality) {
            enc.encodeBoolean(this.criticality);
        }
        if (this.controlValue != null) {
            enc.encodeOctetString(this.controlValue);
        }
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        os.println("{ -- SEQUENCE --");
        for (int ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("controlType = ");
        try {
            new HexOutputStream(os).write(this.controlType);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("criticality = ");
        os.print(this.criticality);
        os.println(',');
        if (this.controlValue != null) {
            for (ii = 0; ii < indent + 2; ++ii) {
                os.print(' ');
            }
            os.print("controlValue = ");
            try {
                new HexOutputStream(os).write(this.controlValue);
            }
            catch (IOException ex) {
                os.print("( unprintable OCTET STRING value )");
            }
        }
        os.println();
        for (int ii3 = 0; ii3 < indent; ++ii3) {
            os.print(' ');
        }
        os.print('}');
    }
}

