/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.AuthenticationChoice;
import com.sap.idm.vds.ldapv3.LDAPv3;
import java.io.IOException;
import java.io.PrintStream;
import java.math.BigInteger;

public class BindRequest
implements LDAPv3 {
    public BigInteger version;
    public byte[] name;
    public AuthenticationChoice authentication = new AuthenticationChoice();

    public BindRequest() {
    }

    public BindRequest(BindRequest arg) {
        this.version = arg.version;
        this.name = new byte[arg.name.length];
        System.arraycopy(arg.name, 0, this.name, 0, arg.name.length);
        this.authentication = new AuthenticationChoice(arg.authentication);
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        dec.nextIsImplicit(ASN1Decoder.makeTag(1, 0));
        int seq_nr = dec.decodeSequence();
        this.version = dec.decodeInteger();
        this.name = dec.decodeOctetString();
        this.authentication.decode(dec);
        dec.endOf(seq_nr);
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.nextIsImplicit(ASN1Encoder.makeTag(1, 0));
        int seq_nr = enc.encodeSequence();
        enc.encodeInteger(this.version);
        enc.encodeOctetString(this.name);
        this.authentication.encode(enc);
        enc.endOf(seq_nr);
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        int ii;
        int ii2;
        os.println("{ -- SEQUENCE --");
        for (ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("version = ");
        os.print(this.version.toString());
        os.println(',');
        for (ii2 = 0; ii2 < indent + 2; ++ii2) {
            os.print(' ');
        }
        os.print("name = ");
        try {
            new HexOutputStream(os).write(this.name);
        }
        catch (IOException ex) {
            os.print("( unprintable OCTET STRING value )");
        }
        os.println(',');
        for (ii = 0; ii < indent + 2; ++ii) {
            os.print(' ');
        }
        os.print("authentication = ");
        this.authentication.print(os, indent + 2);
        os.println();
        for (ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print('}');
    }
}

