/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.ldapv3;

import com.sap.idm.vds.asn1.ASN1Decoder;
import com.sap.idm.vds.asn1.ASN1Encoder;
import com.sap.idm.vds.asn1.ASN1Exception;
import com.sap.idm.vds.asn1.util.HexOutputStream;
import com.sap.idm.vds.ldapv3.LDAPv3;
import com.sap.idm.vds.ldapv3.SaslCredentials;
import java.io.IOException;
import java.io.PrintStream;

public class AuthenticationChoice
implements LDAPv3 {
    public static final int SIMPLE_CID = 0;
    public static final int SASL_CID = 3;
    public static final int NTLM_CID = 10;
    int[] tag_list = new int[]{0, 3, 10};
    public int choiceId;
    public byte[] simple = null;
    public SaslCredentials sasl = null;
    public int lastNTLM;

    public AuthenticationChoice() {
    }

    public AuthenticationChoice(AuthenticationChoice arg) {
        this.choiceId = arg.choiceId;
        switch (this.choiceId) {
            case 0: {
                this.simple = new byte[arg.simple.length];
                System.arraycopy(arg.simple, 0, this.simple, 0, arg.simple.length);
                break;
            }
            case 3: {
                this.sasl = new SaslCredentials(arg.sasl);
                break;
            }
            case 10: {
                this.simple = new byte[arg.simple.length];
                System.arraycopy(arg.simple, 0, this.simple, 0, arg.simple.length);
            }
        }
    }

    public void decode(ASN1Decoder dec) throws ASN1Exception {
        int tag = dec.decodeChoice(this.tag_list);
        if (tag == ASN1Decoder.makeTag(2, 0)) {
            dec.nextIsImplicit(tag);
            this.simple = dec.decodeOctetString();
            this.choiceId = 0;
            return;
        }
        if (tag == ASN1Decoder.makeTag(2, 3)) {
            this.sasl = new SaslCredentials();
            dec.nextIsImplicit(tag);
            this.sasl.decode(dec);
            this.choiceId = 3;
            return;
        }
        if (tag == ASN1Decoder.makeTag(2, 9)) {
            dec.nextIsImplicit(tag);
            this.simple = dec.decodeOctetString();
            this.choiceId = 10;
            this.lastNTLM = 9;
            return;
        }
        if (tag == ASN1Decoder.makeTag(2, 10)) {
            dec.nextIsImplicit(tag);
            this.simple = dec.decodeOctetString();
            this.choiceId = 10;
            this.lastNTLM = 10;
            return;
        }
        if (tag == ASN1Decoder.makeTag(2, 11)) {
            dec.nextIsImplicit(tag);
            this.simple = dec.decodeOctetString();
            this.choiceId = 10;
            this.lastNTLM = 11;
            return;
        }
    }

    public void encode(ASN1Encoder enc) throws ASN1Exception {
        enc.encodeChoice(this.choiceId, this.tag_list);
        switch (this.choiceId) {
            case 0: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 0));
                enc.encodeOctetString(this.simple);
                break;
            }
            case 3: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, 3));
                this.sasl.encode(enc);
                break;
            }
            case 10: {
                enc.nextIsImplicit(ASN1Encoder.makeTag(2, this.lastNTLM));
                enc.encodeOctetString(this.simple);
            }
        }
    }

    public void print(PrintStream os) {
        this.print(os, 0);
    }

    public void print(PrintStream os, int indent) {
        os.println("{ -- CHOICE --");
        switch (this.choiceId) {
            case 0: 
            case 10: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("simple = ");
                try {
                    new HexOutputStream(os).write(this.simple);
                }
                catch (IOException ex) {
                    os.print("( unprintable OCTET STRING value )");
                }
                break;
            }
            case 3: {
                for (int ii = 0; ii < indent + 2; ++ii) {
                    os.print(' ');
                }
                os.print("sasl = ");
                this.sasl.print(os, indent + 2);
            }
        }
        for (int ii = 0; ii < indent; ++ii) {
            os.print(' ');
        }
        os.print("}");
    }
}

