/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.implicitattr;

import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Vector;

public class Attribute {
    public static final int OPERATION_IGNORE = 1;
    public static final int OPERATION_APPEND = 2;
    public static final int OPERATION_OVERRIDE = 3;
    private int mOperation = 2;
    private String mName = "";
    private boolean mIsMandatory = false;
    private boolean mIsSingleValue = false;
    private ArrayList mOrderedSources;

    public Attribute(String aOperation, String aName, boolean aIsSingleValue, boolean aIsMandatory) {
        this.setOperation(aOperation);
        this.mIsSingleValue = aIsSingleValue;
        this.mName = aName;
        this.mOrderedSources = new ArrayList();
        this.mIsMandatory = aIsMandatory;
    }

    public Attribute(Attribute aSrc) {
        this.mOperation = aSrc.mOperation;
        this.mName = aSrc.mName;
        this.mIsMandatory = aSrc.mIsMandatory;
        this.mIsSingleValue = aSrc.mIsSingleValue;
        this.mOrderedSources = new ArrayList(aSrc.mOrderedSources);
    }

    public void setOperation(String aStr) {
        if (aStr.equalsIgnoreCase("A")) {
            this.mOperation = 2;
        } else if (aStr.equalsIgnoreCase("I")) {
            this.mOperation = 1;
        } else if (aStr.equalsIgnoreCase("O")) {
            this.mOperation = 3;
        }
    }

    public int getOperation() {
        return this.mOperation;
    }

    public boolean isSingleValue() {
        return this.mIsSingleValue;
    }

    public boolean isMandatory() {
        return this.mIsMandatory;
    }

    public void setSingleValue(boolean aIsSingleValue) {
        this.mIsSingleValue = aIsSingleValue;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public void addSource(String aSourceName) {
        this.mOrderedSources.add(aSourceName);
    }

    public ArrayList getSources() {
        return this.mOrderedSources;
    }

    public String getNextSource() {
        if (this.mOrderedSources.size() > 0) {
            String str = (String)this.mOrderedSources.get(0);
            return str;
        }
        return null;
    }

    public Vector removeSourcesAfter(String aSrcName) {
        Vector<String> v = new Vector<String>();
        int index = this.mOrderedSources.indexOf(aSrcName);
        if (this.mOrderedSources.size() > ++index && index > 0) {
            ListIterator iter = this.mOrderedSources.listIterator(index);
            while (iter.hasNext()) {
                String srcName = (String)iter.next();
                v.add(srcName);
                iter.remove();
            }
        }
        return v;
    }

    public boolean removeSource(String srcName) {
        return this.mOrderedSources.remove(srcName);
    }

    public Vector ignore() {
        Vector v = new Vector(this.mOrderedSources);
        this.mOrderedSources.clear();
        return v;
    }
}

