/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.idstore;

import com.sap.idm.vds.MVDModAttrValues;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDSearchResultEntry;
import com.sap.idm.vds.MVDSearchResults;
import com.sap.idm.vds.idstore.CommonUse;
import com.sap.idm.vds.util.InternalOperationUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class Uniquemember {
    public static String fixFilterForUniqueMember(String origUrlFilter, String sessionUser, String sessionPwd) {
        String postuq;
        String newpart;
        String preuq;
        int indexuq = origUrlFilter.indexOf("uniquemember");
        String total = "";
        do {
            preuq = origUrlFilter.substring(0, indexuq);
            postuq = origUrlFilter.substring(indexuq + "uniquemember".length());
            int indexparenteses = postuq.indexOf(")");
            String uqval = postuq.substring(1, indexparenteses).trim();
            String mskey_uqval = "";
            if (uqval.equals("*")) {
                mskey_uqval = "*";
            } else {
                MVDSearchResults res = InternalOperationUtil.search(uqval, 0, new Vector(), "(objectclass=*)", 1, 30, sessionUser, sessionPwd);
                if (res.size() == 0 || res.size() > 1) {
                    mskey_uqval = "-111";
                } else {
                    MVDSearchResultEntry ent = (MVDSearchResultEntry)res.elementAt(0);
                    mskey_uqval = ent.getFirstAttrValue("mskey");
                }
            }
            postuq = postuq.substring(indexparenteses + 1);
            newpart = "|(mxmember_mx_person=" + mskey_uqval + ")(mxmember_mx_group=" + mskey_uqval + "))";
        } while ((indexuq = (origUrlFilter = (total = preuq + newpart + postuq)).indexOf("uniquemember")) >= 0);
        return total;
    }

    public static void transfToUniqueMemb(MVDSearchResults res) {
        for (int i = 0; i < res.size(); ++i) {
            String entryType;
            MVDSearchResultEntry entry = (MVDSearchResultEntry)res.elementAt(i);
            HashMap attAndVals = entry.getAttrAndValues();
            if (!attAndVals.containsKey("mx_entrytype") || !(entryType = (String)((Vector)attAndVals.get("mx_entrytype")).elementAt(0)).equalsIgnoreCase("MX_GROUP")) continue;
            Vector uniqueMemberVals = new Vector();
            Iterator it = attAndVals.keySet().iterator();
            while (it.hasNext()) {
                String attName = (String)it.next();
                if (!attName.equalsIgnoreCase("mxmember_mx_group") && !attName.equalsIgnoreCase("mxmember_mx_person")) continue;
                Vector attVals = (Vector)attAndVals.get(attName);
                uniqueMemberVals.addAll(attVals);
                it.remove();
            }
            if (uniqueMemberVals.size() <= 0) continue;
            attAndVals.put("uniquemember", uniqueMemberVals);
        }
    }

    public static boolean parseUniquememberForAdding(HashMap attrsAndValues, MVDOperationResult result, String sessionUser, String sessionPwd, String mEffectiveObjectClassAttribute) {
        Vector vals = (Vector)attrsAndValues.get("uniquemember");
        if (vals == null || vals.size() == 0) {
            return true;
        }
        HashMap<String, String> typeIdents = new HashMap<String, String>();
        typeIdents.put("MX_PERSON", "mxmember_mx_person");
        typeIdents.put("MX_GROUP", "mxmember_mx_group");
        for (int i = 0; i < vals.size(); ++i) {
            String val = (String)vals.elementAt(i);
            if (!CommonUse.isDn(val)) {
                result.setError(82, "Invalid value " + val + " for attribute uniquemember");
                return false;
            }
            MVDSearchResults res = InternalOperationUtil.search(val, 0, new Vector(), "(objectclass=*)", 1, 30, sessionUser, sessionPwd);
            if (res.size() == 0) {
                result.setError(82, "Internal error when adding new entry (no existing entry '" + val + "')");
                return false;
            }
            if (res.size() > 1) {
                result.setError(82, "Internal error when adding new entry (more than 1 entry for requested uniquemember:'" + val + "')");
                return false;
            }
            MVDSearchResultEntry ent = (MVDSearchResultEntry)res.elementAt(0);
            Vector entTypeVals = ent.getAttrValues(mEffectiveObjectClassAttribute);
            if (entTypeVals == null) {
                result.setError(82, "Internal error when adding new entry (requested uniquemember doesn't have mx_entrytype)");
                return false;
            }
            boolean bETMatched = false;
            String entTypeVal = (String)entTypeVals.elementAt(0);
            Iterator j = typeIdents.keySet().iterator();
            while (j.hasNext()) {
                String ident = (String)j.next();
                if (!entTypeVal.equalsIgnoreCase(ident)) continue;
                bETMatched = true;
                String membIdent = (String)typeIdents.get(ident);
                if (!attrsAndValues.containsKey(membIdent) || attrsAndValues.get(membIdent) == null) {
                    attrsAndValues.put(membIdent, new Vector());
                }
                ((Vector)attrsAndValues.get(membIdent)).add(val);
                break;
            }
            if (bETMatched) continue;
            result.setError(82, "Processed object:'" + val + "' is neither person nor group");
            return false;
        }
        attrsAndValues.remove("uniquemember");
        return true;
    }

    public static boolean parseUniquememberForModifying(Vector attrsAndValues, MVDOperationResult result, String sessionUser, String sessionPwd, String mEffectiveObjectClassAttribute) {
        HashMap<String, String> typeIdents = new HashMap<String, String>();
        typeIdents.put("MX_PERSON", "mxmember_mx_person");
        typeIdents.put("MX_GROUP", "mxmember_mx_group");
        for (int i = 0; i < attrsAndValues.size(); ++i) {
            MVDModAttrValues oneMod = (MVDModAttrValues)attrsAndValues.elementAt(i);
            if (!oneMod.getAttrName().equalsIgnoreCase("uniquemember")) continue;
            String val = (String)oneMod.get(0);
            if (!CommonUse.isDn(val)) {
                result.setError(82, "Invalid value for: uniquemember");
                return false;
            }
            MVDSearchResults res = InternalOperationUtil.search(val, 0, new Vector(), "(objectclass=*)", 1, 30, sessionUser, sessionPwd);
            if (res.size() == 0) {
                result.setError(82, "Internal error when modifying entry (no existing entry '" + val + "')");
                return false;
            }
            if (res.size() > 1) {
                result.setError(82, "Internal error when modifying entry (more than 1 entry for requested uniquemember:'" + val + "')");
                return false;
            }
            MVDSearchResultEntry ent = (MVDSearchResultEntry)res.elementAt(0);
            Vector entTypeVals = ent.getAttrValues(mEffectiveObjectClassAttribute);
            if (entTypeVals == null) {
                result.setError(82, "Internal error when modifying entry (requested uniquemember dosn't have mx_entrytype)");
                return false;
            }
            String entTypeVal = (String)entTypeVals.elementAt(0);
            Iterator j = typeIdents.keySet().iterator();
            while (j.hasNext()) {
                String ident = (String)j.next();
                if (!entTypeVal.equalsIgnoreCase(ident)) continue;
                String membIdent = (String)typeIdents.get(ident);
                oneMod.setAttrName(membIdent);
                break;
            }
            if (!oneMod.getAttrName().equalsIgnoreCase("uniquemember")) continue;
            result.setError(82, "Processed object:'" + val + "' is neither person nor group");
            return false;
        }
        return true;
    }
}

