/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.filter;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.filter.MVDFilter;
import com.sap.idm.vds.filter.MVDFilterComplex;
import com.sap.idm.vds.filter.MVDFilterSimple;
import com.sap.idm.vds.filter.MVDFilterSubstring;
import java.util.Stack;
import java.util.Vector;

public class MVDFilterUtilities {
    private static MVDFilterSimple processSimpleFilter(String s) {
        MVDFilterSimple sfil = null;
        int aLessEqual = s.indexOf("<=");
        if (aLessEqual > 0) {
            String aAttributeName = s.substring(0, aLessEqual);
            String aAttributeValue = s.substring(aLessEqual + 2);
            sfil = new MVDFilterSimple(aAttributeName, 1, aAttributeValue);
        } else {
            int aGtEqual = s.indexOf(">=");
            if (aGtEqual > 0) {
                String aAttributeName = s.substring(0, aGtEqual);
                String aAttributeValue = s.substring(aGtEqual + 2);
                sfil = new MVDFilterSimple(aAttributeName, 2, aAttributeValue);
            } else {
                int atApxEqual = s.indexOf("~=");
                if (atApxEqual > 0) {
                    String aAttributeName = s.substring(0, atApxEqual);
                    String aAttributeValue = s.substring(atApxEqual + 2);
                    sfil = new MVDFilterSimple(aAttributeName, 8, aAttributeValue);
                } else {
                    int aEqual = s.indexOf("=");
                    if (aEqual > 0) {
                        String aAttributeName = s.substring(0, aEqual);
                        String aAttributeValue = s.substring(aEqual + 1);
                        if (aAttributeValue.equals("*")) {
                            sfil = new MVDFilterSimple(aAttributeName, 3, aAttributeValue);
                        } else if (aAttributeValue.indexOf("*") < 0) {
                            sfil = new MVDFilterSimple(aAttributeName, 0, aAttributeValue);
                        } else {
                            sfil = new MVDFilterSimple(aAttributeName, 4, aAttributeValue);
                            Vector vsub = MVDFilterUtilities.constructSubfilters(aAttributeValue);
                            sfil.setSubstrings(vsub);
                        }
                    }
                }
            }
        }
        return sfil;
    }

    private static Vector constructSubfilters(String aAttributeValue) {
        Vector<MVDFilterSubstring> vSub = new Vector<MVDFilterSubstring>();
        MVDFilterSubstring ssub = null;
        Vector helpVec = MVDUtil.splitString(aAttributeValue, "*");
        if (helpVec.size() == 2) {
            if (aAttributeValue.endsWith("*")) {
                ssub = new MVDFilterSubstring(5, aAttributeValue.substring(0, aAttributeValue.length() - 1));
            } else if (aAttributeValue.startsWith("*")) {
                ssub = new MVDFilterSubstring(6, aAttributeValue.substring(1));
            }
            vSub.add(ssub);
        } else if (((String)helpVec.elementAt(0)).length() == 0) {
            for (int x = 1; x < helpVec.size() - 1; ++x) {
                ssub = new MVDFilterSubstring(7, (String)helpVec.elementAt(x));
                vSub.add(ssub);
            }
            ssub = new MVDFilterSubstring(6, (String)helpVec.elementAt(helpVec.size() - 1));
            vSub.add(ssub);
        } else {
            ssub = new MVDFilterSubstring(5, (String)helpVec.elementAt(0));
            vSub.add(ssub);
            for (int x = 1; x < helpVec.size() - 1; ++x) {
                ssub = new MVDFilterSubstring(7, (String)helpVec.elementAt(x));
                vSub.add(ssub);
            }
        }
        return vSub;
    }

    private static Vector findFilterParts(String s) {
        Stack<String> stck = new Stack<String>();
        Vector<String> fParts = new Vector<String>();
        int len = s.length();
        for (int x = 0; x < len; ++x) {
            if (s.charAt(x) == '(') {
                stck.push("" + x);
                continue;
            }
            if (s.charAt(x) != ')') continue;
            int startofpart = Integer.parseInt((String)stck.pop());
            if (!stck.empty()) continue;
            fParts.add(s.substring(startofpart, x + 1));
        }
        return fParts;
    }

    public static MVDFilter constructFilter(String urlFilter) {
        Vector<MVDFilter> foundFilters = new Vector<MVDFilter>();
        String partialFilterStr = null;
        MVDFilter partialFilter = null;
        char c = urlFilter.charAt(1);
        if (c == '&' || c == '|' || c == '!') {
            Vector filterParts = MVDFilterUtilities.findFilterParts(urlFilter.substring(2, urlFilter.length() - 1));
            for (int i = 0; i < filterParts.size(); ++i) {
                partialFilterStr = (String)filterParts.elementAt(i);
                partialFilter = MVDFilterUtilities.constructFilter(partialFilterStr);
                if (partialFilter.getFilterOpType() == 1000) {
                    return partialFilter;
                }
                foundFilters.add(partialFilter);
            }
            if ((c == '&' || c == '|') && filterParts.size() < 2) {
                return new MVDFilterSimple("invalid", 1000, "invalid");
            }
            if (c == '&') {
                return new MVDFilterComplex(11, foundFilters);
            }
            if (c == '|') {
                return new MVDFilterComplex(12, foundFilters);
            }
            if (c == '!') {
                return new MVDFilterComplex(13, foundFilters);
            }
            return new MVDFilterSimple("invalid", 1000, "invalid");
        }
        int bStart = 0;
        int bEnd = 0;
        if (urlFilter.startsWith("(")) {
            bStart = 1;
        }
        if (urlFilter.endsWith(")")) {
            bEnd = 1;
        }
        if (bStart + bEnd == 2) {
            urlFilter = urlFilter.substring(1, urlFilter.length() - 1);
        } else if (bStart + bEnd == 1) {
            System.out.println("Invalid filter");
            return new MVDFilterSimple("invalid", 0, "invalid");
        }
        MVDFilterSimple sfil = MVDFilterUtilities.processSimpleFilter(urlFilter);
        return new MVDFilterSimple(sfil);
    }
}

