/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.event;

import com.sap.idm.vds.event.Heapable;
import java.util.Vector;

public class Heap {
    private Vector mData = new Vector();

    public long getTopValue() {
        if (this.size() > 0) {
            return ((Heapable)this.mData.elementAt(0)).getValue();
        }
        return -1L;
    }

    public Object removeTop() {
        Heapable o = (Heapable)this.mData.remove(0);
        if (this.size() > 1) {
            Object last = this.mData.remove(this.mData.size() - 1);
            this.mData.insertElementAt(last, 0);
            this.heapify(0);
        }
        return o.getPayload();
    }

    public void insert(long weight, Object o) {
        Heapable h = new Heapable(weight, o);
        this.mData.insertElementAt(h, 0);
        this.heapify(0);
    }

    public int size() {
        return this.mData.size();
    }

    private void heapify(int i) {
        int l = this.getLeft(i);
        int r = this.getRight(i);
        int smallest = l < this.size() && ((Heapable)this.mData.elementAt(l)).lessThan((Heapable)this.mData.elementAt(i)) ? l : i;
        if (r < this.size() && ((Heapable)this.mData.elementAt(r)).lessThan((Heapable)this.mData.elementAt(smallest))) {
            smallest = r;
        }
        if (smallest != i) {
            this.swap(i, smallest);
            this.heapify(smallest);
        }
    }

    private int getLeft(int i) {
        return (i + 1 << 1) - 1;
    }

    private int getRight(int i) {
        return i + 1 << 1;
    }

    private int getParent(int i) {
        return (i + 1 >> 1) - 1;
    }

    private void swap(int i, int j) {
        Object temp = this.mData.elementAt(j);
        this.mData.setElementAt(this.mData.elementAt(i), j);
        this.mData.setElementAt(temp, i);
    }
}

