/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.event;

import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.event.EventActionCallable;
import com.sap.idm.vds.event.EventActionConfig;
import com.sap.idm.vds.event.ICallable;
import com.sap.idm.vds.message.MxAdd;
import com.sap.idm.vds.message.MxDelete;
import com.sap.idm.vds.message.MxModify;
import com.sap.idm.vds.message.MxRequest;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public abstract class EventTriggerConfig {
    private String mName;
    private int mID;
    private boolean mEnabled;
    private Vector mEventActions;
    private HashSet mValidUserGroups = new HashSet();
    private int mOperation = 0;
    private int mOperationResult;
    private static final int ADD = 1;
    private static final int MOD = 2;
    private static final int DEL = 4;
    private static final int SEARCH = 16;
    private static final int OK_RESULT = 1;
    private static final int NOK_RESULT = 2;

    public EventTriggerConfig(String aUserGroups, String aOperations, String aResultcodes) {
        String element;
        Iterator iter;
        Vector v;
        if (aUserGroups.length() > 0) {
            v = MVDUtil.splitString(aUserGroups, ',');
            iter = v.iterator();
            while (iter.hasNext()) {
                element = (String)iter.next();
                Integer i = new Integer(element);
                this.mValidUserGroups.add(i);
            }
        }
        if (aOperations.length() > 0) {
            v = MVDUtil.splitString(aOperations, ',');
            iter = v.iterator();
            while (iter.hasNext()) {
                element = (String)iter.next();
                if (element.equalsIgnoreCase("ADD")) {
                    this.mOperation |= 1;
                    continue;
                }
                if (element.equalsIgnoreCase("MODIFY")) {
                    this.mOperation |= 2;
                    continue;
                }
                if (!element.equalsIgnoreCase("DELETE")) continue;
                this.mOperation |= 4;
            }
        }
        if (aResultcodes.equalsIgnoreCase("OK")) {
            this.mOperationResult = 1;
        } else if (aResultcodes.equalsIgnoreCase("NOTOK")) {
            this.mOperationResult = 2;
        } else if (aResultcodes.equalsIgnoreCase("BOTH")) {
            this.mOperationResult = 3;
        }
    }

    public final boolean doEvaluation(int aUsergroup, MxRequest aOrgRequest, boolean aIsOKResult) {
        int optype = 0;
        if (aOrgRequest instanceof MxAdd) {
            optype = 1;
        } else if (aOrgRequest instanceof MxModify) {
            optype = 2;
        } else if (aOrgRequest instanceof MxDelete) {
            optype = 4;
        }
        int resultcode = aIsOKResult ? 1 : 2;
        return (resultcode & this.mOperationResult) > 0 && (optype & this.mOperation) > 0 && (this.mValidUserGroups.size() == 0 || this.mValidUserGroups.contains(new Integer(aUsergroup)));
    }

    public final ICallable[] getExecutable(MxRequest aOperation, MVDOperationResult aResult) {
        if (this.mEventActions == null) {
            return new ICallable[0];
        }
        Vector<EventActionCallable> v = new Vector<EventActionCallable>();
        for (int i = 0; i < this.mEventActions.size(); ++i) {
            EventActionCallable tmp = ((EventActionConfig)this.mEventActions.elementAt(i)).getExecutable(aOperation, aResult.isOK());
            if (tmp == null) continue;
            v.add(tmp);
        }
        ICallable[] execs = new ICallable[v.size()];
        v.toArray(execs);
        return execs;
    }

    public final void addEventAction(EventActionConfig aEventAction) throws MVDConfigException {
        if (this.mEventActions == null) {
            this.mEventActions = new Vector();
        }
        this.mEventActions.add(aEventAction);
        if (this.mEnabled) {
            aEventAction.prepareClass();
        }
    }

    public final String getName() {
        return this.mName;
    }

    public final int getID() {
        return this.mID;
    }

    public final void setName(String aName) {
        this.mName = aName;
    }

    public final void setID(int aID) {
        this.mID = aID;
    }

    public abstract boolean evaluate(MxRequest var1);

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public void setEnabled(boolean aEnabled) {
        this.mEnabled = aEnabled;
    }
}

