/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.event;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOperationResult;
import com.sap.idm.vds.event.ActionThread;
import com.sap.idm.vds.event.EventTriggerConfig;
import com.sap.idm.vds.event.ICallable;
import com.sap.idm.vds.message.MxRequest;
import java.util.Vector;

public class EventHandler {
    public static final int DATASOURCE = 0;
    public static final int NODE = 1;
    public static final int USERGROUP = 2;
    public static final int GLOBAL = 3;
    private static int mMaxEventThreads;
    private static Vector mCurrentThreads;
    private static ThreadGroup mEventHandleGroup;
    private static Vector mTasks;

    public static synchronized void setMaxEventThreads(int aNumber) {
        mMaxEventThreads = aNumber;
        if (mCurrentThreads == null) {
            mCurrentThreads = new Vector();
        }
        if (mCurrentThreads.size() > mMaxEventThreads) {
            while (mCurrentThreads.size() > mMaxEventThreads) {
                ActionThread worker = (ActionThread)mCurrentThreads.remove(0);
                worker.stopWorking();
            }
        } else {
            while (mCurrentThreads.size() < mMaxEventThreads) {
                ActionThread worker = new ActionThread(mEventHandleGroup, mTasks);
                mCurrentThreads.add(worker);
                worker.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addAction(ICallable[] aTask) {
        Vector vector = mTasks;
        synchronized (vector) {
            for (int i = 0; i < aTask.length; ++i) {
                ICallable callable = aTask[i];
                mTasks.add(callable);
            }
            mTasks.notify();
        }
    }

    public static int getCurrentSize() {
        return mTasks.size();
    }

    public static void evaluateTrigger(MxRequest aOperation, EventTriggerConfig aTrigger, int aCalledFrom, MVDOperationResult aResult) {
        if (aTrigger.evaluate(aOperation)) {
            ICallable[] exec = aTrigger.getExecutable(aOperation, aResult);
            MVDLogger.Log("Trigger: " + aTrigger.getName() + " evaluated true", 2);
            EventHandler.addAction(exec);
        } else {
            MVDLogger.Log("Trigger: " + aTrigger.getName() + " evaluated false", 2);
        }
    }

    public static void shutdown() {
        try {
            while (mCurrentThreads.size() > 0) {
                ActionThread t = (ActionThread)mCurrentThreads.remove(0);
                t.stopWorking();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        mEventHandleGroup = new ThreadGroup("EventHandlers");
        mTasks = new Vector();
        EventHandler.setMaxEventThreads(3);
    }
}

