/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.event;

import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.event.EventAction;
import com.sap.idm.vds.event.EventActionCallable;
import com.sap.idm.vds.message.MxRequest;
import java.util.HashMap;

public class EventActionConfig {
    private HashMap mParams;
    private String mClassName;
    private boolean mEnabledonOK = true;
    private boolean mEnabledonError = true;

    public EventActionConfig(String aClassname, HashMap aParams, boolean aEnabledOnOK, boolean aEnabledOnError) throws MVDConfigException {
        this.mParams = aParams == null ? new HashMap() : aParams;
        this.mClassName = aClassname;
        this.mEnabledonOK = aEnabledOnOK;
        this.mEnabledonError = aEnabledOnError;
    }

    public void prepareClass() throws MVDConfigException {
        Globals.AddExternalClass(this.mClassName);
    }

    public EventActionCallable getExecutable(MxRequest aOperation, boolean aIsOKResult) {
        if (aIsOKResult && this.mEnabledonOK || !aIsOKResult && this.mEnabledonError) {
            return this.instantiateClass(aOperation);
        }
        return null;
    }

    private EventActionCallable instantiateClass(MxRequest aOperation) {
        try {
            HashMap params = new HashMap(this.mParams);
            Class classss = (Class)Globals.GetExternalClass(this.mClassName);
            EventAction evact = (EventAction)classss.newInstance();
            EventActionCallable callable = new EventActionCallable(evact, params, aOperation);
            return callable;
        }
        catch (Exception e) {
            MVDLogger.Log("Unable to instantiate class: " + this.mClassName, 7, e);
            return null;
        }
        catch (VirtualMachineError vte) {
            Globals.blownAwayByThrowable(vte);
            return null;
        }
        catch (Throwable e) {
            MVDLogger.Log("Unable to instantiate class: " + this.mClassName, 7, e);
            return null;
        }
    }
}

