/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDTopMultiServerGroup;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDTopMultiServerGroupList {
    private static Hashtable allTopMultiServerGroups = new Hashtable();
    private static Hashtable newTopMultiServerGroups;

    public static void put(String s, MVDTopMultiServerGroup o) throws MVDConfigException {
        if (allTopMultiServerGroups.put(o.getName(), o) != null) {
            throw new MVDConfigException("TopMultiServerGroup config: Identical hash " + o.getName());
        }
    }

    public static MVDTopMultiServerGroup getTopMultiServerGroupByID(int TopMultiServerGroupID) {
        return (MVDTopMultiServerGroup)allTopMultiServerGroups.get(new Integer(TopMultiServerGroupID));
    }

    public static MVDTopMultiServerGroup getTopMultiServerGroupByName(String aName) {
        return (MVDTopMultiServerGroup)allTopMultiServerGroups.get(aName);
    }

    public static void reloadConfig(Node TopMultiServerGroupTopNode) throws MVDConfigException {
        MVDTopMultiServerGroupList.readAllTopMultiServerGroups(TopMultiServerGroupTopNode);
    }

    public static void applyChanges() {
        allTopMultiServerGroups = newTopMultiServerGroups;
    }

    public static void loadConfig(Node TopMultiServerGroupTopNode) throws MVDConfigException {
        MVDTopMultiServerGroupList.readAllTopMultiServerGroups(TopMultiServerGroupTopNode);
        MVDTopMultiServerGroupList.applyChanges();
    }

    private static void readAllTopMultiServerGroups(Node TopMultiServerGroupTopNode) throws MVDConfigException {
        newTopMultiServerGroups = new Hashtable();
        NodeList nodeList = TopMultiServerGroupTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDTopMultiServerGroup aTopMultiServerGroup = new MVDTopMultiServerGroup();
            if (!MVDTopMultiServerGroupList.fillTopMultiServerGroupNode(aTopMultiServerGroup, nodeList.item(i))) continue;
            if (newTopMultiServerGroups.put(new Integer(aTopMultiServerGroup.getID()), aTopMultiServerGroup) != null) {
                throw new MVDConfigException("TopMultiServerGroup config: Identical hash " + aTopMultiServerGroup.getID());
            }
            if (newTopMultiServerGroups.put(aTopMultiServerGroup.getName(), aTopMultiServerGroup) == null) continue;
            throw new MVDConfigException("TopMultiServerGroup config: Identical hash " + aTopMultiServerGroup.getName());
        }
    }

    private static boolean fillTopMultiServerGroupNode(MVDTopMultiServerGroup TopMultiServerGroup, Node TopMultiServerGroupRecordNode) throws MVDConfigException {
        if (!TopMultiServerGroupRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = TopMultiServerGroupRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("RetryTime")) {
                    TopMultiServerGroup.setRetryTime(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Name")) {
                    TopMultiServerGroup.setName(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ID")) {
                    TopMultiServerGroup.setID(Integer.parseInt(node.getFirstChild().getNodeValue()));
                    continue;
                }
                if (!nodeStr.equalsIgnoreCase("Servers")) continue;
                TopMultiServerGroup.setMultiServerGroupString(node.getFirstChild().getNodeValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("TopMultiServerGroup Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("TopMultiServerGroup Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }
}

