/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDTopMultiServerGroupList;
import java.util.Vector;

public class MVDTopMultiServerGroup {
    protected final String[] ldapkeys = new String[]{"DS_SERVER", "DS_PORT", "DS_USER", "DS_PASSWORD"};
    protected final String[] databasekeys = new String[]{"DS_DATABASE", "DS_SCOPE"};
    protected final String[] dsmlv2keys = new String[]{"DS_URL", "DS_USER", "DS_SCHEMA"};
    protected int mID = -1122;
    protected String mName = "";
    protected long mRetryTime = 300000L;
    protected String mMultiServerGroupString = "";
    protected Vector mMultiServerGroups = new Vector();
    private int mMultipleServerType = -1;

    public MVDTopMultiServerGroup() {
    }

    public MVDTopMultiServerGroup(String aMultiServerDefinition) throws MVDConfigException {
        Vector defvector = MVDUtil.splitString(aMultiServerDefinition, "!");
        String definitionpart = (String)defvector.elementAt(0);
        String retrytimepart = "300";
        if (defvector.size() > 1) {
            retrytimepart = (String)defvector.elementAt(1);
        }
        this.mName = definitionpart.toLowerCase() + "!" + retrytimepart;
        this.setMultiServerGroupString(definitionpart);
        if (defvector.size() > 1) {
            this.mRetryTime = Integer.parseInt(retrytimepart) * 1000;
        }
        try {
            MVDTopMultiServerGroupList.put(this.mName, this);
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public void setMultipleServerType(int i) {
        if (this.mMultipleServerType != -1) {
            MVDLogger.Log("This multi user group is already used !", 7);
            return;
        }
        this.mMultipleServerType = i;
    }

    public int getMultipleServerType() {
        return this.mMultipleServerType;
    }

    public int getID() {
        return this.mID;
    }

    public String getName() {
        return this.mName;
    }

    public long getRetryTime() {
        return this.mRetryTime;
    }

    public String getMultiServerGroupString() {
        return this.mMultiServerGroupString;
    }

    public Vector getMultiServerGroups() {
        return this.mMultiServerGroups;
    }

    public void setID(int id) {
        this.mID = id;
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public void setRetryTime(String aRetry) {
        this.mRetryTime = Integer.parseInt(aRetry) * 1000;
    }

    public void setMultiServerGroupString(String aMultiServerGroupString) {
        this.mMultiServerGroupString = aMultiServerGroupString;
        this.setMultiServerGroups();
    }

    private void setMultiServerGroups() {
        Vector MultiServerGrouplist = MVDUtil.splitString(this.mMultiServerGroupString, ";");
        for (int xi = 0; xi < MultiServerGrouplist.size(); ++xi) {
            String MultiServerGroupConfig = (String)MultiServerGrouplist.elementAt(xi);
            Vector MultiServerGroup = MVDUtil.splitString(MultiServerGroupConfig, ":");
            this.mMultiServerGroups.add(MultiServerGroup);
        }
    }
}

