/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDHashMap;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDTopMultiServerGroup;
import com.sap.idm.vds.config.MVDTopMultiServerGroupAbstract;
import java.util.Vector;

public class MVDTopFailover
extends MVDTopMultiServerGroupAbstract {
    private boolean mFailoverErrorDetected = false;
    private long mFailoverErrorTime;
    private int mFailoverIndex = -1;

    public boolean isFailoverErrorDetected() {
        return this.mFailoverErrorDetected;
    }

    public void setFailoverErrorDetected(boolean b) {
        this.mFailoverErrorDetected = b;
    }

    public MVDTopFailover(MVDTopMultiServerGroup aParent) {
        this.mParent = aParent;
    }

    public void setIndex() {
        if (!this.mFailoverErrorDetected) {
            this.mFailoverIndex = -1;
            return;
        }
        if (System.currentTimeMillis() - this.mFailoverErrorTime > this.mParent.getRetryTime()) {
            MVDLogger.Log("Retry time expired ", 1);
            this.mFailoverErrorTime = 0L;
            this.mFailoverErrorDetected = false;
            this.mFailoverIndex = -1;
            MVDLogger.Log("Failover index set to -1 (master) ", 1);
            return;
        }
        MVDLogger.Log("Retry time didn't expired yet ", 1);
    }

    private void incFailoverIndex() {
        ++this.mFailoverIndex;
        if (this.mFailoverIndex > this.mParent.getMultiServerGroups().size() - 1) {
            this.mFailoverIndex = 999;
        }
        MVDLogger.Log("Failover index set to " + this.mFailoverIndex, 2);
    }

    public MVDHashMap getMultiServerParams(String dstype, MVDHashMap param) {
        this.setIndex();
        if (this.mFailoverIndex == -1) {
            MVDLogger.Log("Selected multi server index: -1 (master)", 2);
            return param;
        }
        if (this.mFailoverIndex == 999) {
            MVDLogger.Log("Selected multi server index: 999 (repeat on master)", 2);
            return param;
        }
        MVDLogger.Log("Selected multi server index " + this.mFailoverIndex, 2);
        Vector selectedDS = (Vector)this.mParent.getMultiServerGroups().elementAt(this.mFailoverIndex);
        this.fillParams(param, dstype, selectedDS);
        return param;
    }

    /*
     * Enabled aggressive block sorting
     */
    public long setNextDS(MVDDataSource ds, boolean bDataSourceIsUnavailable) {
        if (!bDataSourceIsUnavailable) {
            MVDLogger.Log("Last selected data source was OK ... ", 1);
            return 0L;
        }
        MVDLogger.Log("Data source is unavailable ", 1);
        if (!this.mFailoverErrorDetected) {
            MVDLogger.Log("Previos op. executed on the master data source", 1);
            this.mFailoverErrorTime = System.currentTimeMillis();
            this.mFailoverErrorDetected = true;
            this.mFailoverIndex = 0;
            MVDLogger.Log("Flag it as unvailable - repeat operation ", 1);
            return -999L;
        }
        MVDLogger.Log("Previos op. executed on the ds from failover list: " + this.mFailoverIndex, 1);
        this.incFailoverIndex();
        if (this.mFailoverIndex == 999) {
            MVDLogger.Log("There are no more fail over data sources ", 1);
            return 0L;
        }
        MVDLogger.Log("Repeat operation ", 1);
        return -999L;
    }
}

