/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDSnmpSettings;
import com.sap.idm.vds.config.MVDConfigException;
import java.net.InetAddress;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDSnmpList {
    private static Hashtable allSnmp = null;
    private static Hashtable newSnmp = new Hashtable();

    public static void applyChanges() {
        allSnmp = newSnmp;
        newSnmp = new Hashtable();
    }

    public static void reloadConfig(Node node) throws MVDConfigException {
        MVDSnmpList.readSnmp(node);
    }

    public static void applyReload() {
        MVDSnmpList.applyChanges();
    }

    public static void loadConfig(Node node) throws MVDConfigException {
        MVDSnmpList.readSnmp(node);
        MVDSnmpList.applyChanges();
    }

    private static void readSnmp(Node statTopNode) throws MVDConfigException {
        MVDSnmpList.FillSnmp(statTopNode);
    }

    private static void FillSnmp(Node proxyRecordNode) throws MVDConfigException {
        block10: {
            try {
                NodeList nodeList = proxyRecordNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    int intVal;
                    Node node = nodeList.item(i);
                    if (!node.hasChildNodes()) continue;
                    String nodeStr = node.getNodeName();
                    if (nodeStr.equalsIgnoreCase("EnableSnmpTraps")) {
                        boolean boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                        MVDSnmpSettings.SetEnableSnmpTraps(boolVal);
                        continue;
                    }
                    if (nodeStr.equalsIgnoreCase("SnmpServer")) {
                        String strVal = node.getFirstChild().getNodeValue();
                        MVDSnmpSettings.SetSnmpServer(strVal);
                        continue;
                    }
                    if (nodeStr.equalsIgnoreCase("SnmpPort")) {
                        intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                        MVDSnmpSettings.SetSnmpPort(intVal);
                        continue;
                    }
                    if (nodeStr.equalsIgnoreCase("SnmpTrapLevel")) {
                        intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                        MVDSnmpSettings.SetSnmpTrapLevel(intVal);
                        continue;
                    }
                    throw new MVDConfigException("Configuration error: Wrong node type in Snmp config: " + nodeStr);
                }
                if (!MVDSnmpSettings.EnableSnmpTraps()) break block10;
                try {
                    InetAddress a = InetAddress.getByName(MVDSnmpSettings.SnmpServer());
                }
                catch (Exception e) {
                    throw new MVDConfigException("SNMP Configuration Error: Could not locate " + MVDSnmpSettings.SnmpServer());
                }
            }
            catch (NumberFormatException nfe) {
                throw new MVDConfigException("Snmp Configuration error: Expected int but got String: " + nfe.getMessage());
            }
            catch (DOMException de) {
                throw new MVDConfigException("Snmp Configuration error: Cannot get node value: " + de.getMessage());
            }
        }
    }
}

