/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDRule;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDRulesList {
    private static Hashtable allRules = new Hashtable();
    private static Hashtable newRules;
    private static MVDRule mSuperRule;

    public static MVDRule getSuperRule() {
        return mSuperRule;
    }

    public static void createSuperRule() {
        mSuperRule = new MVDRule();
        mSuperRule.setIsAllowed(true);
        mSuperRule.setOperations("MODIFY,SEARCH,ADD,DELETE,COMPARE");
        mSuperRule.setOverrideLimits(false);
        mSuperRule.setDoReturnAttr(true);
        mSuperRule.setAddAttributes("all");
        mSuperRule.setModifyAttributes("all");
        mSuperRule.setSearchAttributes("all");
        mSuperRule.setID(Integer.MAX_VALUE);
    }

    public static MVDRule getRuleByID(int ruleID) {
        return (MVDRule)allRules.get(new Integer(ruleID));
    }

    public static void reloadConfig(Node ruleTopNode) throws MVDConfigException {
        MVDRulesList.readAllRules(ruleTopNode);
    }

    public static void applyChanges() {
        allRules = newRules;
    }

    public static void loadConfig(Node ruleTopNode) throws MVDConfigException {
        MVDRulesList.createSuperRule();
        MVDRulesList.readAllRules(ruleTopNode);
        MVDRulesList.applyChanges();
    }

    private static void readAllRules(Node ruleTopNode) throws MVDConfigException {
        newRules = new Hashtable();
        NodeList nodeList = ruleTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDRule rule = new MVDRule();
            if (!MVDRulesList.fillRuleNode(rule, nodeList.item(i)) || newRules.put(new Integer(rule.ID()), rule) == null) continue;
            throw new MVDConfigException("Rule config: Identical hash " + rule.ID());
        }
    }

    private static boolean fillRuleNode(MVDRule rule, Node ruleRecordNode) throws MVDConfigException {
        if (!ruleRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = ruleRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("Name") || nodeStr.equalsIgnoreCase("DisplayName")) {
                    rule.setName(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ID")) {
                    rule.setID(Integer.parseInt(node.getFirstChild().getNodeValue()));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Enabled") || nodeStr.equalsIgnoreCase("Allowed")) {
                    if (!node.getFirstChild().getNodeValue().equalsIgnoreCase("true")) {
                        MVDLogger.Log("Rule config: Warning! - Unused rule " + rule.Name(), 6);
                    }
                    rule.setIsAllowed(true);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SearchAttributes")) {
                    rule.setSearchAttributes(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ModifyAttributes")) {
                    rule.setModifyAttributes(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AddAttributes")) {
                    rule.setAddAttributes(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AllowedOperations") || nodeStr.equalsIgnoreCase("Operations")) {
                    rule.setOperations(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoReturnAttr")) {
                    rule.setDoReturnAttr(node.getFirstChild().getNodeValue().equalsIgnoreCase("true"));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("OverrideLimits")) {
                    rule.setOverrideLimits(node.getFirstChild().getNodeValue().equalsIgnoreCase("true"));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("TimeLimit")) {
                    rule.setTimeLimit(Integer.parseInt(node.getFirstChild().getNodeValue()));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SizeLimit")) {
                    rule.setSizeLimit(Integer.parseInt(node.getFirstChild().getNodeValue()));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("MaxNoOp") || nodeStr.equalsIgnoreCase("DoModifyAttr") || nodeStr.equalsIgnoreCase("DoAddAttr") || nodeStr.equalsIgnoreCase("ShortName") || nodeStr.equalsIgnoreCase("Description")) continue;
                throw new MVDConfigException("Configuration error: Wrong node type in Rule config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Rule Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Rule Configuration error: Cannot get node value: " + de.getMessage());
        }
        if (rule.IsAllowed() && rule.DoReturnAttr() && rule.SearchAttributes().size() == 0) {
            throw new MVDConfigException("Rule Configuration error: SearchAttributes is empty for rule: " + rule.Name());
        }
        return true;
    }
}

