/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.Globals;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.event.EventHandler;
import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import com.sap.idm.vds.util.ConfigUtil;
import java.util.HashMap;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDProxyLoggerDebitList {
    private static boolean checking = false;
    private static String mStartUpLogFileName = null;
    private static String mStartUpTrafficLogFileName = null;
    private static String mPort = "389";

    public static String getPort() {
        return mPort;
    }

    public static String getStartUpLogFileName() {
        return mStartUpLogFileName;
    }

    public static String getStartUpTrafficLogFileName() {
        return mStartUpTrafficLogFileName;
    }

    public static void checkConfig(Node proxyTopNode) throws MVDConfigException {
        checking = true;
        MVDProxyLoggerDebitList.readProxy(proxyTopNode, false);
    }

    public static void reloadConfig(Node proxyTopNode) throws MVDConfigException {
        checking = false;
        MVDProxyLoggerDebitList.readProxy(proxyTopNode, false);
    }

    public static void loadStartUpParameters(Node proxyTopNode) throws MVDConfigException {
        MVDProxyLoggerDebitList.readStartUpParameters(proxyTopNode);
    }

    private static void readStartUpParameters(Node proxyTopNode) throws MVDConfigException {
        NodeList nodeList = proxyTopNode.getChildNodes();
        int i = 0;
        Node node = nodeList.item(0);
        while (!node.hasChildNodes()) {
            node = nodeList.item(i++);
        }
        MVDProxyLoggerDebitList.FillStartUpParameters(node);
    }

    public static void loadConfig(Node proxyTopNode, boolean bHelperMode) throws MVDConfigException {
        MVDProxyLoggerDebitList.readProxy(proxyTopNode, bHelperMode);
    }

    public static void readMVDGlobals(Node aProxyTopNode) throws MVDConfigException {
        NodeList nodeList = aProxyTopNode.getChildNodes();
        Node node = nodeList.item(0);
        int i = 0;
        try {
            while (!node.hasChildNodes()) {
                node = nodeList.item(i++);
            }
            nodeList = node.getChildNodes();
            for (i = 0; i < nodeList.getLength(); ++i) {
                String nodeStr;
                node = nodeList.item(i);
                if (!node.hasChildNodes() || !(nodeStr = node.getNodeName()).equalsIgnoreCase("MVDGlobals")) continue;
                String strVal = node.getFirstChild().getNodeValue();
                if (checking) continue;
                MVDProxy.SetMVDGlobals(strVal);
            }
        }
        catch (DOMException de) {
            throw new MVDConfigException("Proxy Configuration error: Cannot get node value: " + de.getMessage());
        }
    }

    private static void readProxy(Node proxyTopNode, boolean bHelperMode) throws MVDConfigException {
        NodeList nodeList = proxyTopNode.getChildNodes();
        int i = 0;
        Node node = nodeList.item(0);
        while (!node.hasChildNodes()) {
            node = nodeList.item(i++);
        }
        if (!bHelperMode) {
            MVDProxyLoggerDebitList.FillProxy(node);
        } else {
            MVDProxyLoggerDebitList.FillHelperProxy(node);
        }
    }

    private static void FillProxy(Node proxyRecordNode) throws MVDConfigException {
        if (!checking) {
            MVDProxy.SetPreTransOps("");
            MVDProxy.SetPostTransOps("");
        }
        Vector<String> prohibitedURLs = new Vector<String>();
        try {
            NodeList nodeList = proxyRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String val;
                boolean boolVal;
                int intVal;
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("JDBCDrivers")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    MVDProxy.SetJDBCDrivers(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("MVDGlobals")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    MVDProxy.SetMVDGlobals(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("PortNumber")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    if (checking) continue;
                    MVDProxy.SetPortNumber(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ServiceName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    MVDProxy.SetServiceName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ExecuteBindMethod") || nodeStr.equalsIgnoreCase("ExplAuth")) {
                    boolean bl = boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    if (checking) continue;
                    MVDProxy.SetExplAuth(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("BindMethodParameters")) {
                    HashMap m = ConfigUtil.readParams(node, "AUTH_", true);
                    MVDProxy.setBindMethodParameters(m);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnableTransparentAuth") || nodeStr.equalsIgnoreCase("TransparentAuth")) {
                    boolean bl = boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    if (checking) continue;
                    MVDProxy.SetTransparentAuth(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("TransparentAuthServer") || nodeStr.equalsIgnoreCase("AuthServer")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    MVDProxy.SetAuthServer(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("TransparentAuthPort") || nodeStr.equalsIgnoreCase("AuthPort")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    MVDProxy.SetAuthPort(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("CharSet")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    if (checking) continue;
                    MVDProxy.SetCharSet(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SessionMaxLifeTime")) continue;
                if (nodeStr.equalsIgnoreCase("ProhibitedOperations")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    MVDProxy.SetProhibitedOperations(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ProhibitedSearchURLs")) {
                    if (checking || node == null || !node.hasChildNodes()) continue;
                    NodeList urlNodes = node.getChildNodes();
                    for (int urlCounter = 0; urlCounter < urlNodes.getLength(); ++urlCounter) {
                        Node urlNode = urlNodes.item(urlCounter);
                        if (urlNode.getNodeType() == 3) continue;
                        prohibitedURLs.add(urlNode.getFirstChild().getNodeValue());
                    }
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AllowPartialAddOrModify") || nodeStr.equalsIgnoreCase("AllowPartialModify")) {
                    boolean bl = boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    if (checking) continue;
                    MVDProxy.SetAllowPartialModify(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("InternalAttributes") || nodeStr.equalsIgnoreCase("AllAttributes")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    MVDProxy.SetAllAttributes(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("KeepMinimumEngines") || nodeStr.equalsIgnoreCase("Engines")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    if (checking) continue;
                    MVDProxy.SetEngines(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EnforceDNRelation")) {
                    boolean bl = boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    if (checking) continue;
                    MVDProxy.SetEnforceDNRelation(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ClientVersion")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    if (checking) continue;
                    MVDProxy.SetClientVersion(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("FreeEngineDuration") || nodeStr.equalsIgnoreCase("KeepEngine")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    if (checking) continue;
                    MVDProxy.SetKeepEngine(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SessionTimeout")) {
                    intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    if (checking) continue;
                    MVDProxy.SetSessionTimeout(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("RootClass")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    MVDProxy.SetRootClass(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("RootDSEClass")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    MVDProxy.SetRootDSEClass(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("AuthenticationClass")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    MVDProxy.SetAuthenticationClass(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SystemManagementClass")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    MVDProxy.SetSystemManagementClass(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("TransClass")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    strVal = Globals.AddExternalClass(strVal);
                    MVDProxy.SetTransformationClass(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("PreProcessClass")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    strVal = Globals.AddExternalClass(strVal);
                    MVDProxy.setPreProcessClass(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("PostProcessClass")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    strVal = Globals.AddExternalClass(strVal);
                    MVDProxy.setPostProcessClass(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("PreTransOperations")) {
                    strVal = node.getFirstChild().getNodeValue();
                    MVDProxy.SetPreTransOps(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("PostTransOperations")) {
                    strVal = node.getFirstChild().getNodeValue();
                    MVDProxy.SetPostTransOps(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ProtocolTransform")) continue;
                if (nodeStr.equalsIgnoreCase("AttrClass")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (checking) continue;
                    if (strVal != null && strVal.equalsIgnoreCase("Default")) {
                        strVal = "MxAttributeFixClass";
                    }
                    strVal = Globals.AddExternalClass(strVal);
                    MVDProxy.SetAttrClass(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DoProtectUI") || nodeStr.equalsIgnoreCase("SrvProtection")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    MVDProxy.SetProtectUI(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("UIPassword") || nodeStr.equalsIgnoreCase("PwdProtection")) {
                    strVal = node.getFirstChild().getNodeValue();
                    MVDProxy.SetUIPassword(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("TestModeEnabled")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    MVDProxy.setTestModeEnabled(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("TestModeUser")) {
                    strVal = node.getFirstChild().getNodeValue();
                    MVDProxy.setTestModeUser(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("TestModePassword")) {
                    strVal = node.getFirstChild().getNodeValue();
                    MVDProxy.setTestModePassword(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("EventHandlers")) {
                    try {
                        intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                        if (intVal <= 0) continue;
                        EventHandler.setMaxEventThreads(intVal);
                    }
                    catch (NumberFormatException e) {}
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("StripAdditionalInfo")) {
                    boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    MVDProxy.setStripAdditionalInfo(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("DumpASN1")) {
                    strVal = node.getFirstChild().getNodeValue();
                    boolVal = Boolean.valueOf(strVal);
                    MVDLogger.setWriteASNFiles(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SLDRegEnabled")) {
                    strVal = node.getFirstChild().getNodeValue();
                    boolVal = Boolean.valueOf(strVal);
                    MVDProxy.setSLDRegEnabled(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SLDURL")) {
                    strVal = node.getFirstChild().getNodeValue();
                    MVDProxy.setSLDUrl(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SLDUsername")) {
                    strVal = node.getFirstChild().getNodeValue();
                    MVDProxy.setSLDUsername(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SLDPassword")) {
                    strVal = node.getFirstChild().getNodeValue();
                    MVDProxy.setSLDPassword(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ClientKeystoreID") || nodeStr.equalsIgnoreCase("ClientTrustStoreID") || nodeStr.equalsIgnoreCase("ScreenLimit") || nodeStr.equalsIgnoreCase("AvailableMemory") || nodeStr.equalsIgnoreCase("HeapSettings") || nodeStr.equalsIgnoreCase("JavaOptions") || nodeStr.equalsIgnoreCase("Description") || nodeStr.equalsIgnoreCase("WebServiceName") || nodeStr.equalsIgnoreCase("WebServicePort") || nodeStr.equalsIgnoreCase("ServiceType") || nodeStr.equalsIgnoreCase("PreOpScript") || nodeStr.equalsIgnoreCase("ClientPackageSize") || nodeStr.equalsIgnoreCase("DoPrepare") || nodeStr.equalsIgnoreCase("SessionPrepare") || nodeStr.equalsIgnoreCase("ClassDir") || nodeStr.equalsIgnoreCase("XMLFile") || nodeStr.equalsIgnoreCase("StartingPointAsOutlook")) continue;
                if (nodeStr.equalsIgnoreCase("sslClientTrustStore")) {
                    val = node.getFirstChild().getNodeValue();
                    if (val == null || val.length() <= 0) continue;
                    System.setProperty("javax.net.ssl.trustStore", val);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("sslClientTrustStorePassword")) {
                    val = node.getFirstChild().getNodeValue();
                    if ((val = MVDMic_Util.dcString((String)val)) == null || val.length() <= 0) continue;
                    System.setProperty("javax.net.ssl.trustStorePassword", val);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("sslClientKeyStore")) {
                    val = node.getFirstChild().getNodeValue();
                    if (val == null || val.length() <= 0) continue;
                    System.setProperty("javax.net.ssl.keyStore", val);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("sslClientKeyStorePassword")) {
                    val = node.getFirstChild().getNodeValue();
                    if ((val = MVDMic_Util.dcString((String)val)) == null || val.length() <= 0) continue;
                    System.setProperty("javax.net.ssl.keyStorePassword", val);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Logger")) continue;
                throw new MVDConfigException("Configuration error: Wrong node type in Proxy config: " + nodeStr);
            }
            MVDProxy.setProhibitedSearchURLs(prohibitedURLs);
            if (!checking) {
                MVDProxy.checkRootDSEClass();
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Proxy Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Proxy Configuration error: Cannot get node value: " + de.getMessage());
        }
    }

    private static void FillStartUpParameters(Node proxyRecordNode) throws MVDConfigException {
        try {
            NodeList nodeList = proxyRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String strVal;
                String nodeStr;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes() || !(nodeStr = node.getNodeName()).equalsIgnoreCase("PortNumber")) continue;
                mPort = strVal = node.getFirstChild().getNodeValue();
            }
        }
        catch (DOMException de) {
            throw new MVDConfigException("Proxy Configuration error: Cannot get node value: " + de.getMessage());
        }
        catch (Exception e) {
            throw new MVDConfigException("Proxy Configuration error:  " + e.getMessage());
        }
    }

    private static void FillHelperProxy(Node proxyRecordNode) throws MVDConfigException {
        try {
            NodeList nodeList = proxyRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String nodeStr;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes() || (nodeStr = node.getNodeName()).equalsIgnoreCase("JDBCDrivers") || !nodeStr.equalsIgnoreCase("MVDGlobals")) continue;
                String strVal = node.getFirstChild().getNodeValue();
                if (checking) continue;
                MVDProxy.SetMVDGlobals(strVal);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Proxy Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Proxy Configuration error: Cannot get node value: " + de.getMessage());
        }
    }
}

