/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDInternalContext;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOrderedHashMap;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDProvisionExecElem;
import com.sap.idm.vds.config.MVDProvisioningUpdateElem;
import com.sap.idm.vds.config.MVDProvisioningUtil;
import com.sap.idm.vds.config.MVDSource;
import com.sap.idm.vds.config.MVDSourceList;
import com.sap.idm.vds.message.MxResponse;
import com.sap.idm.vds.operations.MVDCommonAMDOperation;
import com.sap.idm.vds.util.MVDOpUtilities;
import java.util.Vector;

public class MVDProvisioningGroup {
    private String mID = "";
    private String mName = "";
    private boolean mEnabled = false;
    private boolean mRollbackAll = true;
    private MVDSource mMaster;
    private Vector mAddUpdateElements = new Vector();
    private Vector mModifyUpdateElements = new Vector();
    private Vector mDeleteUpdateElements = new Vector();
    private Vector mUpdateElements = null;
    private String mUniqueName;

    public String ID() {
        return this.mID;
    }

    public boolean IsAllowed() {
        return this.mEnabled;
    }

    public boolean RollbackAll() {
        return this.mRollbackAll;
    }

    public Vector getAddUpdateElements() {
        return this.mAddUpdateElements;
    }

    public Vector getModifyUpdateElements() {
        return this.mModifyUpdateElements;
    }

    public Vector getDeleteUpdateElements() {
        return this.mDeleteUpdateElements;
    }

    public Vector getUpdateElements() {
        return this.mUpdateElements;
    }

    public String getUniqueName() {
        if (this.mUniqueName == null) {
            String tmp = this.mID + this.mName.replace(' ', '_');
            this.mUniqueName = tmp.length() <= 10 ? tmp : tmp.substring(0, 10);
        }
        return this.mUniqueName;
    }

    public void SetName(String s) {
        this.mName = s;
    }

    public void SetID(String s) {
        this.mID = s;
    }

    public void SetIsAllowed(boolean b) {
        this.mEnabled = b;
    }

    public void SetRollbackAll(boolean b) {
        this.mRollbackAll = b;
    }

    public void SetAddUpdateElements(Vector v) {
        this.mAddUpdateElements = v;
    }

    public void SetModifyUpdateElements(Vector v) {
        this.mModifyUpdateElements = v;
    }

    public void SetDeleteUpdateElements(Vector v) {
        this.mDeleteUpdateElements = v;
    }

    public String getName() {
        return this.mName;
    }

    public MVDSource getMaster() {
        return this.mMaster;
    }

    public void setMaster(MVDSource aSrc) {
        this.mMaster = aSrc;
    }

    public void AddUpdateElements(MVDSource s) {
        if (this.mUpdateElements == null) {
            this.mUpdateElements = new Vector();
        }
        this.mUpdateElements.add(s);
        if (s.getIsMaster()) {
            this.mMaster = s;
        }
    }

    public void SetSources(Vector vec) throws Exception {
        MVDSource locsrc = null;
        for (int i = 0; i < vec.size(); ++i) {
            MVDProvisioningUpdateElem cel = (MVDProvisioningUpdateElem)vec.elementAt(i);
            if (!cel.Enabled()) continue;
            locsrc = MVDSourceList.getSourceBySrcID(Integer.parseInt(cel.SrcID()));
            if (locsrc == null) {
                throw new MVDConfigException("Provisioning group config, Could not find group member:" + cel.SrcID());
            }
            cel.SetSource(locsrc);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process(MVDCommonAMDOperation origop) throws MVDException {
        MVDOrderedHashMap complexOperations = new MVDOrderedHashMap();
        this.mUpdateElements = origop.getAMDType().equalsIgnoreCase("DELETE") ? this.mDeleteUpdateElements : (origop.getAMDType().equalsIgnoreCase("ADD") ? this.mAddUpdateElements : this.mModifyUpdateElements);
        boolean bAtLeastOneIsProcessed = false;
        for (int t = 0; t < this.mUpdateElements.size(); ++t) {
            MVDProvisioningUpdateElem cxupElement = (MVDProvisioningUpdateElem)this.mUpdateElements.elementAt(t);
            if (!cxupElement.Enabled()) continue;
            bAtLeastOneIsProcessed = true;
            MVDSource elementSource = cxupElement.Source();
            int groupType = elementSource.getMappingType();
            String c = origop.getAcl().getQName();
            c = MVDOpUtilities.reverseDN(c);
            String virt = "";
            int x = c.indexOf(",");
            virt = x < 0 ? c : c.substring(x + 1);
            for (int i = 0; i < cxupElement.Operation().size(); ++i) {
                String reverseOperatorion;
                String theOperatorion = (String)cxupElement.Operation().elementAt(i);
                int result = MVDProvisioningUtil.constructComplexRequest(origop, cxupElement, theOperatorion, reverseOperatorion = (String)cxupElement.OnError().elementAt(i), complexOperations, virt);
                if (result != -1) continue;
                MVDLogger.Log("Provisioning: Could not create a complex member:" + theOperatorion, 3);
                throw new MVDException(-1022);
            }
        }
        if (!bAtLeastOneIsProcessed) {
            String str = "Provisioning: " + origop.getAMDType() + " operation is not allowed";
            MVDLogger.Log(str, 7);
            throw new MVDException(53, str);
        }
        int i = 0;
        while (true) {
            block12: {
                Object var16_18;
                if (i >= complexOperations.size()) {
                    return;
                }
                MVDInternalContext aCont = null;
                try {
                    try {
                        aCont = new MVDInternalContext();
                        MVDProvisionExecElem memberComplex = (MVDProvisionExecElem)complexOperations.keyElementAt(i);
                        MVDSource elemSource = memberComplex.getSource();
                        aCont.bind(origop.getEngineData(), elemSource.getTree());
                        MxResponse mxresp = aCont.answerRequest(memberComplex.getRequest());
                        if (mxresp.getOperRes().getCode() != 0) {
                            MVDLogger.Log("Provisioning: Complex operation failed with code:" + mxresp.getOperRes().getCode(), 3);
                            throw new MVDException(65);
                        }
                        MVDLogger.Log("Provisioning: Complex operation:" + memberComplex.getRequest().getChoiceID() + " succesfully executed", 3);
                        aCont.close();
                        aCont = null;
                    }
                    catch (Exception e) {
                        if (aCont != null) {
                            aCont.close();
                            aCont = null;
                        }
                        this.doRollback(origop, complexOperations, i);
                        throw new MVDException(65, "");
                    }
                    var16_18 = null;
                    if (aCont == null) break block12;
                }
                catch (Throwable throwable) {
                    var16_18 = null;
                    if (aCont != null) {
                        aCont.close();
                        aCont = null;
                    }
                    throw throwable;
                }
                aCont.close();
                aCont = null;
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void doRollback(MVDCommonAMDOperation origop, MVDOrderedHashMap complexoperations, int limit) {
        int u = 0;
        while (true) {
            block15: {
                Object var11_11;
                MVDInternalContext aCont;
                block18: {
                    block17: {
                        block16: {
                            if (u >= limit) {
                                return;
                            }
                            aCont = null;
                            try {
                                try {
                                    aCont = new MVDInternalContext();
                                    MVDProvisionExecElem elem = (MVDProvisionExecElem)complexoperations.keyElementAt(u);
                                    MVDProvisionExecElem rollbackElem = (MVDProvisionExecElem)complexoperations.get(elem);
                                    if (rollbackElem == null) {
                                        var11_11 = null;
                                        if (aCont == null) break block15;
                                        break block16;
                                    }
                                    MVDSource elemSource = rollbackElem.getSource();
                                    if (elemSource.getMappingType() != 0) {
                                        aCont.bind(origop.getEngineData(), elemSource.getTree());
                                        MxResponse rolbackResponse = aCont.answerRequest(rollbackElem.getRequest());
                                        if (rolbackResponse.getOperRes().getCode() == 0) {
                                            MVDLogger.Log("Provisioning: Rollback operation:" + rollbackElem.getRequest().getChoiceID() + " succesfully executed", 3);
                                        } else {
                                            MVDLogger.Log("Provisioning: Rollback operation:" + rollbackElem.getRequest().getChoiceID() + " failed", 3);
                                            if (!this.mRollbackAll) {
                                                break block17;
                                            }
                                        }
                                    }
                                    aCont.close();
                                    aCont = null;
                                    break block18;
                                }
                                catch (Exception ignore) {
                                    if (aCont != null) {
                                        aCont.close();
                                        aCont = null;
                                    }
                                    MVDLogger.Log("Provisioning: Exception on rollback operation. Rollback chain broken", 3);
                                    var11_11 = null;
                                    if (aCont != null) {
                                        aCont.close();
                                        aCont = null;
                                    }
                                    break block15;
                                }
                            }
                            catch (Throwable throwable) {
                                var11_11 = null;
                                if (aCont != null) {
                                    aCont.close();
                                    aCont = null;
                                }
                                throw throwable;
                            }
                        }
                        aCont.close();
                        aCont = null;
                        break block15;
                    }
                    var11_11 = null;
                    if (aCont == null) return;
                    aCont.close();
                    return;
                }
                var11_11 = null;
                if (aCont != null) {
                    aCont.close();
                    aCont = null;
                }
            }
            ++u;
        }
    }

    public void setUniqueName(String aName) {
        this.mUniqueName = aName;
    }
}

