/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDKeyStore;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDKeyStoreList {
    private static Hashtable allKeyStores = new Hashtable();
    private static Hashtable newKeyStores;

    public static MVDKeyStore getKeyStoreByID(int KeyStoreID) {
        return (MVDKeyStore)allKeyStores.get(new Integer(KeyStoreID));
    }

    public static void reloadConfig(Node KeyStoreTopNode) throws MVDConfigException {
        MVDKeyStoreList.readAllKeyStores(KeyStoreTopNode);
    }

    public static void applyChanges() {
        allKeyStores = newKeyStores;
    }

    public static void loadConfig(Node KeyStoreTopNode) throws MVDConfigException {
        MVDKeyStoreList.readAllKeyStores(KeyStoreTopNode);
        MVDKeyStoreList.applyChanges();
    }

    private static void readAllKeyStores(Node KeyStoreTopNode) throws MVDConfigException {
        newKeyStores = new Hashtable();
        NodeList nodeList = KeyStoreTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDKeyStore KeyStore = new MVDKeyStore();
            if (!MVDKeyStoreList.fillKeyStoreNode(KeyStore, nodeList.item(i)) || newKeyStores.put(new Integer(KeyStore.ID()), KeyStore) == null) continue;
            throw new MVDConfigException("KeyStore config: Identical hash " + KeyStore.ID());
        }
    }

    private static boolean fillKeyStoreNode(MVDKeyStore KeyStore, Node KeyStoreRecordNode) throws MVDConfigException {
        if (!KeyStoreRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = KeyStoreRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("Name") || nodeStr.equalsIgnoreCase("DisplayName")) {
                    KeyStore.setName(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ID")) {
                    KeyStore.setID(Integer.parseInt(node.getFirstChild().getNodeValue()));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Description")) {
                    KeyStore.setDescription(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("CertstorePath")) {
                    KeyStore.setCertStorePath(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("CertstorePassword")) {
                    KeyStore.setCertStorePassword(node.getFirstChild().getNodeValue());
                    continue;
                }
                if (!nodeStr.equalsIgnoreCase("CertstoreType")) continue;
                KeyStore.setCertStoreType(node.getFirstChild().getNodeValue());
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("KeyStore Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("KeyStore Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }
}

