/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDOrderedHashMap;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDAttributeSource;
import com.sap.idm.vds.config.MVDAttributeSourceList;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDSource;
import com.sap.idm.vds.implicitattr.Attribute;
import com.sap.idm.vds.implicitattr.AttributeSource;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class MVDJoinGroup {
    private String mName;
    private int mId;
    private boolean mEnabled;
    private MVDSource mMaster;
    private String mMasterMandatoryFields = "";
    private MVDOrderedHashMap mJoinEntries;
    private MVDOrderedHashMap mJoinHashMapAttributes;
    private int mJoinLimit;
    private boolean mUseJoinLimit;
    private boolean[] mJoinOnOperation;
    private String mUniqueName;

    public String getMasterMandatoryFields() {
        return this.mMasterMandatoryFields;
    }

    public int getID() {
        return this.mId;
    }

    public String getName() {
        return this.mName;
    }

    public MVDSource getMaster() {
        return this.mMaster;
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public MVDOrderedHashMap getJoinAttributes() {
        MVDOrderedHashMap h = new MVDOrderedHashMap();
        Iterator iter = this.mJoinHashMapAttributes.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Attribute value = new Attribute((Attribute)this.mJoinHashMapAttributes.get(key));
            h.put(key, value);
        }
        return h;
    }

    public MVDOrderedHashMap getJoinEntries() {
        MVDOrderedHashMap map = new MVDOrderedHashMap();
        Iterator iter = this.mJoinEntries.keySet().iterator();
        while (iter.hasNext()) {
            String srcName = (String)iter.next();
            AttributeSource srcCopy = new AttributeSource((AttributeSource)this.mJoinEntries.get(srcName));
            map.put(srcName, srcCopy);
        }
        return map;
    }

    public int getJoinLimit() {
        return this.mJoinLimit;
    }

    public boolean isUseJoinLimit() {
        return this.mUseJoinLimit;
    }

    public String getUniqueName() {
        if (this.mUniqueName == null) {
            String tmp = this.mId + this.mName.replace(' ', '_');
            this.mUniqueName = tmp.length() <= 10 ? tmp : tmp.substring(0, 10);
        }
        return this.mUniqueName;
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public void setMasterMandatoryFields(String am) {
        this.mMasterMandatoryFields = am;
    }

    public void setID(int aID) {
        this.mId = aID;
    }

    public void setMaster(MVDSource am) {
        this.mMaster = am;
    }

    public boolean doJoinOnOperation(int aOperation) {
        return this.mJoinOnOperation[aOperation];
    }

    public void setEnabled(boolean aVal) {
        this.mEnabled = aVal;
    }

    public void setJoinLimit(int aVal) {
        this.mJoinLimit = aVal;
    }

    public void setUseJoinLimit(boolean aVal) {
        this.mUseJoinLimit = aVal;
    }

    public void setJoinOnOperation(String aStrVal) {
        this.mJoinOnOperation = new boolean[3];
        Vector v = MVDUtil.splitString(aStrVal, ",");
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            String op = (String)iter.next();
            if (op.equalsIgnoreCase("base")) {
                this.mJoinOnOperation[0] = true;
                continue;
            }
            if (op.equalsIgnoreCase("one")) {
                this.mJoinOnOperation[1] = true;
                continue;
            }
            if (!op.equalsIgnoreCase("sub")) continue;
            this.mJoinOnOperation[2] = true;
        }
    }

    public void setJoinAttributeEntries(String aProv) throws MVDConfigException {
        this.mJoinHashMapAttributes = new MVDOrderedHashMap();
        this.mJoinEntries = new MVDOrderedHashMap();
        if (aProv == null || aProv.length() == 0) {
            return;
        }
        Vector provrows = MVDUtil.splitString(aProv, ";");
        HashMap allSources = new HashMap();
        Iterator iter = provrows.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            Vector split = MVDUtil.splitString(element, "::");
            if (split.size() != 6) {
                throw new MVDConfigException("Wrong number of values in datasource.join");
            }
            boolean enabled = Boolean.valueOf((String)split.elementAt(0));
            if (!enabled) continue;
            Vector attrnames = MVDUtil.splitString((String)split.elementAt(1), ',');
            Iterator it = attrnames.iterator();
            while (it.hasNext()) {
                String attrname = ((String)it.next()).trim();
                String operation = (String)split.elementAt(2);
                boolean mandatory = Boolean.valueOf((String)split.elementAt(3));
                String sources = (String)split.elementAt(4);
                Vector sourcesAsVector = MVDUtil.splitString(sources, ",");
                boolean single = ((String)split.elementAt(5)).equalsIgnoreCase("S");
                Attribute attr = new Attribute(operation, attrname, single, mandatory);
                Iterator iterator = sourcesAsVector.iterator();
                while (iterator.hasNext()) {
                    String s = (String)iterator.next();
                    this.addToJoinAttributeSource(s, allSources, attr);
                }
                this.mJoinHashMapAttributes.put(attr.getName().toLowerCase(), attr);
            }
        }
    }

    private AttributeSource addToJoinAttributeSource(String aSrcName, HashMap aAllSources, Attribute aAttr) throws MVDConfigException {
        AttributeSource source = (AttributeSource)this.mJoinEntries.get(aSrcName.toLowerCase());
        if (aSrcName.startsWith("\"") || aSrcName.startsWith("$req") || aSrcName.startsWith("$dn")) {
            if (source == null) {
                String newsourcename = MVDUtil.replace(aSrcName, "\"", "");
                source = new AttributeSource(newsourcename);
                this.mJoinEntries.put(aSrcName, source);
            }
            source.addAttribute(aAttr.getName().toLowerCase());
            aAttr.addSource(aSrcName);
        } else {
            if (source == null) {
                int attrsrcid;
                try {
                    attrsrcid = Integer.parseInt(aSrcName);
                }
                catch (NumberFormatException e) {
                    throw new MVDConfigException("Attribute source misconfigured " + aSrcName + " is not a valid ID");
                }
                MVDAttributeSource tmp = MVDAttributeSourceList.getAttributeSourceByID(attrsrcid);
                if (tmp == null) {
                    MVDLogger.Log("Attribute source not found", 7);
                    throw new MVDConfigException("Attribute source not found " + aSrcName);
                }
                source = new AttributeSource(tmp);
                this.mJoinEntries.put(aSrcName.toLowerCase(), source);
            }
            source.addAttribute(aAttr.getName().toLowerCase());
            aAttr.addSource(aSrcName.toLowerCase());
        }
        return source;
    }

    public void setUniqueName(String aName) {
        this.mUniqueName = aName;
    }
}

