/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceList;
import com.sap.idm.vds.config.MVDSource;
import java.util.Vector;

public class MVDDataSourceSequentialGroup {
    private int mIID;
    private boolean mIsAllowed;
    private String mNiceName;
    private Vector mIncludedDS;
    private MVDSource mMasterSource = null;
    private boolean mEnableServerSelect = false;
    private String mServerSelectClass = "NONE";
    private boolean mSearchOneServerOnly = false;
    private String mUniqueName;

    public int IID() {
        return this.mIID;
    }

    public boolean IsAllowed() {
        return this.mIsAllowed;
    }

    public String NiceName() {
        return this.mNiceName;
    }

    public MVDSource MasterSource() {
        return this.mMasterSource;
    }

    public boolean isEnableServerSelectClass() {
        return this.mEnableServerSelect && this.mServerSelectClass != null && this.mServerSelectClass.length() != 0 && !this.mServerSelectClass.equalsIgnoreCase("NONE");
    }

    public String getServerSelectClass() {
        if (this.mEnableServerSelect) {
            return this.mServerSelectClass;
        }
        return "None";
    }

    public Vector IncludedDS() {
        return this.mIncludedDS;
    }

    public String getUniqueName() {
        if (this.mUniqueName == null) {
            String tmp = this.mIID + this.mNiceName.replace(' ', '_');
            this.mUniqueName = tmp.length() <= 10 ? tmp : tmp.substring(0, 10);
        }
        return this.mUniqueName;
    }

    public void SetIID(int id) {
        this.mIID = id;
    }

    public void SetIsAllowed(boolean b) {
        this.mIsAllowed = b;
    }

    public void SetNiceName(String s) {
        this.mNiceName = s;
    }

    public void SetMasterSource(MVDSource s) {
        this.mMasterSource = s;
    }

    public void setServerSelectClass(String aServerSelectClass) {
        this.mServerSelectClass = aServerSelectClass;
    }

    public void setEnableServerSelect(boolean aEnabled) {
        this.mEnableServerSelect = aEnabled;
    }

    public void AddIncludedDS(MVDSource s) {
        if (this.mIncludedDS == null) {
            this.mIncludedDS = new Vector();
        }
        this.mIncludedDS.add(s);
        if (s.getIsMaster()) {
            this.mMasterSource = s;
        }
    }

    public void SetIncludedDS(String s) throws MVDConfigException {
        if (s.length() > 0) {
            Vector tmp = MVDUtil.splitString(s, ":");
            for (int t = 0; t < tmp.size(); ++t) {
                int dsid = Integer.parseInt((String)tmp.elementAt(t));
                MVDDataSource locds = MVDDataSourceList.getDSByID(dsid);
                if (locds == null) {
                    throw new MVDConfigException("DataSourceGroup config, Could not find group member:" + tmp.elementAt(t));
                }
                if (this.mIncludedDS == null) {
                    this.mIncludedDS = new Vector();
                }
                MVDSource sss = new MVDSource();
                sss.setMappingType(0);
                sss.setMappingID(dsid);
                if (t == 0) {
                    sss.setIsMaster(true);
                    this.mMasterSource = sss;
                } else {
                    sss.setIsMaster(false);
                }
                this.mIncludedDS.add(sss);
            }
        }
    }

    public boolean isSearchOneServerOnly() {
        return this.mSearchOneServerOnly;
    }

    public void setSearchOneServerOnly(boolean aRunOneServerOnly) {
        this.mSearchOneServerOnly = aRunOneServerOnly;
    }

    public void setUniqueName(String aName) {
        this.mUniqueName = aName;
    }
}

