/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Vector;

public class MVDDataSourceGroup {
    private int mIID;
    private boolean mIsAllowed;
    private String mNiceName;
    private boolean mJoinOnAllOperations = true;
    private boolean mLimitMasterEntries;
    private Vector mIncludedDS;
    private HashMap mConnectionArray;
    private HashMap mConnectionTypes;
    private String mAdditionalAttributes = "";
    private int mJoinLimit;
    private String mUniqueName;

    public int IID() {
        return this.mIID;
    }

    public boolean IsAllowed() {
        return this.mIsAllowed;
    }

    public String NiceName() {
        return this.mNiceName;
    }

    public boolean JoinOnAllOperations() {
        return this.mJoinOnAllOperations;
    }

    public boolean LimitMasterEntries() {
        return this.mLimitMasterEntries;
    }

    public Vector IncludedDS() {
        return this.mIncludedDS;
    }

    public HashMap ConnectionArray() {
        return this.mConnectionArray;
    }

    public HashMap ConnectionTypes() {
        return this.mConnectionTypes;
    }

    public String AdditionalAttributes() {
        return this.mAdditionalAttributes;
    }

    public int JoinLimit() {
        return this.mJoinLimit;
    }

    public String getUniqueName() {
        if (this.mUniqueName == null) {
            String tmp = this.mIID + this.mNiceName.replace(' ', '_');
            this.mUniqueName = tmp.length() <= 10 ? tmp : tmp.substring(0, 10);
        }
        return this.mUniqueName;
    }

    public void SetIID(int id) {
        this.mIID = id;
    }

    public void SetIsAllowed(boolean b) {
        this.mIsAllowed = b;
    }

    public void SetNiceName(String s) {
        this.mNiceName = s;
    }

    public void SetJoinOnAllOperations(boolean b) {
        this.mJoinOnAllOperations = b;
    }

    public void SetLimitMasterEntries(boolean b) {
        this.mLimitMasterEntries = b;
    }

    public void SetAdditionalAttributes(String s) {
        this.mAdditionalAttributes = s;
    }

    public void SetJoinLimit(int id) {
        this.mJoinLimit = id;
    }

    public void SetConnectionArray(String s) {
        this.mConnectionArray = new HashMap();
        this.mConnectionTypes = new HashMap();
        if (s.length() > 0) {
            Vector sss = MVDUtil.splitString(s, "[&&]");
            Enumeration e = sss.elements();
            while (e.hasMoreElements()) {
                String tempString = (String)e.nextElement();
                Vector kkk = MVDUtil.splitString(tempString, "[$]");
                this.mConnectionArray.put(kkk.elementAt(0), kkk.elementAt(2));
                this.mConnectionTypes.put(kkk.elementAt(0), kkk.elementAt(1));
            }
        }
    }

    public void SetIncludedDS(String s) throws MVDConfigException {
        if (s.length() > 0) {
            Vector tmp = MVDUtil.splitString(s, ":");
            for (int t = 0; t < tmp.size(); ++t) {
                MVDDataSource locds = MVDDataSourceList.getDSByID(Integer.parseInt((String)tmp.elementAt(t)));
                if (locds == null) {
                    throw new MVDConfigException("DataSourceGroup config, Could not find group member:" + tmp.elementAt(t));
                }
                if (this.mIncludedDS == null) {
                    this.mIncludedDS = new Vector();
                }
                this.mIncludedDS.add(locds);
            }
        }
    }

    public void setUniqueName(String aName) {
        this.mUniqueName = aName;
    }
}

