/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.MVDAttributeSource;
import com.sap.idm.vds.config.MVDConfigException;
import java.util.Hashtable;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MVDAttributeSourceList {
    private static Hashtable allAttributeSources = new Hashtable();
    private static Hashtable newAttributeSources;

    public static MVDAttributeSource getAttributeSourceByID(int attributeSourceID) {
        return (MVDAttributeSource)allAttributeSources.get(new Integer(attributeSourceID));
    }

    public static void reloadConfig(Node aRuleTopNode) throws MVDConfigException {
        MVDAttributeSourceList.readAllAttributeSources(aRuleTopNode);
    }

    public static void initReload() {
        newAttributeSources = new Hashtable();
    }

    public static void loadConfig(Node aRuleTopNode) throws MVDConfigException {
        MVDAttributeSourceList.readAllAttributeSources(aRuleTopNode);
    }

    public static void applyChanges() {
        allAttributeSources = newAttributeSources;
    }

    public static void readAllAttributeSources(Node attributeSourceTopNode) throws MVDConfigException {
        NodeList nodeList = attributeSourceTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            MVDAttributeSource attributeSource = new MVDAttributeSource();
            if (!MVDAttributeSourceList.fillAttributeSourceNode(attributeSource, nodeList.item(i)) || newAttributeSources.put(new Integer(attributeSource.getId()), attributeSource) == null) continue;
            throw new MVDConfigException("Attribute source config: Identical id " + attributeSource.getId() + "/" + attributeSource.getName());
        }
    }

    private static boolean fillAttributeSourceNode(MVDAttributeSource attributeSource, Node attributeSourceRecordNode) throws MVDConfigException {
        if (!attributeSourceRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = attributeSourceRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("Name")) {
                    strVal = node.getFirstChild().getNodeValue();
                    attributeSource.setName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("ID")) {
                    strVal = node.getFirstChild().getNodeValue();
                    int intVal = Integer.parseInt(strVal);
                    attributeSource.setId(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("StartingPoint")) {
                    strVal = node.getFirstChild().getNodeValue();
                    attributeSource.setStartingPoint(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("template")) {
                    strVal = node.getFirstChild().getNodeValue();
                    attributeSource.setTemplateDN(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("filter")) {
                    strVal = node.getFirstChild().getNodeValue();
                    attributeSource.setFilter(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("optype")) {
                    strVal = node.getFirstChild().getNodeValue();
                    attributeSource.setOperationType(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("username")) {
                    strVal = node.getFirstChild().getNodeValue();
                    attributeSource.setUsername(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("password")) {
                    strVal = node.getFirstChild().getNodeValue();
                    attributeSource.setPassword(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Server")) {
                    strVal = node.getFirstChild().getNodeValue();
                    attributeSource.setServeraddress(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Port")) {
                    strVal = node.getFirstChild().getNodeValue();
                    attributeSource.setServerport(Integer.parseInt(strVal));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Tree")) {
                    strVal = node.getFirstChild().getNodeValue();
                    attributeSource.setInternalTree(Integer.parseInt(strVal));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Method")) {
                    strVal = node.getFirstChild().getNodeValue();
                    attributeSource.setAttributeMethods(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Internal")) {
                    strVal = node.getFirstChild().getNodeValue();
                    boolean boolVal = Boolean.valueOf(strVal);
                    attributeSource.setUseInternalServer(boolVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in Attribute source config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Attribute source Configuration error: Expected int but got String: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Attribute source Configuration error: Cannot get node value: " + de.getMessage());
        }
        return true;
    }
}

