/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDException;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.MVDUtilities;
import com.sap.idm.vds.config.MVDAttrSourceMethod;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import com.sap.idm.vds.message.MxAttrSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;

public class MVDAttributeSource {
    private int mId = 0;
    private String mStartingPoint = "";
    private String mTemplateDN = "";
    private String mFilter = "(objectclass=*)";
    private int mOperationType = 0;
    private String mUsername = "";
    private String mPassword = "";
    private String mName = "";
    private String mServeraddress = "";
    private int mServerport = 0;
    private boolean mUseInternalServer = true;
    private int mTree = 0;
    private Vector mAttrMethods = new Vector();

    public String getFilter() {
        return this.mFilter;
    }

    public void setFilter(String aFilter) {
        this.mFilter = aFilter;
    }

    public int getId() {
        return this.mId;
    }

    public void setId(int aId) {
        this.mId = aId;
    }

    public int getOperationType() {
        return this.mOperationType;
    }

    public void setOperationType(String aOperation) throws MVDConfigException {
        if (aOperation.equalsIgnoreCase("base")) {
            this.mOperationType = 0;
        } else if (aOperation.equalsIgnoreCase("one-level")) {
            this.mOperationType = 1;
        } else if (aOperation.equalsIgnoreCase("sub-tree")) {
            this.mOperationType = 2;
        } else {
            throw new MVDConfigException("Invalid operation type: " + aOperation);
        }
    }

    public String getStartingPoint() {
        return this.mStartingPoint;
    }

    public void setStartingPoint(String aVirtSp) {
        if (aVirtSp.toLowerCase().endsWith("o=internal")) {
            String temp = aVirtSp.substring(0, aVirtSp.length() - ",o=internal".length());
            int lastkomma = temp.lastIndexOf(44);
            int x = temp.indexOf(95, lastkomma = Math.max(0, lastkomma));
            if (x < 0) {
                // empty if block
            }
            if ((x = temp.indexOf(95, x + 1)) > 0) {
                temp = temp.substring(0, x);
            }
            this.mStartingPoint = temp + ",o=internal";
        } else {
            this.mStartingPoint = aVirtSp;
        }
    }

    public String getPassword() {
        return this.mPassword;
    }

    public void setPassword(String aPassword) {
        this.mPassword = MVDMic_Util.dcString((String)aPassword);
    }

    public String getUsername() {
        return this.mUsername;
    }

    public void setUsername(String aUsername) {
        this.mUsername = aUsername;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public String getTemplateDN() {
        return this.mTemplateDN;
    }

    public void setTemplateDN(String aTemplateDN) {
        this.mTemplateDN = aTemplateDN;
    }

    public String getServeraddress() {
        if (this.mUseInternalServer) {
            return "localhost";
        }
        return this.mServeraddress;
    }

    public void setServeraddress(String aServername) {
        this.mServeraddress = aServername;
    }

    public int getServerport() {
        if (this.mUseInternalServer) {
            return MVDProxy.PortNumber();
        }
        return this.mServerport;
    }

    public void setServerport(int aServerport) {
        this.mServerport = aServerport;
    }

    public boolean isUseInternalServer() {
        return this.mUseInternalServer;
    }

    public void setUseInternalServer(boolean aUseInternalServer) {
        this.mUseInternalServer = aUseInternalServer;
    }

    public void setInternalTree(int aTree) {
        this.mTree = aTree;
    }

    public int getInternalTree() {
        return this.mTree;
    }

    public Vector getAttributeMethods() {
        return this.mAttrMethods;
    }

    public void setAttributeMethods(String aMethods) throws MVDConfigException {
        if (aMethods == null || aMethods.length() == 0) {
            return;
        }
        Vector lines = MVDUtil.splitString(aMethods, ',');
        Iterator iter = lines.iterator();
        while (iter.hasNext()) {
            String line = (String)iter.next();
            Vector l = MVDUtil.splitString(line, "::");
            if (l != null && l.size() == 3) {
                this.mAttrMethods.add(new MVDAttrSourceMethod((String)l.elementAt(0), (String)l.elementAt(1), (String)l.elementAt(2)));
                continue;
            }
            throw new MVDConfigException("Error in Attribute source method definition");
        }
    }

    public String fixDn(String aOrigDn, MxAttrSet aOrgSet) throws MVDException {
        HashMap fromDN = new HashMap();
        MVDUtilities.matchBracketTemplatePortion(aOrigDn, this.mTemplateDN, fromDN);
        String newDN = this.replaceBrackets(this.mStartingPoint, aOrgSet, fromDN);
        if (newDN.indexOf(60) >= 0) {
            MVDLogger.Log("Unable to construct DN", 2);
            throw new MVDException(-1023);
        }
        return newDN;
    }

    public String fixFilter(String aOrigDn, MxAttrSet aOrgSet, String aOrigFilter) throws MVDException {
        String newFilter = this.mFilter;
        if (this.mFilter.toLowerCase().indexOf("$filter$") >= 0 && aOrigFilter != null) {
            newFilter = MVDUtil.replaceIgnoreCase(newFilter, "$filter$", aOrigFilter);
        }
        HashMap fromDN = new HashMap();
        MVDUtilities.matchBracketTemplatePortion(aOrigDn, this.mTemplateDN, fromDN);
        newFilter = this.replaceBrackets(newFilter, aOrgSet, fromDN);
        if (newFilter.indexOf(60) >= 0) {
            MVDLogger.Log("Unable to construct Filter", 2);
            throw new MVDException(-1023);
        }
        return newFilter;
    }

    public boolean requiresAttr(String attrName) {
        if (attrName.equals("*")) {
            return true;
        }
        String aname = "<" + attrName + ">";
        if (this.mStartingPoint.toLowerCase().indexOf(aname.toLowerCase()) >= 0) {
            return true;
        }
        if (this.mFilter.toLowerCase().indexOf(aname.toLowerCase()) >= 0) {
            return true;
        }
        for (int xi = 0; xi < this.mAttrMethods.size(); ++xi) {
            MVDAttrSourceMethod o = (MVDAttrSourceMethod)this.mAttrMethods.elementAt(xi);
            if (!o.getOrgVariable().equalsIgnoreCase(attrName)) continue;
            return true;
        }
        return false;
    }

    private String replaceBrackets(String aTextToReplace, MxAttrSet aOrgSet, HashMap aFromDN) {
        Map.Entry element;
        Iterator iter;
        int bracketstart = aTextToReplace.indexOf(60);
        if (bracketstart >= 0) {
            iter = aFromDN.entrySet().iterator();
            while (iter.hasNext() && bracketstart >= 0) {
                element = iter.next();
                aTextToReplace = MVDUtil.replaceIgnoreCase(aTextToReplace, (String)element.getKey(), (String)element.getValue());
                bracketstart = aTextToReplace.indexOf(60);
            }
        }
        if (aOrgSet != null) {
            iter = aOrgSet.getAttrAndValues().entrySet().iterator();
            while (iter.hasNext() && bracketstart >= 0) {
                element = iter.next();
                aTextToReplace = MVDUtil.replaceIgnoreCase(aTextToReplace, "<" + element.getKey() + ">", (String)((Vector)element.getValue()).firstElement());
                bracketstart = aTextToReplace.indexOf(60);
            }
        }
        return aTextToReplace;
    }
}

