/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.LoadBalancingGroup;
import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDSource;
import com.sap.idm.vds.config.MVDSourceList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LoadBalancingGroupList {
    private static Hashtable allGroups = new Hashtable();
    private static Hashtable newGroups = new Hashtable();

    public static LoadBalancingGroup getLBGroupByID(int id) {
        return (LoadBalancingGroup)allGroups.get(new Integer(id));
    }

    public static void applyChanges() {
        allGroups = newGroups;
    }

    public static void reloadConfig(Node dsTopNode) throws MVDConfigException {
        LoadBalancingGroupList.readLBGroup(dsTopNode);
    }

    public static void loadConfig(Node dsTopNode) throws MVDConfigException {
        LoadBalancingGroupList.readLBGroup(dsTopNode);
        LoadBalancingGroupList.applyChanges();
    }

    public static void readLBGroup(Node dsTopNode) throws MVDConfigException {
        newGroups = new Hashtable();
        NodeList nodeList = dsTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            LoadBalancingGroup group = new LoadBalancingGroup();
            if (!LoadBalancingGroupList.fillLBGroup(group, nodeList.item(i))) continue;
            group.connectReferencesAndNormalize();
            newGroups.put(new Integer(group.getId()), group);
        }
    }

    private static boolean fillLBGroup(LoadBalancingGroup ds, Node dsRecordNode) throws MVDConfigException {
        if (!dsRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = dsRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("ID")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setId(Integer.parseInt(strVal));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Name")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Enabled")) {
                    boolean boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.setEnabled(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Source")) {
                    MVDSource source = new MVDSource();
                    MVDSourceList.FillSource(source, node);
                    ds.addSource(source);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("MarkAsDown")) {
                    int intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    ds.setMarkAsDown(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SearchWeight")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setSearchWeight(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("UpdateWeight")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setUpdateWeight(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("SearchAlgorithm")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setSearchAlgorithm(Integer.parseInt(strVal));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("UpdateAlgorithm")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setUpdateAlgorithm(Integer.parseInt(strVal));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Description")) continue;
                if (nodeStr.equalsIgnoreCase("UniqueName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (strVal == null || strVal.length() <= 0) continue;
                    ds.setUniqueName(strVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in LoadBalancing group config: " + nodeStr);
            }
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("LoadBalancing group Configuration error: invalid format: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("LoadBalancing group Configuration error: Cannot get node value: " + de.getMessage());
        }
        catch (Exception e) {
            throw new MVDConfigException("LoadBalancing group config, Could not find proper source");
        }
        return true;
    }

    public static void createInternalTree() throws MVDConfigException {
        Iterator iter = allGroups.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            LoadBalancingGroup src = (LoadBalancingGroup)element.getValue();
            if (!src.isEnabled()) continue;
            MVDAcl.createReferralTree(src);
        }
    }
}

