/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.LicenseConstants;
import com.sap.idm.vds.util.Base64;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.net.InetAddress;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LicenseManager {
    private String mName;
    private String mValidFrom;
    private String mExpires;
    private DocumentBuilderFactory mDocBuilderFactory;
    private DocumentBuilder mDocBuilder;
    private Document mLicenseDoc;
    private Element mProductLicense = null;

    public LicenseManager(File aLicenseFile, String aProductName) throws Exception {
        NodeList nodelist = null;
        try {
            this.mDocBuilderFactory = DocumentBuilderFactory.newInstance();
            this.mDocBuilderFactory.setValidating(false);
            this.mDocBuilder = this.mDocBuilderFactory.newDocumentBuilder();
            this.mLicenseDoc = this.mDocBuilder.parse(aLicenseFile);
            nodelist = this.mLicenseDoc.getElementsByTagName(LicenseConstants.LICENSE);
            block2: for (int i = 0; i < nodelist.getLength(); ++i) {
                Element ProductLicense = (Element)nodelist.item(i);
                NodeList products = ProductLicense.getElementsByTagName(LicenseConstants.PRODUCT);
                String product = "";
                boolean found = false;
                for (int ii = 0; ii < products.getLength(); ++ii) {
                    Element elm = (Element)products.item(ii);
                    Node theAttr = elm.getFirstChild();
                    if (theAttr == null || !(product = theAttr.getNodeValue()).equalsIgnoreCase(aProductName)) continue;
                    this.mProductLicense = ProductLicense;
                    continue block2;
                }
            }
            if (this.mProductLicense != null) {
                String licensedTo = this.getTextValue(this.mProductLicense, LicenseConstants.LICENSED_TO, LicenseConstants.UNKNOWN_USER);
                this.mName = this.getTextValue(this.mProductLicense, LicenseConstants.CUSTOMER_NAME, licensedTo);
                this.mValidFrom = this.getTextValue(this.mProductLicense, LicenseConstants.VALID_FROM, "");
                String validTo = this.getTextValue(this.mProductLicense, LicenseConstants.VALID_TO, "");
                this.mExpires = this.getTextValue(this.mProductLicense, LicenseConstants.EXPIRES, validTo);
                if (this.mExpires.equalsIgnoreCase(LicenseConstants.FOREVER)) {
                    this.mExpires = LicenseConstants.NEVER;
                }
            }
        }
        catch (Exception e) {
            System.err.println(LicenseConstants.ERR_PARSE_FAIL + aLicenseFile.getAbsolutePath());
            throw e;
        }
    }

    public final boolean gotLicense() {
        return this.mProductLicense != null;
    }

    private boolean isWithinLegalDateRange() {
        Date now = new Date();
        SimpleDateFormat in = new SimpleDateFormat("ddMMyyyy");
        if (this.mExpires.length() > 0 && !this.mExpires.equalsIgnoreCase(LicenseConstants.NEVER)) {
            try {
                Date from;
                if (this.mValidFrom.length() > 0 && now.compareTo(from = in.parse(this.mValidFrom)) < 0) {
                    return false;
                }
                Date to = in.parse(this.mExpires);
                if (to.compareTo(now) < 0) {
                    return false;
                }
            }
            catch (ParseException pe) {
                return false;
            }
        }
        return true;
    }

    private boolean isLegalMachine() {
        String hostName = "localhost";
        String ipAddress = "";
        try {
            InetAddress MyAddress = InetAddress.getLocalHost();
            hostName = MyAddress.getHostName();
            ipAddress = MyAddress.getHostAddress();
        }
        catch (Exception e) {
            return true;
        }
        String machine = this.getTextValue(this.mProductLicense, LicenseConstants.HOST_NAME, hostName);
        char[] delim = new char[]{','};
        Vector machines = this.splitString(machine, delim);
        Iterator it = machines.iterator();
        while (it.hasNext()) {
            String oneMachine = (String)it.next();
            String stripped = "";
            int idx = oneMachine.indexOf(46);
            if (idx > 0) {
                stripped = oneMachine.substring(0, idx);
            }
            if (!oneMachine.equalsIgnoreCase(hostName) && !stripped.equalsIgnoreCase(hostName) && !oneMachine.equalsIgnoreCase(ipAddress)) continue;
            return true;
        }
        return false;
    }

    private boolean cs3() throws IOException, TransformerConfigurationException, TransformerException {
        String oldKey = this.mProductLicense.getAttribute(LicenseConstants.KEY);
        this.mProductLicense.setAttribute(LicenseConstants.KEY, "null");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer();
        Properties oprops = new Properties();
        oprops.put("method", "XML");
        oprops.put("indent", "yes");
        serializer.setOutputProperties(oprops);
        serializer.transform(new DOMSource(this.mProductLicense), new StreamResult(output));
        output.close();
        String tmp = output.toString("UTF-8");
        tmp = this.replace(tmp, "\r\n", "\n");
        tmp = this.replace(tmp, "\n", "");
        tmp = this.replace(tmp, "?><", "?>\n<");
        byte[] sBuf = tmp.trim().getBytes("UTF-8");
        byte[] out = MVDUtil.getMD5Bytes(sBuf);
        this.mProductLicense.setAttribute(LicenseConstants.KEY, oldKey);
        String a = LicenseManager.dumpBytes(out);
        if (a.equalsIgnoreCase(oldKey)) {
            return true;
        }
        return a.equalsIgnoreCase(oldKey);
    }

    private boolean cs2() throws IOException, TransformerConfigurationException, TransformerException {
        String oldKey = this.mProductLicense.getAttribute(LicenseConstants.KEY);
        this.mProductLicense.setAttribute(LicenseConstants.KEY, "null");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer();
        Properties oprops = new Properties();
        oprops.put("method", "XML");
        oprops.put("indent", "yes");
        serializer.setOutputProperties(oprops);
        serializer.transform(new DOMSource(this.mProductLicense), new StreamResult(output));
        output.close();
        String tmp = output.toString("UTF-8");
        tmp = this.replace(tmp, "\r\n", "\n");
        byte[] sBuf = tmp.trim().getBytes("UTF-8");
        byte[] out = MVDUtil.getMD5Bytes(sBuf);
        this.mProductLicense.setAttribute(LicenseConstants.KEY, oldKey);
        String a = LicenseManager.dumpBytes(out);
        if (a.equalsIgnoreCase(oldKey)) {
            return true;
        }
        return this.cs3();
    }

    private boolean cs() throws IOException, TransformerConfigurationException, TransformerException {
        String oldKey = this.mProductLicense.getAttribute(LicenseConstants.KEY);
        this.mProductLicense.setAttribute(LicenseConstants.KEY, "null");
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        TransformerFactory tfactory = TransformerFactory.newInstance();
        Transformer serializer = tfactory.newTransformer();
        Properties oprops = new Properties();
        oprops.put("indent", "no");
        serializer.setOutputProperties(oprops);
        serializer.transform(new DOMSource(this.mProductLicense), new StreamResult(output));
        output.close();
        String tmp = output.toString("UTF-8");
        tmp = this.replace(tmp, "\r\n", "\n");
        byte[] sBuf = tmp.trim().getBytes("UTF-8");
        byte[] out = MVDUtil.getMD5Bytes(sBuf);
        this.mProductLicense.setAttribute(LicenseConstants.KEY, oldKey);
        String a = LicenseManager.dumpBytes(out);
        if (a.equalsIgnoreCase(oldKey)) {
            return true;
        }
        return this.cs2();
    }

    public final boolean verify() {
        try {
            if (this.mProductLicense == null) {
                return false;
            }
            return this.isWithinLegalDateRange() && this.isLegalMachine() && this.cs();
        }
        catch (Exception e) {
            System.err.println(LicenseConstants.ERR_EXCEPTION + e.toString());
            return false;
        }
    }

    public final String getInfo() {
        boolean ok;
        HashMap hm;
        String machine;
        String info = LicenseConstants.STR_LICENSED_TO + this.mName;
        String email = this.getTextValue(this.mProductLicense, LicenseConstants.CUSTOMER_EMAIL, "");
        if (email.length() > 2) {
            info = info + "\nEmail: " + email;
        }
        SimpleDateFormat in = new SimpleDateFormat("ddMMyyyy");
        SimpleDateFormat out = new SimpleDateFormat("d. MMMMM yyyy");
        if (this.mValidFrom.length() > 0) {
            try {
                info = info + LicenseConstants.STR_LIC_VALID_FROM + out.format(in.parse(this.mValidFrom));
            }
            catch (Exception e) {
                System.err.println(LicenseConstants.ERR_PARSE_DATE + this.mValidFrom + "' - " + e.toString());
                e.printStackTrace();
            }
        }
        if (this.mExpires.length() > 0 && !this.mExpires.equalsIgnoreCase(LicenseConstants.NEVER)) {
            try {
                info = info + LicenseConstants.STR_LIC_EXPIRES + out.format(in.parse(this.mExpires));
            }
            catch (Exception e) {
                System.err.println(LicenseConstants.ERR_PARSE_EXP_DATE + this.mExpires + "' - " + e.toString());
                e.printStackTrace();
            }
        }
        if ((machine = this.getTextValue(this.mProductLicense, LicenseConstants.HOST_NAME, "")).length() > 2) {
            info = info + LicenseConstants.STR_LIC_VALID_MACHINES + machine;
        }
        if ((hm = this.getTags()) != null && !hm.isEmpty()) {
            Object[] a = hm.keySet().toArray();
            Arrays.sort(a);
            for (int ii = 0; ii < a.length; ++ii) {
                String tagName = a[ii].toString();
                if (tagName.equalsIgnoreCase(LicenseConstants.PRODUCT) || tagName.equalsIgnoreCase(LicenseConstants.CUSTOMER_NAME) || tagName.equalsIgnoreCase(LicenseConstants.VALID_FROM) || tagName.equalsIgnoreCase(LicenseConstants.VALID_TO) || tagName.equalsIgnoreCase(LicenseConstants.CUSTOMER_EMAIL) || tagName.equalsIgnoreCase(LicenseConstants.HOST_NAME) || tagName.equalsIgnoreCase(LicenseConstants.LICENSED_TO) || tagName.equalsIgnoreCase(LicenseConstants.EXPIRES)) continue;
                if (tagName.equalsIgnoreCase(LicenseConstants.MAX_DATASOURCES)) {
                    tagName = LicenseConstants.STR_MAX_DATASOURCES;
                } else if (tagName.equalsIgnoreCase(LicenseConstants.MAX_SESSIONS)) {
                    tagName = LicenseConstants.STR_MAX_SESSIONS;
                }
                info = info + "\n" + tagName + ": " + this.replace(hm.get(a[ii]).toString(), "!!", "  -  ");
            }
        }
        if (!this.isWithinLegalDateRange()) {
            info = info + LicenseConstants.STR_LIC_HAS_EXPIRED;
        }
        if (!this.isLegalMachine()) {
            info = info + LicenseConstants.STR_LIC_NOT_VALID_MACHINE;
        }
        try {
            ok = this.cs();
        }
        catch (Exception e) {
            ok = false;
        }
        if (!ok) {
            info = info + LicenseConstants.STR_LIC_TAMPERED;
        }
        return info;
    }

    private String decodeValue(String aInput) {
        String result = aInput;
        if (result.startsWith("::")) {
            try {
                byte[] bTemp = Base64.decode(result.substring(2).trim());
                result = new String(bTemp, "UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    private String getTextValue(Element aElm, String aAttrName, String aDefault) {
        String result = "";
        char[] d = new char[]{'/'};
        Vector attrNames = this.splitString(aAttrName, d);
        Element elm = aElm;
        Iterator it = attrNames.iterator();
        while (it.hasNext()) {
            NodeList nodelist;
            String tagName = (String)it.next();
            if (it.hasNext()) {
                nodelist = elm.getElementsByTagName(tagName);
                elm = (Element)nodelist.item(0);
                continue;
            }
            nodelist = elm.getElementsByTagName(tagName);
            for (int ii = 0; ii < nodelist.getLength(); ++ii) {
                Node theAttr;
                String value = "";
                elm = (Element)nodelist.item(ii);
                short typ = elm.getNodeType();
                if (typ == 3 || typ == 4) {
                    value = elm.getNodeValue();
                } else if (typ == 1 && (theAttr = elm.getFirstChild()) != null) {
                    value = theAttr.getNodeValue();
                }
                if (value.startsWith("::")) {
                    value = this.decodeValue(value);
                }
                if ((value = value.trim()).length() <= 0) continue;
                if (result.length() > 0) {
                    result = result + "!!";
                }
                result = result + value;
            }
        }
        if (result.length() == 0) {
            return aDefault;
        }
        return result;
    }

    private static String dumpBytes(byte[] aBytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < aBytes.length; ++i) {
            String s;
            if (i % 32 == 0 && i != 0) {
                sb.append("\n");
            }
            if ((s = Integer.toHexString(aBytes[i])).length() < 2) {
                s = "0" + s;
            }
            if (s.length() > 2) {
                s = s.substring(s.length() - 2);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private Vector splitString(String aString, String aDelimiter) {
        String temp = aString;
        Vector<String> result = new Vector<String>();
        if (aDelimiter != null && aDelimiter.length() > 0) {
            int idx = temp.indexOf(aDelimiter);
            while (idx >= 0) {
                result.add(temp.substring(0, idx));
                temp = temp.substring(idx + aDelimiter.length());
                idx = temp.indexOf(aDelimiter);
            }
        }
        result.add(temp);
        return result;
    }

    private Vector splitString(String aString, char[] aDelimiter) {
        Vector<String> result = new Vector<String>();
        StringTokenizer t = new StringTokenizer(aString, new String(aDelimiter));
        while (t.hasMoreTokens()) {
            result.add(t.nextToken());
        }
        return result;
    }

    private String joinStrings(Vector aStrings, String aDelimiter) {
        String result = "";
        boolean first = true;
        Iterator it = aStrings.iterator();
        while (it.hasNext()) {
            if (first) {
                result = (String)it.next();
                first = false;
                continue;
            }
            result = result + aDelimiter + (String)it.next();
        }
        return result;
    }

    private String replace(String aSource, String aOldString, String aNewString) {
        return this.joinStrings(this.splitString(aSource, aOldString), aNewString);
    }

    public HashMap getTags() {
        HashMap<String, String> hm = new HashMap<String, String>();
        NodeList nl = this.mProductLicense.getChildNodes();
        hm.put(LicenseConstants.KEY, this.mProductLicense.getAttribute(LicenseConstants.KEY));
        for (int i = 0; i < nl.getLength(); ++i) {
            try {
                Element element = (Element)nl.item(i);
                String tagName = element.getTagName();
                String Value = "unknown";
                short typ = element.getNodeType();
                if (typ == 3 || typ == 4) {
                    Value = element.getNodeValue();
                } else if (typ == 1) {
                    Node theAttr = element.getFirstChild();
                    if (theAttr != null) {
                        Value = theAttr.getNodeValue();
                    }
                } else {
                    Value = this.getTextValue(this.mProductLicense, tagName, "Unknown value");
                }
                Value = this.decodeValue(Value);
                if (hm.containsKey(tagName)) {
                    String oldVal = (String)hm.get(tagName);
                    Value = oldVal + "!!" + Value;
                }
                hm.put(tagName, Value);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return hm;
    }

    public long getExpiryTime() {
        if (this.mExpires.equalsIgnoreCase(LicenseConstants.NEVER)) {
            return Long.MAX_VALUE;
        }
        try {
            SimpleDateFormat in = new SimpleDateFormat("ddMMyyyy");
            Date d = in.parse(this.mExpires);
            long oneDay = 86400000L;
            long exp = d.getTime();
            if (exp + oneDay < 0L) {
                return exp;
            }
            return exp + oneDay;
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public static HashMap getTags(File aLicenseFile, String aProductName) throws Exception {
        LicenseManager lce = new LicenseManager(aLicenseFile, aProductName);
        return lce.getTags();
    }
}

