/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.config.FailoverGroup;
import com.sap.idm.vds.config.MVDAcl;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDSource;
import com.sap.idm.vds.config.MVDSourceList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FailoverGroupList {
    private static Hashtable allGroups = new Hashtable();
    private static Hashtable newGroups = new Hashtable();

    public static FailoverGroup getFailoverGroupByID(int id) {
        return (FailoverGroup)allGroups.get(new Integer(id));
    }

    public static void applyChanges() {
        allGroups = newGroups;
    }

    public static void reloadConfig(Node dsTopNode) throws MVDConfigException {
        FailoverGroupList.readFailoverGroup(dsTopNode);
    }

    public static void loadConfig(Node dsTopNode) throws MVDConfigException {
        FailoverGroupList.readFailoverGroup(dsTopNode);
        FailoverGroupList.applyChanges();
    }

    public static void readFailoverGroup(Node dsTopNode) throws MVDConfigException {
        newGroups = new Hashtable();
        NodeList nodeList = dsTopNode.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            FailoverGroup group = new FailoverGroup();
            if (!FailoverGroupList.fillFailoverGroup(group, nodeList.item(i))) continue;
            newGroups.put(new Integer(group.getId()), group);
        }
    }

    private static boolean fillFailoverGroup(FailoverGroup ds, Node dsRecordNode) throws MVDConfigException {
        if (!dsRecordNode.hasChildNodes()) {
            return false;
        }
        try {
            NodeList nodeList = dsRecordNode.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String strVal;
                Node node = nodeList.item(i);
                if (!node.hasChildNodes()) continue;
                String nodeStr = node.getNodeName();
                if (nodeStr.equalsIgnoreCase("ID")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setId(Integer.parseInt(strVal));
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Name")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setName(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Enabled")) {
                    boolean boolVal = node.getFirstChild().getNodeValue().equalsIgnoreCase("true");
                    ds.setEnabled(boolVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Source")) {
                    MVDSource source = new MVDSource();
                    MVDSourceList.FillSource(source, node);
                    ds.addSource(source);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("MarkAsDown")) {
                    int intVal = Integer.parseInt(node.getFirstChild().getNodeValue());
                    ds.setMarkAsDown(intVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("FailoverList")) {
                    strVal = node.getFirstChild().getNodeValue();
                    ds.setFailoverList(strVal);
                    continue;
                }
                if (nodeStr.equalsIgnoreCase("Description")) continue;
                if (nodeStr.equalsIgnoreCase("UniqueName")) {
                    strVal = node.getFirstChild().getNodeValue();
                    if (strVal == null || strVal.length() <= 0) continue;
                    ds.setUniqueName(strVal);
                    continue;
                }
                throw new MVDConfigException("Configuration error: Wrong node type in Failover group config: " + nodeStr);
            }
            ds.extractFailoverList();
        }
        catch (NumberFormatException nfe) {
            throw new MVDConfigException("Failover group Configuration error: invalid format: " + nfe.getMessage());
        }
        catch (DOMException de) {
            throw new MVDConfigException("Failover group Configuration error: Cannot get node value: " + de.getMessage());
        }
        catch (Exception e) {
            throw new MVDConfigException("Failover group config, Could not find proper source");
        }
        return true;
    }

    public static void createInternalTree() throws MVDConfigException {
        Iterator iter = allGroups.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            FailoverGroup src = (FailoverGroup)element.getValue();
            if (!src.isEnabled()) continue;
            MVDAcl.createReferralTree(src);
        }
    }
}

