/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.FailedSource;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDSource;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class FailoverGroup {
    private String mName;
    private int mId;
    private boolean mEnabled;
    private int mMarkAsDown;
    private Vector mUnavailableSources;
    private long mNextScheduledSourceAvailable;
    private MVDSource mMasterSrc = null;
    private Vector mAvailableSources = new Vector();
    private HashMap mAllSources;
    private String mList;
    private Vector mOrder;
    private String mUniqueName;

    public FailoverGroup() {
        this.mUnavailableSources = new Vector();
        this.mAllSources = new HashMap();
        this.mNextScheduledSourceAvailable = Long.MAX_VALUE;
    }

    public MVDSource getNextSource() throws NoSuchElementException {
        if (this.mNextScheduledSourceAvailable < System.currentTimeMillis()) {
            this.recoverFailedSources();
        }
        if (this.mMasterSrc != null) {
            return this.mMasterSrc;
        }
        if (this.mAvailableSources != null && this.mAvailableSources.size() > 0) {
            return (MVDSource)this.mAvailableSources.elementAt(0);
        }
        throw new NoSuchElementException("All sources defined for failover down");
    }

    public void sourceFailed(MVDSource aSource) {
        if (aSource == null) {
            return;
        }
        if (aSource == this.mMasterSrc) {
            FailedSource src = new FailedSource(aSource, this.mMarkAsDown);
            this.mUnavailableSources.add(src);
            if (this.mNextScheduledSourceAvailable == Long.MAX_VALUE) {
                this.mNextScheduledSourceAvailable = src.getAvailableTimestamp();
            }
            this.mMasterSrc = null;
        } else {
            boolean wasActive = this.mAvailableSources.remove(aSource);
            if (!wasActive) {
                String ID = aSource.getSrcID();
                Iterator iter = this.mAvailableSources.iterator();
                while (iter.hasNext()) {
                    MVDSource element = (MVDSource)iter.next();
                    if (!element.getSrcID().equals(ID)) continue;
                    wasActive = true;
                    iter.remove();
                    break;
                }
            }
            if (wasActive) {
                FailedSource src = new FailedSource(aSource, this.mMarkAsDown);
                this.mUnavailableSources.add(src);
                if (this.mNextScheduledSourceAvailable == Long.MAX_VALUE) {
                    this.mNextScheduledSourceAvailable = src.getAvailableTimestamp();
                }
            }
        }
    }

    private void recoverFailedSources() {
        if (this.mUnavailableSources.size() <= 0) {
            return;
        }
        boolean doContinue = true;
        while (doContinue) {
            try {
                FailedSource src = (FailedSource)this.mUnavailableSources.firstElement();
                if (src.getAvailableTimestamp() < System.currentTimeMillis()) {
                    this.mUnavailableSources.removeElementAt(0);
                    if (src.getSource().getIsMaster()) {
                        this.mMasterSrc = src.getSource();
                        continue;
                    }
                    this.mAvailableSources.add(0, src.getSource());
                    continue;
                }
                doContinue = false;
            }
            catch (NoSuchElementException e) {
                doContinue = false;
            }
        }
        this.mNextScheduledSourceAvailable = this.mUnavailableSources.size() == 0 ? Long.MAX_VALUE : ((FailedSource)this.mUnavailableSources.firstElement()).getAvailableTimestamp();
        Collections.sort(this.mAvailableSources, new FailoverListComparator());
    }

    public boolean isEnabled() {
        return this.mEnabled;
    }

    public String getUniqueName() {
        if (this.mUniqueName == null) {
            String tmp = this.mId + this.mName.replace(' ', '_');
            this.mUniqueName = tmp.length() <= 10 ? tmp : tmp.substring(0, 10);
        }
        return this.mUniqueName;
    }

    public void setEnabled(boolean aEnabled) {
        this.mEnabled = aEnabled;
    }

    public void setMarkAsDown(int aMarkAsDown) {
        this.mMarkAsDown = aMarkAsDown;
    }

    public int getId() {
        return this.mId;
    }

    public void setId(int aId) {
        this.mId = aId;
    }

    public String getName() {
        return this.mName;
    }

    public void setName(String aName) {
        this.mName = aName;
    }

    public void addSource(MVDSource aSource) {
        if (aSource.getIsMaster()) {
            this.mMasterSrc = aSource;
        } else {
            this.mAllSources.put(aSource.getSrcID(), aSource);
        }
    }

    public void setFailoverList(String aList) {
        this.mList = aList;
    }

    public void extractFailoverList() throws MVDConfigException {
        if (this.mList == null) {
            return;
        }
        this.mOrder = new Vector();
        Vector v = MVDUtil.splitString(this.mList, ',');
        Iterator iter = v.iterator();
        while (iter.hasNext()) {
            String row = (String)iter.next();
            Vector v2 = MVDUtil.splitString(row, "::");
            boolean enabled = Boolean.valueOf((String)v2.elementAt(0));
            if (!enabled) continue;
            String id = (String)v2.elementAt(1);
            Object o = this.mAllSources.get(id);
            if (o == null) {
                throw new MVDConfigException("Source with ID: " + id + " was not found in configuration.");
            }
            this.mAvailableSources.add(o);
            this.mOrder.add(o);
        }
    }

    public void setUniqueName(String aName) {
        this.mUniqueName = aName;
    }

    private class FailoverListComparator
    implements Comparator {
        private FailoverListComparator() {
        }

        public int compare(Object aO1, Object aO2) {
            int i1 = FailoverGroup.this.mOrder.indexOf(aO1);
            int i2 = FailoverGroup.this.mOrder.indexOf(aO2);
            return i1 - i2;
        }
    }
}

