/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDConfigException;
import com.sap.idm.vds.config.MVDDataSource;
import com.sap.idm.vds.config.MVDDataSourceList;
import com.sap.idm.vds.event.ClassTrigger;
import com.sap.idm.vds.event.EventActionConfig;
import com.sap.idm.vds.event.EventTriggerConfig;
import com.sap.idm.vds.event.FilterEventTrigger;
import com.sap.idm.vds.event.TrueEventTrigger;
import com.sap.idm.vds.util.ConfigUtil;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class EventTriggerList {
    private static HashMap allTriggers = new HashMap();
    private static HashMap newTriggers;

    public static EventTriggerConfig getEventTriggerByID(int aID) {
        return (EventTriggerConfig)allTriggers.get(new Integer(aID));
    }

    public static void reloadEventTriggers(Node aNode) throws MVDConfigException {
        newTriggers = new HashMap();
        EventTriggerList.fillEventTriggers(aNode);
    }

    public static void applyChanges() {
        allTriggers = newTriggers;
    }

    public static void readEventTriggers(Node aNode) throws MVDConfigException {
        newTriggers = new HashMap();
        EventTriggerList.fillEventTriggers(aNode);
        EventTriggerList.applyChanges();
    }

    public static void fillEventTriggers(Node aEvTriggerTopNode) throws MVDConfigException {
        NodeList etRecords = aEvTriggerTopNode.getChildNodes();
        for (int i = 0; i < etRecords.getLength(); ++i) {
            Node n = etRecords.item(i);
            if (n instanceof Text || !(n instanceof Element) || !n.getNodeName().equalsIgnoreCase("Record")) continue;
            int id = 0;
            String name = "";
            String type = "";
            String eventclass = "";
            String eventfilter = "";
            String operations = "ADD,MODIFY,DELETE";
            HashMap params = null;
            Vector<EventActionConfig> actions = new Vector<EventActionConfig>();
            String mappingids = "";
            String usergroups = "";
            String resultcodes = "OK";
            boolean enabled = false;
            NodeList triggerconfN = n.getChildNodes();
            for (int j = 0; j < triggerconfN.getLength(); ++j) {
                Node n2 = triggerconfN.item(j);
                if (!n2.hasChildNodes()) continue;
                String nodename = n2.getNodeName();
                if (nodename.equalsIgnoreCase("ID")) {
                    id = Integer.parseInt(n2.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodename.equalsIgnoreCase("Name")) {
                    name = n2.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodename.equalsIgnoreCase("Enabled")) {
                    enabled = Boolean.valueOf(n2.getFirstChild().getNodeValue());
                    continue;
                }
                if (nodename.equalsIgnoreCase("Type")) {
                    type = n2.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodename.equalsIgnoreCase("Operations")) {
                    operations = n2.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodename.equalsIgnoreCase("EventFilter")) {
                    eventfilter = n2.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodename.equalsIgnoreCase("EventClassName")) {
                    eventclass = n2.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodename.equalsIgnoreCase("EventParameters")) {
                    params = ConfigUtil.readParams(n2);
                    continue;
                }
                if (nodename.equalsIgnoreCase("OperationResult")) {
                    resultcodes = n2.getFirstChild().getNodeValue();
                    continue;
                }
                if (nodename.equalsIgnoreCase("Actions")) {
                    NodeList evActlist = n2.getChildNodes();
                    for (int x = 0; x < evActlist.getLength(); ++x) {
                        Node evacrec = evActlist.item(x);
                        if (!(evacrec instanceof Element)) continue;
                        String actionclass = "";
                        HashMap actionparams = null;
                        boolean enabledonok = true;
                        boolean enabledonerror = true;
                        NodeList nnn = evacrec.getChildNodes();
                        for (int y = 0; y < nnn.getLength(); ++y) {
                            Node hhh = nnn.item(y);
                            if (!hhh.hasChildNodes()) continue;
                            String nname = hhh.getNodeName();
                            if (nname.equalsIgnoreCase("Classname")) {
                                actionclass = hhh.getFirstChild().getNodeValue();
                                continue;
                            }
                            if (nname.equalsIgnoreCase("Parameters")) {
                                actionparams = ConfigUtil.readParams(hhh);
                                continue;
                            }
                            if (nname.equalsIgnoreCase("EnabledOnOK")) {
                                enabledonok = Boolean.valueOf(hhh.getFirstChild().getNodeValue());
                                continue;
                            }
                            if (!nname.equalsIgnoreCase("EnabledOnNotOK")) continue;
                            enabledonerror = Boolean.valueOf(hhh.getFirstChild().getNodeValue());
                        }
                        EventActionConfig action = new EventActionConfig(actionclass, actionparams, enabledonok, enabledonerror);
                        actions.add(action);
                    }
                    continue;
                }
                if (nodename.equalsIgnoreCase("MappingType")) continue;
                if (nodename.equalsIgnoreCase("MappingID")) {
                    mappingids = n2.getFirstChild().getNodeValue();
                    continue;
                }
                if (!nodename.equalsIgnoreCase("TargetUserGroups")) continue;
                usergroups = n2.getFirstChild().getNodeValue();
            }
            EventTriggerConfig evtrigger = null;
            if (type.equalsIgnoreCase("none")) {
                evtrigger = new TrueEventTrigger(usergroups, operations, resultcodes);
            } else if (type.equalsIgnoreCase("filter")) {
                String filter = eventfilter;
                if (filter == null || filter.length() == 0) {
                    throw new MVDConfigException("Missing filter in EventTrigger: " + name);
                }
                evtrigger = new FilterEventTrigger(filter, usergroups, operations, resultcodes);
            } else if (type.equalsIgnoreCase("class")) {
                String classname = eventclass;
                evtrigger = new ClassTrigger(classname, params, usergroups, operations, resultcodes);
            } else {
                MVDLogger.Log("Unknown trigger type: " + type, 7);
                throw new MVDConfigException("Unknown trigger type: " + type);
            }
            evtrigger.setEnabled(enabled);
            evtrigger.setName(name);
            evtrigger.setID(id);
            Iterator iterator = actions.iterator();
            while (iterator.hasNext()) {
                EventActionConfig a = (EventActionConfig)iterator.next();
                evtrigger.addEventAction(a);
            }
            newTriggers.put(new Integer(evtrigger.getID()), evtrigger);
            Vector mappings = MVDUtil.splitString(mappingids, ',');
            Iterator iter = mappings.iterator();
            while (iter.hasNext()) {
                String strdsid = (String)iter.next();
                int dsid = Integer.parseInt(strdsid);
                MVDDataSource ds = MVDDataSourceList.getDSByID(dsid);
                ds.addTrigger(evtrigger);
            }
        }
    }
}

