/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.config;

import com.sap.idm.vds.MVDError;
import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.MVDUtil;
import com.sap.idm.vds.config.MVDProxy;
import com.sap.idm.vds.config.MVDProxyLoggerDebitList;
import com.sap.idm.vds.ie.VerifyMVDConf;
import com.sap.idm.vds.ie.op.common.util.MVDMic_Util;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class Config {
    private String mWorkArea;
    private String mCfgName;
    private Document mDoc = null;
    private DocumentBuilder dBuilder;
    private String savedDoc;
    private String lastCorrectDoc;
    private int mProtocol = 0;
    private String mUniqueInstanceID = "";
    private File mFile = null;
    private long lastModified;
    private URL mUrl;

    public String getUniqueInstanceID() {
        return this.mUniqueInstanceID;
    }

    public void setUniqueInstanceID(String aID) {
        this.mUniqueInstanceID = aID;
    }

    public int getProtocol() {
        return this.mProtocol;
    }

    public void setProtocol(int aID) {
        this.mProtocol = aID;
    }

    public Document getDoc() {
        return this.mDoc;
    }

    public String getWorkArea() {
        if (this.mWorkArea == null) {
            File tmp = this.mFile.getAbsoluteFile();
            this.mWorkArea = tmp.getParentFile().getAbsolutePath();
        }
        return this.mWorkArea;
    }

    public String getConfigName() {
        return this.mCfgName;
    }

    public Config(URL url) throws Exception {
        this.mUrl = url;
    }

    private Document fixConstants(byte[] aDocumentData) {
        try {
            String wholeDocAsString = new String(aDocumentData);
            String homedir = System.getProperty("MX_SERVER_HOME");
            if (homedir != null) {
                StringBuffer buf = new StringBuffer(wholeDocAsString);
                String lookfor = "%MX_SERVER_HOME%";
                int index = buf.indexOf(lookfor);
                while (index >= 0) {
                    buf.replace(index, index + lookfor.length(), homedir);
                    index = buf.indexOf(lookfor);
                }
                wholeDocAsString = buf.toString();
                aDocumentData = wholeDocAsString.getBytes();
            }
            ByteArrayInputStream bis = new ByteArrayInputStream(aDocumentData);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            this.dBuilder = dbf.newDocumentBuilder();
            Document configAsDOM = this.dBuilder.parse(bis);
            Node node = configAsDOM.getElementsByTagName("Proxy").item(0);
            MVDProxyLoggerDebitList.readMVDGlobals(node);
            HashMap globals = MVDProxy.MVDGlobals();
            Set globalkeys = globals.keySet();
            HashMap<String, String> globalKeyMapping = new HashMap<String, String>();
            Iterator iter = globalkeys.iterator();
            while (iter.hasNext()) {
                String key = (String)iter.next();
                globalKeyMapping.put(key.toUpperCase(), key);
            }
            Element root = configAsDOM.getDocumentElement();
            NodeList childNodes = root.getChildNodes();
            for (int i = 0; i < childNodes.getLength(); ++i) {
                Node childNode = childNodes.item(i);
                if (childNode.getNodeType() == 3 || !(childNode = this.fixConstantsInAttributes(childNode, globals, globalKeyMapping)).hasChildNodes()) continue;
                childNode = this.fixConstantsInTextNodes(childNode, globals, globalKeyMapping);
            }
            return configAsDOM;
        }
        catch (Exception e) {
            MVDError.ConfigError("Could not parse xml file, " + e.getMessage());
            return null;
        }
    }

    private Node fixConstantsInAttributes(Node aNode, HashMap aGlobals, HashMap aGlobalKeyMapping) {
        if (!aNode.hasAttributes()) {
            return aNode;
        }
        Element parentNodeAsElement = (Element)aNode;
        NamedNodeMap attributes = parentNodeAsElement.getAttributes();
        for (int attrCounter = 0; attrCounter < attributes.getLength(); ++attrCounter) {
            String attrName = attributes.item(attrCounter).getNodeName();
            String attrValue = attributes.item(attrCounter).getNodeValue();
            int indexOfConst = attrValue.indexOf("%$const.");
            if (indexOfConst < 0) continue;
            attrValue = Config.mapConstantToValue(attrValue, aGlobals, aGlobalKeyMapping);
            parentNodeAsElement.setAttribute(attrName, attrValue);
        }
        return aNode;
    }

    private Node fixConstantsInTextNodes(Node aParentNode, HashMap aGlobals, HashMap aGlobalKeyMapping) {
        if (!(aParentNode = this.fixConstantsInAttributes(aParentNode, aGlobals, aGlobalKeyMapping)).hasChildNodes()) {
            return aParentNode;
        }
        NodeList childNodes = aParentNode.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node childNode = childNodes.item(i);
            if (childNode.getNodeType() == 3) {
                String constant;
                int indexOfConst;
                if (childNode != null && childNode.getNodeValue().equalsIgnoreCase("") || (indexOfConst = (constant = childNode.getNodeValue()).indexOf("%$const.")) == -1) continue;
                constant = Config.mapConstantToValue(constant, aGlobals, aGlobalKeyMapping);
                Text valueNode = aParentNode.getOwnerDocument().createTextNode(constant);
                aParentNode.removeChild(childNode);
                aParentNode.appendChild(valueNode);
                continue;
            }
            childNode = this.fixConstantsInTextNodes(childNode, aGlobals, aGlobalKeyMapping);
        }
        return aParentNode;
    }

    public static String mapConstantToValue(String aConstant, HashMap aGlobals, HashMap aGlobalKeyMapping) {
        String outputString = "";
        boolean bConstants = false;
        int constlength = "%$const.".length();
        int lastix = -1;
        do {
            bConstants = false;
            if ((lastix = aConstant.indexOf("%$const.", lastix)) < 0) continue;
            bConstants = true;
            String savedDocLeft = aConstant.substring(0, lastix);
            String comment = "";
            int endconst = aConstant.indexOf("%", lastix + 1);
            if (endconst < 0) {
                comment = comment + "Something is wrong - no ending %";
                continue;
            }
            String wholeConst = aConstant.substring(lastix, endconst + 1);
            String varname = wholeConst.substring(constlength, wholeConst.length() - 1);
            String savedDocRight = aConstant.substring(endconst + 1);
            String isThisConst = (String)aGlobals.get("GLOBAL_" + varname);
            if (isThisConst == null) {
                String key = (String)aGlobalKeyMapping.get("GLOBAL_" + varname.toUpperCase());
                if (key != null) {
                    isThisConst = (String)aGlobals.get(key);
                }
                if (isThisConst == null) {
                    if (comment.length() > 0) {
                        comment = comment + "Expanding constant " + varname + " failed";
                        outputString = outputString + "[" + comment + "]";
                    }
                    ++lastix;
                    continue;
                }
                isThisConst = MVDMic_Util.dcString((String)isThisConst);
            } else {
                isThisConst = MVDMic_Util.dcString((String)isThisConst);
            }
            if (comment.length() > 0) {
                outputString = outputString + "[" + comment + "]";
            }
            aConstant = savedDocLeft + isThisConst + savedDocRight;
        } while (bConstants);
        return aConstant;
    }

    public Config(String xmlFileName, String workArea) throws Exception {
        File configFile;
        this.mFile = configFile = new File(xmlFileName);
        this.mWorkArea = workArea;
        this.mCfgName = xmlFileName.substring(xmlFileName.lastIndexOf(File.separatorChar) + 1, xmlFileName.lastIndexOf("."));
        byte[] data = MVDUtil.readFile(this.mFile);
        this.lastCorrectDoc = this.savedDoc = new String(data);
        this.createConfig(data, this.mCfgName, workArea);
    }

    public void createConfig(byte[] data, String configName, String workArea) {
        try {
            this.mDoc = this.fixConstants(data);
            boolean skipverifier = Boolean.getBoolean("SKIPVERIFIER");
            if (!skipverifier) {
                this.verifyConfig(this.mDoc);
            }
        }
        catch (Exception e) {
            MVDError.ConfigError("Could not parse xml file, " + e.getMessage());
        }
    }

    public Document parseConfig(File aFile) {
        try {
            byte[] data = MVDUtil.readFile(aFile);
            Document doc = this.fixConstants(data);
            boolean skipverifier = Boolean.getBoolean("SKIPVERIFIER");
            if (!skipverifier) {
                this.verifyConfig(doc);
            }
            return doc;
        }
        catch (Exception e) {
            MVDError.ConfigError("Could not parse xml file, " + e.getMessage());
            return null;
        }
    }

    private void verifyConfig(Document aDoc) throws Exception {
        Vector vec = VerifyMVDConf.execute((Document)aDoc, (boolean)false);
        int status = Integer.parseInt((String)vec.elementAt(0));
        if (status == -1) {
            if (vec.size() == 4) {
                System.out.println(((String)vec.elementAt(2)).trim());
                System.out.println(((String)vec.elementAt(3)).trim());
            } else {
                System.out.println("Verifier has changed the configuration");
            }
            System.out.println();
        } else if (status == -2) {
            System.out.println("The version read is NEWER than the one we are prepared for");
        }
    }

    public Document getNewDoc() {
        try {
            if (this.mFile != null && this.lastModified < this.mFile.lastModified()) {
                boolean bwas0 = this.lastModified == 0L;
                this.lastModified = this.mFile.lastModified();
                if (!bwas0) {
                    return this.parseConfig(this.mFile);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public File getConfigFile() {
        return this.mFile;
    }

    public String getUniqueConfigBase() {
        return this.getLogBase(this.mUniqueInstanceID);
    }

    public String getTrafficLogFileName() {
        return this.getLogBase(null) + "_traffic.log";
    }

    public String getLogFileName() {
        return this.getLogBase(null) + ".log";
    }

    public String getStatisticFileName() {
        return this.getLogBase(this.mUniqueInstanceID) + "_statistic.log";
    }

    public String getLogBase(String aUniqueID) {
        String appendUniquepart = "";
        if (aUniqueID != null) {
            appendUniquepart = "_" + aUniqueID;
        }
        if (this.mCfgName != null) {
            if (this.mWorkArea == null) {
                return this.mCfgName + appendUniquepart;
            }
            return this.mWorkArea + (this.mWorkArea.endsWith(File.separator) ? "" : File.separator) + this.mCfgName + appendUniquepart;
        }
        if (this.mFile != null) {
            int x;
            String logName = this.mFile.toString();
            if (this.mWorkArea != null) {
                int slashIndex = Math.max(logName.lastIndexOf("\\"), logName.lastIndexOf("/"));
                if (slashIndex >= 0) {
                    logName = logName.substring(slashIndex);
                }
                logName = this.mWorkArea + (this.mWorkArea.endsWith(File.separator) ? "" : File.separator) + logName;
            }
            if ((x = logName.lastIndexOf(".")) > -1 && logName.toLowerCase().endsWith(".xml")) {
                return logName.substring(0, x) + appendUniquepart;
            }
            return logName + appendUniquepart;
        }
        return (this.mWorkArea == null ? "" : this.mWorkArea + File.separator) + "VDS";
    }

    public boolean saveLastCorrectConfig() {
        String filename = this.getLogBase(this.mUniqueInstanceID) + "_lastCorrect.xml";
        try {
            FileOutputStream backup = new FileOutputStream(filename);
            backup.write(this.lastCorrectDoc.getBytes());
            backup.close();
            if (this.mFile != null) {
                this.lastCorrectDoc = new String(MVDUtil.readFile(this.mFile));
            } else if (this.mCfgName != null) {
                this.lastCorrectDoc = this.savedDoc;
            }
            return true;
        }
        catch (Exception e) {
            MVDLogger.Log("Could not save last correct xml file " + e.getMessage(), 7, e);
            return false;
        }
    }
}

