/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.cache.impl;

import com.sap.idm.vds.cache.impl.CachePool;

public class CacheThread
extends Thread {
    private Object syncher = new Object();
    private static CacheThread instance;
    private int cleanedSinceLastGCCall = 0;
    private int callGCOnNumGarbageObjects;
    private long totalCleaned = 0L;
    private boolean mRunning = true;
    private CachePool cachepool;

    public static CacheThread getInstance(CachePool pool) {
        if (instance == null) {
            instance = new CacheThread(pool);
        }
        return instance;
    }

    private CacheThread(CachePool pool) {
        super("MXCacheCleaner");
        this.cachepool = pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.mRunning) {
            try {
                Object object = this.syncher;
                synchronized (object) {
                    this.syncher.wait(this.cachepool.getCleaninterval() * 1000);
                }
                int cl = this.cachepool.doGarbageCollection();
                this.cleanedSinceLastGCCall += cl;
                if (this.cleanedSinceLastGCCall <= this.cachepool.getGCCleanedEntriesTreshold()) continue;
                System.gc();
                this.totalCleaned += (long)this.cleanedSinceLastGCCall;
                this.cleanedSinceLastGCCall = 0;
            }
            catch (Exception e) {
            }
            catch (VirtualMachineError t) {
                System.out.println("Throwable:" + t);
                System.out.println("FATAL error - shutting down");
                System.exit(1);
            }
            catch (Throwable tr) {
                System.out.println("Throwable:" + tr);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forcedclean() {
        try {
            Object object = this.syncher;
            synchronized (object) {
                this.syncher.notify();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public long getTotalCleaned() {
        return this.totalCleaned + (long)this.cleanedSinceLastGCCall;
    }

    public void shutdown() {
        try {
            this.mRunning = false;
            this.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

