/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.cache.impl;

import com.sap.idm.vds.MVDLogger;
import com.sap.idm.vds.cache.impl.Cache;
import com.sap.idm.vds.cache.impl.CacheThread;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;

public class CachePool {
    public static final String INITIAL_SIZE = "cachesize";
    public static final String CLEAN_INTERVAL = "cleaninterval";
    public static final String CLEAN_TO_PERCENTAGE = "cleantopercentage";
    public static final String MEMORY_KEEP_FREE = "MXCACHE_MEM_SOFT_LIMIT";
    public static final String MEMORY_KEEP_ABSOLUTE_FREE = "MXCACHE_MEM_HARD_LIMIT";
    public static final String MEMORY_CLEAN_PERCENTAGE_MAXMEM = "MXCACHE_MEM_CLEAN_PERCENTAGE";
    public static final String GARBAGECOLLECT_TRESHOLD = "MXCACHE_CALL_GC_CLEAN_TRESHOLD";
    public static final String DO_MEMORY_CACHING = "MXCACHE_DO_MEMORY_CACHING";
    public static final String MEMORY_INITIAL_CACHE_SIZE = "MXCACHE_MEM_INITIAL_CACHE_SIZE";
    private static CachePool pool;
    private static long cachehit;
    private static long cacheChecks;
    private HashMap mCacheElements;
    private Vector mAllCaches;
    private int szLimit;
    private CacheThread garbageCollector;
    private int cleancachetopercentage;
    private int cleaninterval;
    private long minimumfree;
    private long absoluteminimumfree;
    private Runtime runtime;
    private int cleanpercentage_MemoryBased;
    private int garbage_collect;
    private int rejected;
    private boolean doMembasedCaching;

    private CachePool(Properties props) {
        this.doMembasedCaching = this.getBoolProperty(props, DO_MEMORY_CACHING, "false");
        this.szLimit = this.doMembasedCaching ? this.getIntProperty(props, MEMORY_INITIAL_CACHE_SIZE, "4000000") : this.getIntProperty(props, INITIAL_SIZE, "4000000");
        this.cleancachetopercentage = this.getIntProperty(props, CLEAN_TO_PERCENTAGE, "0");
        this.cleaninterval = this.getIntProperty(props, CLEAN_INTERVAL, "10");
        this.minimumfree = this.getLongProperty(props, MEMORY_KEEP_FREE, "0");
        this.absoluteminimumfree = this.getLongProperty(props, MEMORY_KEEP_ABSOLUTE_FREE, "20M");
        this.cleanpercentage_MemoryBased = this.getIntProperty(props, MEMORY_CLEAN_PERCENTAGE_MAXMEM, "5");
        this.garbage_collect = this.getIntProperty(props, GARBAGECOLLECT_TRESHOLD, "12000");
        this.mCacheElements = new HashMap();
        this.mAllCaches = new Vector();
        this.runtime = Runtime.getRuntime();
        this.fireGarbageCollector();
    }

    public static CachePool initializePool(Properties props) {
        if (pool == null) {
            pool = new CachePool(props);
        }
        return pool;
    }

    public void reloadProperties(Properties props) {
        this.doMembasedCaching = this.getBoolProperty(props, DO_MEMORY_CACHING, "false");
        this.szLimit = this.doMembasedCaching ? this.getIntProperty(props, MEMORY_INITIAL_CACHE_SIZE, "4000000") : this.getIntProperty(props, INITIAL_SIZE, this.szLimit + "");
        this.cleancachetopercentage = this.getIntProperty(props, CLEAN_TO_PERCENTAGE, this.cleancachetopercentage + "");
        this.cleaninterval = this.getIntProperty(props, CLEAN_INTERVAL, this.cleaninterval + "");
        this.minimumfree = this.getLongProperty(props, MEMORY_KEEP_FREE, this.minimumfree + "");
        this.absoluteminimumfree = this.getLongProperty(props, MEMORY_KEEP_ABSOLUTE_FREE, this.absoluteminimumfree + "");
        this.cleanpercentage_MemoryBased = this.getIntProperty(props, MEMORY_CLEAN_PERCENTAGE_MAXMEM, this.cleanpercentage_MemoryBased + "");
        this.garbage_collect = this.getIntProperty(props, GARBAGECOLLECT_TRESHOLD, this.garbage_collect + "");
    }

    private int getIntProperty(Properties props, String propertyname, String defaultValue) {
        String propvalue = props.getProperty(propertyname, defaultValue);
        char mult = propvalue.charAt(propvalue.length() - 1);
        int multiplier = 1;
        switch (mult) {
            case 'K': 
            case 'k': {
                propvalue = propvalue.substring(0, propvalue.length() - 1);
                multiplier = 1024;
                break;
            }
            case 'M': 
            case 'm': {
                propvalue = propvalue.substring(0, propvalue.length() - 1);
                multiplier = 0x100000;
                break;
            }
            case 'G': 
            case 'g': {
                propvalue = propvalue.substring(0, propvalue.length() - 1);
                multiplier = 0x40000000;
            }
        }
        int x = 0;
        x = Integer.parseInt(propvalue);
        return x *= multiplier;
    }

    private boolean getBoolProperty(Properties props, String propertyname, String defaultValue) {
        String propvalue = props.getProperty(propertyname, defaultValue);
        boolean myVal = Boolean.valueOf(propvalue);
        return myVal;
    }

    private long getLongProperty(Properties props, String propertyname, String defaultValue) {
        String propvalue = props.getProperty(propertyname, defaultValue);
        char mult = propvalue.charAt(propvalue.length() - 1);
        long multiplier = 1L;
        switch (mult) {
            case 'K': 
            case 'k': {
                propvalue = propvalue.substring(0, propvalue.length() - 1);
                multiplier = 1024L;
                break;
            }
            case 'M': 
            case 'm': {
                propvalue = propvalue.substring(0, propvalue.length() - 1);
                multiplier = 0x100000L;
                break;
            }
            case 'G': 
            case 'g': {
                propvalue = propvalue.substring(0, propvalue.length() - 1);
                multiplier = 0x40000000L;
            }
        }
        long x = 0L;
        x = Integer.parseInt(propvalue);
        return x *= multiplier;
    }

    public static CachePool getInstance() {
        return pool;
    }

    int doGarbageCollection() {
        long freemem;
        int cleaned = 0;
        Iterator iter = this.mAllCaches.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            cleaned = ((Cache)this.mCacheElements.get(element)).cleanExpiredEntries();
        }
        if (this.doMembasedCaching && this.minimumfree > 0L && (freemem = this.runtime.freeMemory()) < this.minimumfree) {
            int current_size = Cache.getTotal();
            int cleanto = current_size - 1;
            if (this.cleanpercentage_MemoryBased > 0) {
                cleanto = (int)((double)current_size * (100.0 - (double)this.cleanpercentage_MemoryBased) / 100.0);
            }
            long[] ttls = new long[this.mAllCaches.size()];
            for (int i = 0; i < ttls.length; ++i) {
                ttls[i] = ((Cache)this.mCacheElements.get((String)this.mAllCaches.elementAt(i))).top();
            }
            int index = 0;
            while (Cache.getTotal() > cleanto) {
                index = this.getSmallestIndex(ttls);
                Cache tmp = (Cache)this.mCacheElements.get(this.mAllCaches.elementAt(index));
                tmp.cleanTopEntry(-1L);
                ttls[index] = tmp.top();
                ++cleaned;
            }
        }
        if (Cache.getTotal() > this.szLimit) {
            int cleanto = this.szLimit;
            if (this.cleancachetopercentage > 0) {
                cleanto = (int)((double)this.szLimit * (100.0 - (double)this.cleancachetopercentage) / 100.0);
            }
            LinkedList templist = new LinkedList();
            long[] ttls = new long[this.mAllCaches.size()];
            for (int i = 0; i < ttls.length; ++i) {
                ttls[i] = ((Cache)this.mCacheElements.get((String)this.mAllCaches.elementAt(i))).top();
            }
            int index = 0;
            while (Cache.getTotal() > cleanto) {
                index = this.getSmallestIndex(ttls);
                Cache tmp = (Cache)this.mCacheElements.get(this.mAllCaches.elementAt(index));
                tmp.cleanTopEntry(-1L);
                ttls[index] = tmp.top();
                ++cleaned;
            }
        }
        return cleaned;
    }

    private int getSmallestIndex(long[] arr) {
        int low = 0;
        for (int i = 1; i < arr.length; ++i) {
            if (arr[i] >= arr[low]) continue;
            low = i;
        }
        return low;
    }

    public void printCacheHits() {
        System.out.println("Cachehits: " + cachehit + "\tTotal cachesize: " + Cache.getTotal());
    }

    public Object getEntry(String cachename, String key) {
        Cache c = (Cache)this.mCacheElements.get(cachename);
        if (c != null) {
            ++cacheChecks;
            Object entry = c.getEntry(key);
            if (entry != null) {
                ++cachehit;
            }
            return entry;
        }
        return null;
    }

    public boolean cacheEntry(String cachename, String key, Object o) {
        Cache c;
        if (this.doMembasedCaching && this.minimumfree > 0L) {
            long freemem = this.runtime.freeMemory();
            if (freemem < this.absoluteminimumfree) {
                this.runGarbageCollector();
                ++this.rejected;
                return false;
            }
            if (freemem < this.minimumfree) {
                this.runGarbageCollector();
            }
        }
        if ((c = (Cache)this.mCacheElements.get(cachename)) == null) {
            return false;
        }
        MVDLogger.Debug("Caching, KEY:" + key, 1);
        return c.addEntry(key, o);
    }

    public boolean createCache(String name, int ttl) {
        if (!this.mCacheElements.containsKey(name)) {
            this.mCacheElements.put(name, new Cache(ttl, this.szLimit));
            this.mAllCaches.add(name);
            return true;
        }
        return false;
    }

    private void fireGarbageCollector() {
        this.garbageCollector = CacheThread.getInstance(this);
        this.garbageCollector.start();
    }

    boolean allowExceedingCacheLimit() {
        if (this.cleancachetopercentage >= 0) {
            this.garbageCollector.forcedclean();
            return true;
        }
        return false;
    }

    int getCacheLimit() {
        return this.szLimit;
    }

    public void deleteFromCache(String cachename, String key) {
        Cache c = (Cache)this.mCacheElements.get(cachename);
        if (c != null) {
            c.deleteEntryFromCache(key);
        }
    }

    public int getCacheSize() {
        return Cache.getTotal();
    }

    public long getCacheHits() {
        return cachehit;
    }

    public long getCacheReadOperations() {
        return cacheChecks;
    }

    public long getCacheWrites() {
        return Cache.getWrites();
    }

    public boolean cleanAllEntries(String dsname) {
        Cache c = (Cache)this.mCacheElements.get(dsname);
        if (c != null) {
            return c.cleanAllEntries();
        }
        return false;
    }

    public void removeCache(String name) {
        this.mCacheElements.remove(name);
        this.mAllCaches.remove(name);
    }

    public void runGarbageCollector() {
        if (this.garbageCollector != null) {
            this.garbageCollector.forcedclean();
        }
    }

    int getCleaninterval() {
        return this.cleaninterval;
    }

    public int getGCCleanedEntriesTreshold() {
        return this.garbage_collect;
    }

    public void setAbsoluteminimumfree(long absoluteminimumfree) {
        this.absoluteminimumfree = absoluteminimumfree;
    }

    public void setCleancachetopercentage(int cleancachetopercentage) {
        this.cleancachetopercentage = cleancachetopercentage;
    }

    public void setCleaninterval(int cleaninterval) {
        this.cleaninterval = cleaninterval;
    }

    public void setCleanpercentage_MemoryBased(int cleanpercentage_MemoryBased) {
        this.cleanpercentage_MemoryBased = cleanpercentage_MemoryBased;
    }

    public void setGarbage_collect(int garbage_collect) {
        this.garbage_collect = garbage_collect;
    }

    public void setMinimumfree(long minimumfree) {
        this.minimumfree = minimumfree;
    }

    public void setSzLimit(int szLimit) {
        this.szLimit = szLimit;
    }

    public long getTotalCleaned() {
        return this.garbageCollector.getTotalCleaned();
    }

    public long getRejected() {
        return Cache.getRejected() + (long)this.rejected;
    }

    public void shutdown() {
        if (this.garbageCollector != null) {
            this.garbageCollector.shutdown();
        }
    }

    static {
        cachehit = 0L;
        cacheChecks = 0L;
    }
}

