/*
 * Decompiled with CFR 0.152.
 */
package com.sap.idm.vds.cache.impl;

import com.sap.idm.vds.cache.impl.CachePool;
import com.sap.idm.vds.cache.impl.CacheTTLEntry;
import com.sap.idm.vds.cache.impl.WrappedCacheEntry;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class Cache {
    private static int totalcachesize = 0;
    private static long cachewrites = 0L;
    boolean default_caching = false;
    int ttl = 60;
    private HashMap mDNmap;
    private LinkedList cacheQueue;
    private int szLimit;
    public static long rejected = 0L;

    public Cache(int ttl, int szLimit) {
        this.ttl = ttl;
        this.szLimit = szLimit;
        this.mDNmap = new HashMap((int)((double)szLimit / 0.75), 0.8f);
        this.cacheQueue = new LinkedList();
    }

    private static synchronized void incrementTotal() {
        ++totalcachesize;
        ++cachewrites;
    }

    private static synchronized void decrementTotal() {
        --totalcachesize;
    }

    private static synchronized void decreaseCacheSize(int cachesize) {
        totalcachesize -= cachesize;
    }

    public static int getTotal() {
        return totalcachesize;
    }

    public static long getWrites() {
        return cachewrites;
    }

    public boolean addEntry(String key, Object o) {
        int total = Cache.getTotal() + 1;
        if ((double)total > (double)this.szLimit * 1.02) {
            ++rejected;
            return false;
        }
        if (total > this.szLimit && !CachePool.getInstance().allowExceedingCacheLimit()) {
            return false;
        }
        long timestamp = System.currentTimeMillis();
        this.putEntry(key, o, timestamp);
        return true;
    }

    public synchronized void putEntry(String key, Object entry, long expires) {
        if (!this.mDNmap.containsKey(key.toLowerCase())) {
            CacheTTLEntry ttl = new CacheTTLEntry(key.toLowerCase(), expires);
            this.cacheQueue.add(ttl);
            WrappedCacheEntry hmapentry = new WrappedCacheEntry(entry, ttl);
            this.mDNmap.put(key.toLowerCase(), hmapentry);
            Cache.incrementTotal();
        }
    }

    public synchronized Object getEntry(String key) {
        WrappedCacheEntry entry = (WrappedCacheEntry)this.mDNmap.get(key.toLowerCase());
        if (entry == null) {
            return null;
        }
        return entry.entry;
    }

    public synchronized boolean cleanTopEntry(long curtime) {
        try {
            CacheTTLEntry entry = (CacheTTLEntry)this.cacheQueue.getFirst();
            if (entry != null) {
                if (entry.mKey == null) {
                    this.cacheQueue.removeFirst();
                    return true;
                }
                if (entry != null && (curtime == -1L || entry.mTimeStamp + (long)(this.ttl * 1000) < curtime)) {
                    this.mDNmap.remove(entry.mKey);
                    this.cacheQueue.removeFirst();
                    Cache.decrementTotal();
                    return true;
                }
            }
            return false;
        }
        catch (NoSuchElementException e) {
            return false;
        }
    }

    public synchronized void deleteEntryFromCache(String dn) {
        WrappedCacheEntry entry = (WrappedCacheEntry)this.mDNmap.remove(dn.toLowerCase());
        if (entry != null) {
            entry.ttlobject.mKey = null;
            Cache.decrementTotal();
        }
    }

    public int cleanExpiredEntries() {
        long curtime = System.currentTimeMillis();
        int count = 0;
        while (this.cleanTopEntry(curtime)) {
            ++count;
        }
        return count;
    }

    public long top() {
        try {
            long earliestexpire = ((CacheTTLEntry)this.cacheQueue.getFirst()).mTimeStamp + (long)(this.ttl * 1000);
            return earliestexpire;
        }
        catch (NoSuchElementException e) {
            return Long.MAX_VALUE;
        }
    }

    public synchronized boolean cleanAllEntries() {
        try {
            int cachesize = this.mDNmap.size();
            this.cacheQueue.clear();
            this.mDNmap.clear();
            Cache.decreaseCacheSize(cachesize);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setTTL(int ttl) {
        this.ttl = ttl;
    }

    public static long getRejected() {
        return rejected;
    }
}

